/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RendererBridge;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.ast.ProvidesAffixes;
import org.neo4j.cypherdsl.core.ast.TypedSubtree;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

public final class Hint
implements Visitable {
    private final Type type;
    private final IndexReferences indexReferences;
    private final IndexProperties optionalProperties;

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }

    public static Hint useIndexFor(boolean seek, Property ... properties) {
        Assertions.notEmpty(properties, "Cannot use an index without properties!");
        ArrayList<SymbolicName> deferencedProperties = new ArrayList<SymbolicName>();
        IndexReference indexReference = null;
        for (Property property : properties) {
            NodeLabel label;
            Named container = property.getContainer();
            Assertions.notNull(container, "Cannot use a property without a reference to a container inside an index hint.");
            Assertions.isTrue(property.getNames().size() == 1, "One single property is required. Nested properties are not supported.");
            if (container instanceof Node) {
                Node node = (Node)container;
                List<NodeLabel> labels = node.getLabels();
                Assertions.isTrue(labels.size() == 1, "Exactly one label is required to define the index.");
                label = labels.get(0);
            } else if (container instanceof Relationship) {
                Relationship relationship = (Relationship)container;
                List<String> types = relationship.getDetails().getTypes();
                Assertions.isTrue(types.size() == 1, "Exactly one type is required to define the index.");
                label = new NodeLabel(types.get(0));
            } else {
                throw new IllegalArgumentException("A property index can only be used for Nodes or Relationships.");
            }
            SymbolicName symbolicName = container.getRequiredSymbolicName();
            if (indexReference == null) {
                indexReference = new IndexReference(symbolicName, label);
            } else if (!indexReference.pointsToSameContainer(symbolicName, label)) {
                throw new IllegalStateException("If you want to use more than one index on different nodes you must use multiple `USING INDEX` statements.");
            }
            deferencedProperties.add(property.getNames().get(0).getPropertyKeyName());
        }
        return new Hint(seek ? Type.INDEX_SEEK : Type.INDEX, Collections.singletonList(indexReference), new IndexProperties((List<SymbolicName>)deferencedProperties));
    }

    public static Hint useScanFor(Node node) {
        Assertions.notNull(node, "Cannot apply a SCAN hint without a node.");
        List<NodeLabel> labels = node.getLabels();
        Assertions.isTrue(labels.size() == 1, "Exactly one label is required for a SCAN hint.");
        return new Hint(Type.SCAN, Collections.singletonList(new IndexReference(node.getRequiredSymbolicName(), labels.get(0))), null);
    }

    public static Hint useJoinOn(SymbolicName ... name) {
        Assertions.notEmpty(name, "At least one name is required to define a JOIN hint.");
        return new Hint(Type.JOIN_ON, Arrays.stream(name).map(IndexReference::new).toList(), null);
    }

    private Hint(Type type, List<IndexReference> indexReferences, IndexProperties optionalProperties) {
        this.type = type;
        this.indexReferences = new IndexReferences(indexReferences);
        this.optionalProperties = optionalProperties;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.type.accept(visitor);
        this.indexReferences.accept(visitor);
        Visitable.visitIfNotNull(this.optionalProperties, visitor);
        visitor.leave(this);
    }

    private static final class IndexReference
    implements Visitable {
        private final SymbolicName symbolicName;
        private final NodeLabel optionalLabel;

        IndexReference(SymbolicName symbolicName) {
            this(symbolicName, null);
        }

        IndexReference(SymbolicName symbolicName, NodeLabel optionalLabel) {
            this.symbolicName = symbolicName;
            this.optionalLabel = optionalLabel;
        }

        boolean pointsToSameContainer(SymbolicName otherSymbolicName, NodeLabel otherLabel) {
            return this.symbolicName.equals(otherSymbolicName) && Objects.equals(this.optionalLabel, otherLabel);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            this.symbolicName.accept(visitor);
            Visitable.visitIfNotNull(this.optionalLabel, visitor);
            visitor.leave(this);
        }

        @Override
        public String toString() {
            return RendererBridge.render(this);
        }
    }

    private static enum Type implements Visitable
    {
        INDEX,
        INDEX_SEEK,
        SCAN,
        JOIN_ON;


        @Override
        public String toString() {
            return RendererBridge.render(this);
        }
    }

    private static final class IndexProperties
    extends TypedSubtree<SymbolicName>
    implements ProvidesAffixes {
        IndexProperties(List<SymbolicName> properties) {
            super(properties);
        }

        @Override
        public Optional<String> getPrefix() {
            return Optional.of("(");
        }

        @Override
        public Optional<String> getSuffix() {
            return Optional.of(")");
        }
    }

    private static final class IndexReferences
    extends TypedSubtree<IndexReference> {
        IndexReferences(List<IndexReference> indexReferences) {
            super(indexReferences);
        }
    }
}

