/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Arguments;
import org.neo4j.cypherdsl.core.Asterisk;
import org.neo4j.cypherdsl.core.Clause;
import org.neo4j.cypherdsl.core.Clauses;
import org.neo4j.cypherdsl.core.CompoundCondition;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Create;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.DefaultLoadCSVStatementBuilder;
import org.neo4j.cypherdsl.core.Delete;
import org.neo4j.cypherdsl.core.ExistentialSubquery;
import org.neo4j.cypherdsl.core.ExposesAndThen;
import org.neo4j.cypherdsl.core.ExposesFinish;
import org.neo4j.cypherdsl.core.ExposesReturning;
import org.neo4j.cypherdsl.core.ExposesSubqueryCall;
import org.neo4j.cypherdsl.core.ExposesWhere;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.Finish;
import org.neo4j.cypherdsl.core.Foreach;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Hint;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Limit;
import org.neo4j.cypherdsl.core.LoadCSVStatementBuilder;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Merge;
import org.neo4j.cypherdsl.core.MergeAction;
import org.neo4j.cypherdsl.core.MultiPartElement;
import org.neo4j.cypherdsl.core.MultiPartQuery;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NumberLiteral;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.Order;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.ProcedureCallImpl;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.Remove;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Set;
import org.neo4j.cypherdsl.core.SinglePartQuery;
import org.neo4j.cypherdsl.core.Skip;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.Subquery;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Unwind;
import org.neo4j.cypherdsl.core.UpdatingClause;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.internal.ProcedureName;
import org.neo4j.cypherdsl.core.internal.YieldItems;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.INTERNAL, since="2021.2.1")
class DefaultStatementBuilder
implements StatementBuilder,
StatementBuilder.OngoingUpdate,
StatementBuilder.OngoingMerge,
StatementBuilder.OngoingReadingWithWhere,
StatementBuilder.OngoingReadingWithoutWhere,
StatementBuilder.OngoingMatchAndUpdate,
StatementBuilder.BuildableMatchAndUpdate,
StatementBuilder.BuildableOngoingMergeAction,
ExposesSubqueryCall.BuildableSubquery,
StatementBuilder.VoidCall,
StatementBuilder.Terminal {
    private final List<Visitable> currentSinglePartElements = new ArrayList<Visitable>();
    private MatchBuilder currentOngoingMatch;
    private DefaultStatementWithUpdateBuilder currentOngoingUpdate;
    private final List<MultiPartElement> multiPartElements = new ArrayList<MultiPartElement>();
    private static final EnumSet<UpdateType> MERGE_OR_CREATE = EnumSet.of(UpdateType.CREATE, UpdateType.MERGE);
    private static final EnumSet<UpdateType> SET = EnumSet.of(UpdateType.SET, UpdateType.MUTATE);

    DefaultStatementBuilder(Visitable ... visitables) {
        this.addVisitables(visitables);
    }

    DefaultStatementBuilder(DefaultStatementBuilder source, Visitable ... visitables) {
        this.currentSinglePartElements.addAll(source.currentSinglePartElements);
        this.currentOngoingMatch = source.currentOngoingMatch;
        this.currentOngoingUpdate = source.currentOngoingUpdate;
        this.multiPartElements.addAll(source.multiPartElements);
        this.addVisitables(visitables);
    }

    private void addVisitables(Visitable[] visitables) {
        for (Visitable visitable : visitables) {
            if (visitable == null) continue;
            this.currentSinglePartElements.add(visitable);
        }
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
        Assertions.notNull(pattern, "Patterns to match are required.");
        Assertions.notEmpty(pattern, "At least one pattern to match is required.");
        this.closeCurrentOngoingMatch();
        this.currentOngoingMatch = new MatchBuilder(optional);
        this.currentOngoingMatch.patternList.addAll(Arrays.asList(pattern));
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
        return this.update(UpdateType.CREATE, pattern);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingUpdate create(Collection<? extends PatternElement> pattern) {
        return this.create(pattern.toArray(new PatternElement[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
        return this.update(UpdateType.MERGE, pattern);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingMergeAction onCreate() {
        return this.ongoingOnAfterMerge(MergeAction.Type.ON_CREATE);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingMergeAction onMatch() {
        return this.ongoingOnAfterMerge(MergeAction.Type.ON_MATCH);
    }

    private StatementBuilder.OngoingMergeAction ongoingOnAfterMerge(final MergeAction.Type type) {
        Assertions.notNull(this.currentOngoingUpdate, "MERGE must have been invoked before defining an event.");
        Assertions.isTrue(this.currentOngoingUpdate.builder instanceof SupportsActionsOnTheUpdatingClause, "MERGE must have been invoked before defining an event.");
        return new StatementBuilder.OngoingMergeAction(){

            @Override
            @NotNull
            public StatementBuilder.BuildableOngoingMergeAction set(Node node, String ... labels) {
                return this.set(Operations.set(node, labels));
            }

            @Override
            @NotNull
            public StatementBuilder.BuildableOngoingMergeAction set(Node node, Collection<String> labels) {
                return this.set(Operations.set(node, labels.toArray(new String[0])));
            }

            @Override
            @NotNull
            public StatementBuilder.BuildableOngoingMergeAction mutate(Expression target, Expression properties) {
                ((SupportsActionsOnTheUpdatingClause)((Object)DefaultStatementBuilder.this.currentOngoingUpdate.builder)).on(type, UpdateType.MUTATE, target, properties);
                return DefaultStatementBuilder.this;
            }

            @Override
            @NotNull
            public StatementBuilder.BuildableOngoingMergeAction set(Expression ... expressions) {
                ((SupportsActionsOnTheUpdatingClause)((Object)DefaultStatementBuilder.this.currentOngoingUpdate.builder)).on(type, UpdateType.SET, expressions);
                return DefaultStatementBuilder.this;
            }

            @Override
            @NotNull
            public StatementBuilder.BuildableOngoingMergeAction set(Collection<? extends Expression> expressions) {
                return this.set(expressions.toArray(new Expression[0]));
            }
        };
    }

    @Override
    public final StatementBuilder.OngoingUnwind unwind(Expression expression) {
        this.closeCurrentOngoingMatch();
        return new DefaultOngoingUnwind(expression);
    }

    private DefaultStatementBuilder update(UpdateType updateType, Object[] pattern) {
        Assertions.notNull(pattern, "Patterns to create are required.");
        Assertions.notEmpty(pattern, "At least one pattern to create is required.");
        this.closeCurrentOngoingMatch();
        this.closeCurrentOngoingUpdate();
        if (pattern.getClass().getComponentType() == PatternElement.class) {
            this.currentOngoingUpdate = new DefaultStatementWithUpdateBuilder(updateType, (PatternElement[])pattern);
        } else if (Expression.class.isAssignableFrom(pattern.getClass().getComponentType())) {
            this.currentOngoingUpdate = new DefaultStatementWithUpdateBuilder(updateType, (Expression[])pattern);
        }
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingAndReturn returning(Collection<? extends Expression> elements) {
        return this.returning(false, false, elements);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingAndReturn returningDistinct(Collection<? extends Expression> elements) {
        return this.returning(false, true, elements);
    }

    @Override
    @NotNull
    public StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
        return new DefaultStatementWithReturnBuilder(rawExpression);
    }

    private StatementBuilder.OngoingReadingAndReturn returning(boolean raw, boolean distinct, Collection<? extends Expression> elements) {
        DefaultStatementWithReturnBuilder ongoingMatchAndReturn = new DefaultStatementWithReturnBuilder(raw, distinct);
        ongoingMatchAndReturn.addExpressions(elements);
        return ongoingMatchAndReturn;
    }

    @Override
    @NotNull
    public final StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<IdentifiableElement> elements) {
        return this.with(false, elements);
    }

    @Override
    @NotNull
    public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Collection<IdentifiableElement> elements) {
        return this.with(true, elements);
    }

    private StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(boolean distinct, Collection<IdentifiableElement> elements) {
        DefaultStatementWithWithBuilder ongoingMatchAndWith = new DefaultStatementWithWithBuilder(distinct);
        ongoingMatchAndWith.addElements(elements);
        return ongoingMatchAndWith;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingUpdate delete(Expression ... expressions) {
        return this.update(UpdateType.DELETE, expressions);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingUpdate delete(Collection<? extends Expression> expressions) {
        return this.delete(expressions.toArray(new Expression[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingUpdate detachDelete(Expression ... expressions) {
        return this.update(UpdateType.DETACH_DELETE, expressions);
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingUpdate detachDelete(Collection<? extends Expression> expressions) {
        return this.detachDelete(expressions.toArray(new Expression[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate set(Expression ... expressions) {
        DefaultStatementWithUpdateBuilder result = new DefaultStatementWithUpdateBuilder(UpdateType.SET, expressions);
        this.closeCurrentOngoingUpdate();
        return result;
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate set(Collection<? extends Expression> expressions) {
        return this.set(expressions.toArray(new Expression[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate set(Node named, String ... labels) {
        this.closeCurrentOngoingUpdate();
        return new DefaultStatementWithUpdateBuilder(UpdateType.SET, Operations.set(named, labels));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate set(Node named, Collection<String> labels) {
        return this.set(named, labels.toArray(new String[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate mutate(Expression target, Expression properties) {
        DefaultStatementWithUpdateBuilder result = new DefaultStatementWithUpdateBuilder(UpdateType.MUTATE, Operations.mutate(target, properties));
        this.closeCurrentOngoingUpdate();
        return result;
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate remove(Property ... properties) {
        this.closeCurrentOngoingUpdate();
        return new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, properties);
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate remove(Collection<Property> properties) {
        return this.remove(properties.toArray(new Property[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate remove(Node named, String ... labels) {
        this.closeCurrentOngoingUpdate();
        return new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, Operations.remove(named, labels));
    }

    @Override
    @NotNull
    public final StatementBuilder.BuildableMatchAndUpdate remove(Node named, Collection<String> labels) {
        return this.remove(named, labels.toArray(new String[0]));
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithWhere where(Condition newCondition) {
        if (this.currentOngoingMatch == null) {
            if (!this.currentSinglePartElements.isEmpty() && this.currentSinglePartElements.get(this.currentSinglePartElements.size() - 1) instanceof Subquery) {
                throw new IllegalArgumentException("A CALL{} clause requires to WITH before you can add further conditions");
            }
            throw new IllegalArgumentException("Cannot adda WHERE clause at this point");
        }
        this.currentOngoingMatch.conditionBuilder.where(newCondition);
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithWhere and(Condition additionalCondition) {
        this.currentOngoingMatch.conditionBuilder.and(additionalCondition);
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithWhere or(Condition additionalCondition) {
        this.currentOngoingMatch.conditionBuilder.or(additionalCondition);
        return this;
    }

    @Override
    @NotNull
    public Statement build() {
        return this.buildImpl(null);
    }

    protected final Statement buildImpl(Clause returnOrFinish) {
        SinglePartQuery singlePartQuery = SinglePartQuery.create(this.buildListOfVisitables(false), returnOrFinish);
        if (this.multiPartElements.isEmpty()) {
            return singlePartQuery;
        }
        return MultiPartQuery.create(this.multiPartElements, singlePartQuery);
    }

    protected final List<Visitable> buildListOfVisitables(boolean clearAfter) {
        ArrayList<Visitable> visitables = new ArrayList<Visitable>(this.currentSinglePartElements);
        if (this.currentOngoingMatch != null) {
            visitables.add(this.currentOngoingMatch.buildMatch());
        }
        if (this.currentOngoingUpdate != null) {
            visitables.add(this.currentOngoingUpdate.builder.build());
        }
        if (clearAfter) {
            this.currentOngoingMatch = null;
            this.currentOngoingUpdate = null;
            this.currentSinglePartElements.clear();
        }
        return visitables;
    }

    protected final DefaultStatementBuilder addWith(Optional<With> optionalWith) {
        optionalWith.ifPresent(with -> this.multiPartElements.add(new MultiPartElement(this.buildListOfVisitables(true), (With)with)));
        return this;
    }

    protected final void addUpdatingClause(UpdatingClause updatingClause) {
        this.closeCurrentOngoingMatch();
        this.currentSinglePartElements.add(updatingClause);
    }

    @Override
    @NotNull
    public ExposesSubqueryCall.BuildableSubquery call(Statement statement, IdentifiableElement ... imports) {
        this.closeCurrentOngoingMatch();
        this.closeCurrentOngoingUpdate();
        this.currentSinglePartElements.add(Subquery.call(statement, imports));
        return this;
    }

    @Override
    @NotNull
    public ExposesSubqueryCall.BuildableSubquery callRawCypher(String rawCypher, Object ... args) {
        this.closeCurrentOngoingMatch();
        this.closeCurrentOngoingUpdate();
        this.currentSinglePartElements.add(Subquery.raw(rawCypher, args));
        return this;
    }

    @Override
    @NotNull
    public ExposesSubqueryCall.BuildableSubquery callInTransactions(Statement statement, Integer rows, IdentifiableElement ... imports) {
        this.closeCurrentOngoingMatch();
        this.closeCurrentOngoingUpdate();
        this.currentSinglePartElements.add(Subquery.call(statement, imports).inTransactionsOf(rows));
        return this;
    }

    private void closeCurrentOngoingMatch() {
        if (this.currentOngoingMatch == null) {
            return;
        }
        this.currentSinglePartElements.add(this.currentOngoingMatch.buildMatch());
        this.currentOngoingMatch = null;
    }

    private void closeCurrentOngoingUpdate() {
        if (this.currentOngoingUpdate == null) {
            return;
        }
        this.currentSinglePartElements.add(this.currentOngoingUpdate.builder.build());
        this.currentOngoingUpdate = null;
    }

    @Override
    @NotNull
    public final Condition asCondition() {
        if (this.currentOngoingMatch == null || !this.currentSinglePartElements.isEmpty()) {
            throw new IllegalArgumentException("Only simple MATCH statements can be used as existential subqueries.");
        }
        return ExistentialSubquery.exists(this.currentOngoingMatch.buildMatch());
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithoutWhere usingIndex(Property ... properties) {
        this.currentOngoingMatch.hints.add(Hint.useIndexFor(false, properties));
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithoutWhere usingIndexSeek(Property ... properties) {
        this.currentOngoingMatch.hints.add(Hint.useIndexFor(true, properties));
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithoutWhere usingScan(Node node) {
        this.currentOngoingMatch.hints.add(Hint.useScanFor(node));
        return this;
    }

    @Override
    @NotNull
    public final StatementBuilder.OngoingReadingWithoutWhere usingJoinOn(SymbolicName ... names) {
        this.currentOngoingMatch.hints.add(Hint.useJoinOn(names));
        return this;
    }

    @Override
    @NotNull
    public StatementBuilder.ForeachSourceStep foreach(SymbolicName variable) {
        this.closeCurrentOngoingMatch();
        this.closeCurrentOngoingUpdate();
        return new ForeachBuilder(variable);
    }

    @Override
    @NotNull
    public StatementBuilder.Terminal finish() {
        return new DefaultStatementWithFinishBuilder();
    }

    @SafeVarargs
    private static <T extends Visitable> UpdatingClauseBuilder getUpdatingClauseBuilder(UpdateType updateType, T ... patternOrExpressions) {
        boolean mergeOrCreate = MERGE_OR_CREATE.contains((Object)updateType);
        String message = mergeOrCreate ? "At least one pattern is required." : "At least one modifying expressions is required.";
        Assertions.notNull(patternOrExpressions, message);
        Assertions.notEmpty(patternOrExpressions, message);
        if (mergeOrCreate) {
            List<PatternElement> patternElements = Arrays.stream(patternOrExpressions).map(PatternElement.class::cast).toList();
            if (updateType == UpdateType.CREATE) {
                return new AbstractUpdatingClauseBuilder.CreateBuilder(patternElements);
            }
            return new AbstractUpdatingClauseBuilder.MergeBuilder(patternElements);
        }
        List<Expression> expressions = Arrays.stream(patternOrExpressions).map(Expression.class::cast).toList();
        ExpressionList expressionList = new ExpressionList(SET.contains((Object)updateType) ? DefaultStatementBuilder.prepareSetExpressions(updateType, expressions) : expressions);
        return switch (updateType) {
            case UpdateType.DETACH_DELETE -> () -> new Delete(expressionList, true);
            case UpdateType.DELETE -> () -> new Delete(expressionList, false);
            case UpdateType.SET, UpdateType.MUTATE -> () -> new Set(expressionList);
            case UpdateType.REMOVE -> () -> new Remove(expressionList);
            default -> throw new IllegalArgumentException("Unsupported update type " + String.valueOf((Object)updateType));
        };
    }

    private static List<Expression> prepareSetExpressions(UpdateType updateType, List<Expression> possibleSetOperations) {
        ArrayList<Expression> propertyOperations = new ArrayList<Expression>();
        ArrayList<Expression> listOfExpressions = new ArrayList<Expression>();
        for (Expression possibleSetOperation : possibleSetOperations) {
            if (possibleSetOperation instanceof Operation) {
                propertyOperations.add(possibleSetOperation);
                continue;
            }
            listOfExpressions.add(possibleSetOperation);
        }
        if (listOfExpressions.size() % 2 != 0) {
            throw new IllegalArgumentException("The list of expression to set must be even.");
        }
        if (updateType == UpdateType.SET) {
            for (int i = 0; i < listOfExpressions.size(); i += 2) {
                propertyOperations.add(Operations.set((Expression)listOfExpressions.get(i), (Expression)listOfExpressions.get(i + 1)));
            }
        } else if (updateType == UpdateType.MUTATE) {
            if (!listOfExpressions.isEmpty() && !propertyOperations.isEmpty()) {
                throw new IllegalArgumentException("A mutating SET must be build through a single operation or through a pair of expression, not both.");
            }
            if (listOfExpressions.isEmpty()) {
                for (Expression operation : propertyOperations) {
                    if (((Operation)operation).getOperator() == Operator.MUTATE) continue;
                    throw new IllegalArgumentException("Only property operations based on the " + String.valueOf(Operator.MUTATE) + " are supported inside a mutating SET.");
                }
            } else {
                for (int i = 0; i < listOfExpressions.size(); i += 2) {
                    Expression rhs = (Expression)listOfExpressions.get(i + 1);
                    if (rhs instanceof Parameter) {
                        propertyOperations.add(Operations.mutate((Expression)listOfExpressions.get(i), rhs));
                        continue;
                    }
                    if (rhs instanceof MapExpression) {
                        MapExpression mapExpression = (MapExpression)rhs;
                        propertyOperations.add(Operations.mutate((Expression)listOfExpressions.get(i), mapExpression));
                        continue;
                    }
                    throw new IllegalArgumentException("A mutating SET operation can only be used with a named parameter or a map expression.");
                }
            }
        }
        if (updateType != UpdateType.REMOVE && propertyOperations.stream().anyMatch(e -> {
            Operation op;
            return e instanceof Operation && (op = (Operation)e).getOperator() == Operator.REMOVE_LABEL;
        })) {
            throw new IllegalArgumentException("REMOVE operations are not supported in a SET clause");
        }
        return propertyOperations;
    }

    @NotNull
    private static Collection<Expression> extractIdentifiablesFromReturnList(List<Expression> returnList) {
        return returnList.stream().filter(IdentifiableElement.class::isInstance).map(IdentifiableElement.class::cast).map(IdentifiableElement::asExpression).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public InQueryCallBuilder call(String ... namespaceAndProcedure) {
        Assertions.notEmpty(namespaceAndProcedure, "The procedure namespace and name must not be null or empty.");
        this.closeCurrentOngoingMatch();
        return new InQueryCallBuilder(ProcedureName.from(namespaceAndProcedure));
    }

    static final class MatchBuilder {
        private final List<PatternElement> patternList = new ArrayList<PatternElement>();
        private final List<Hint> hints = new ArrayList<Hint>();
        private final ConditionBuilder conditionBuilder = new ConditionBuilder();
        private final boolean optional;

        MatchBuilder(boolean optional) {
            this.optional = optional;
        }

        Match buildMatch() {
            return (Match)Clauses.match(this.optional, this.patternList, Where.from(this.conditionBuilder.buildCondition().orElse(null)), this.hints);
        }
    }

    protected final class DefaultStatementWithUpdateBuilder
    implements StatementBuilder.BuildableMatchAndUpdate {
        final UpdatingClauseBuilder builder;

        private DefaultStatementWithUpdateBuilder(UpdateType updateType, PatternElement ... pattern) {
            this.builder = DefaultStatementBuilder.getUpdatingClauseBuilder((UpdateType)updateType, (Visitable[])pattern);
        }

        private DefaultStatementWithUpdateBuilder(UpdateType updateType, Expression ... expressions) {
            this.builder = DefaultStatementBuilder.getUpdatingClauseBuilder((UpdateType)updateType, (Visitable[])expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returning(Collection<? extends Expression> expressions) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            DefaultStatementWithReturnBuilder delegate = new DefaultStatementWithReturnBuilder(false, false);
            delegate.addExpressions(expressions);
            return delegate;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Collection<? extends Expression> elements) {
            DefaultStatementWithReturnBuilder delegate = (DefaultStatementWithReturnBuilder)this.returning(elements);
            delegate.distinct = true;
            return delegate;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return new DefaultStatementWithReturnBuilder(rawExpression);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate delete(Expression ... deletedExpressions) {
            return this.delete(false, deletedExpressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate delete(Collection<? extends Expression> deletedExpressions) {
            return this.delete(deletedExpressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate detachDelete(Expression ... deletedExpressions) {
            return this.delete(true, deletedExpressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate detachDelete(Collection<? extends Expression> deletedExpressions) {
            return this.detachDelete(deletedExpressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.merge(pattern);
        }

        private StatementBuilder.OngoingUpdate delete(boolean nextDetach, Expression ... deletedExpressions) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.update(nextDetach ? UpdateType.DETACH_DELETE : UpdateType.DELETE, deletedExpressions);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Expression ... keyValuePairs) {
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            DefaultStatementWithUpdateBuilder result = defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.SET, keyValuePairs);
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return result;
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Collection<? extends Expression> keyValuePairs) {
            return this.set(keyValuePairs.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Node node, String ... labels) {
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            DefaultStatementWithUpdateBuilder result = defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.SET, Operations.set(node, labels));
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return result;
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Node node, Collection<String> labels) {
            return this.set(node, labels.toArray(new String[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate mutate(Expression target, Expression properties) {
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            DefaultStatementWithUpdateBuilder result = defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.MUTATE, Operations.mutate(target, properties));
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return result;
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Node node, String ... labels) {
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            DefaultStatementWithUpdateBuilder result = defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, Operations.set(node, labels));
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return result;
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Node node, Collection<String> labels) {
            return this.remove(node, labels.toArray(new String[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Property ... properties) {
            DefaultStatementBuilder defaultStatementBuilder = DefaultStatementBuilder.this;
            Objects.requireNonNull(defaultStatementBuilder);
            DefaultStatementWithUpdateBuilder result = defaultStatementBuilder.new DefaultStatementWithUpdateBuilder(UpdateType.REMOVE, properties);
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return result;
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Collection<Property> properties) {
            return this.remove(properties.toArray(new Property[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<IdentifiableElement> returnedExpressions) {
            return this.with(false, returnedExpressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Collection<IdentifiableElement> elements) {
            return this.with(true, elements);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.create(pattern);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate create(Collection<? extends PatternElement> pattern) {
            return this.create(pattern.toArray(new PatternElement[0]));
        }

        private StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(boolean distinct, Collection<IdentifiableElement> elements) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.with(distinct, elements);
        }

        @Override
        @NotNull
        public Statement build() {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.buildImpl(null);
        }

        @Override
        @NotNull
        public StatementBuilder.ForeachSourceStep foreach(SymbolicName variable) {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return DefaultStatementBuilder.this.foreach(variable);
        }

        @Override
        @NotNull
        public StatementBuilder.Terminal finish() {
            DefaultStatementBuilder.this.addUpdatingClause(this.builder.build());
            return new DefaultStatementWithFinishBuilder();
        }
    }

    static enum UpdateType {
        DELETE,
        DETACH_DELETE,
        SET,
        MUTATE,
        REMOVE,
        CREATE,
        MERGE;

    }

    private static interface UpdatingClauseBuilder {
        public UpdatingClause build();
    }

    static interface SupportsActionsOnTheUpdatingClause {
        public SupportsActionsOnTheUpdatingClause on(MergeAction.Type var1, UpdateType var2, Expression ... var3);
    }

    final class DefaultOngoingUnwind
    implements StatementBuilder.OngoingUnwind {
        private final Expression expressionToUnwind;

        DefaultOngoingUnwind(Expression expressionToUnwind) {
            this.expressionToUnwind = expressionToUnwind;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReading as(@NotNull String variable) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(new Unwind(this.expressionToUnwind, variable));
            return DefaultStatementBuilder.this;
        }
    }

    protected class DefaultStatementWithReturnBuilder
    extends ReturnListWrapper
    implements StatementBuilder.OngoingReadingAndReturn,
    StatementBuilder.TerminalOngoingOrderDefinition,
    StatementBuilder.OngoingMatchAndReturnWithOrder {
        protected final OrderBuilder orderBuilder = new OrderBuilder();
        protected boolean rawReturn;
        protected boolean distinct;

        protected DefaultStatementWithReturnBuilder(Expression rawReturnExpression) {
            this.distinct = false;
            this.rawReturn = true;
            this.returnList.add(rawReturnExpression);
        }

        protected DefaultStatementWithReturnBuilder(boolean rawReturn, boolean distinct) {
            this.distinct = distinct;
            this.rawReturn = rawReturn;
        }

        @Override
        public Collection<Expression> getIdentifiableExpressions() {
            return DefaultStatementBuilder.extractIdentifiablesFromReturnList(this.returnList);
        }

        @Override
        @NotNull
        public final StatementBuilder.OngoingMatchAndReturnWithOrder orderBy(SortItem ... sortItem) {
            this.orderBuilder.orderBy(sortItem);
            return this;
        }

        @Override
        @NotNull
        public final StatementBuilder.OngoingMatchAndReturnWithOrder orderBy(Collection<SortItem> sortItem) {
            return this.orderBy(sortItem.toArray(new SortItem[0]));
        }

        @Override
        @NotNull
        public final StatementBuilder.TerminalOngoingOrderDefinition orderBy(@NotNull Expression expression) {
            this.orderBuilder.orderBy(expression);
            return this;
        }

        @Override
        @NotNull
        public final StatementBuilder.TerminalOngoingOrderDefinition and(@NotNull Expression expression) {
            this.orderBuilder.and(expression);
            return this;
        }

        @Override
        @NotNull
        public final DefaultStatementWithReturnBuilder descending() {
            this.orderBuilder.descending();
            return this;
        }

        @Override
        @NotNull
        public final DefaultStatementWithReturnBuilder ascending() {
            this.orderBuilder.ascending();
            return this;
        }

        @Override
        @NotNull
        public final StatementBuilder.OngoingReadingAndReturn skip(Number number) {
            return this.skip(number == null ? null : new NumberLiteral(number));
        }

        @Override
        @NotNull
        public final StatementBuilder.OngoingReadingAndReturn skip(Expression expression) {
            this.orderBuilder.skip(expression);
            return this;
        }

        @NotNull
        public final StatementBuilder.OngoingReadingAndReturn limit(Number number) {
            return this.limit(number == null ? null : new NumberLiteral(number));
        }

        @NotNull
        public final StatementBuilder.OngoingReadingAndReturn limit(Expression expression) {
            this.orderBuilder.limit(expression);
            return this;
        }

        @Override
        @NotNull
        public ResultStatement build() {
            Return returning = Return.create(this.rawReturn, this.distinct, this.returnList, this.orderBuilder);
            return (ResultStatement)DefaultStatementBuilder.this.buildImpl(returning);
        }
    }

    protected final class DefaultStatementWithWithBuilder
    extends ReturnListWrapper
    implements StatementBuilder.OngoingOrderDefinition,
    StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere,
    StatementBuilder.OrderableOngoingReadingAndWithWithWhere,
    StatementBuilder.OngoingReadingAndWithWithWhereAndOrder,
    StatementBuilder.OngoingReadingAndWithWithSkip {
        private final ConditionBuilder conditionBuilder = new ConditionBuilder();
        private final OrderBuilder orderBuilder = new OrderBuilder();
        private final boolean distinct;

        private DefaultStatementWithWithBuilder(boolean distinct) {
            this.distinct = distinct;
        }

        private Optional<With> buildWith() {
            if (this.returnList.isEmpty()) {
                return Optional.empty();
            }
            ExpressionList returnItems = new ExpressionList(this.returnList);
            Where where = this.conditionBuilder.buildCondition().map(Where::new).orElse(null);
            Optional<With> returnedWith = Optional.of(new With(this.distinct, returnItems, this.orderBuilder.buildOrder().orElse(null), this.orderBuilder.getSkip(), this.orderBuilder.getLimit(), where));
            this.returnList.clear();
            this.orderBuilder.reset();
            return returnedWith;
        }

        @Override
        public Collection<Expression> getIdentifiableExpressions() {
            return DefaultStatementBuilder.extractIdentifiablesFromReturnList(this.returnList);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returning(Collection<? extends Expression> expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).returning(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Collection<? extends Expression> expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).returningDistinct(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).returningRaw(rawExpression);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate delete(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).delete(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate delete(Collection<? extends Expression> expressions) {
            return this.delete(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate detachDelete(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).detachDelete(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate detachDelete(Collection<? extends Expression> expressions) {
            return this.detachDelete(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Expression ... expressions) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).set(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Collection<? extends Expression> expressions) {
            return this.set(expressions.toArray(new Expression[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Node node, String ... labels) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).set(node, labels);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate set(Node node, Collection<String> labels) {
            return this.set(node, labels.toArray(new String[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate mutate(Expression target, Expression properties) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).mutate(target, properties);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Node node, String ... labels) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).remove(node, labels);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Node node, Collection<String> labels) {
            return this.remove(node, labels.toArray(new String[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Property ... properties) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).remove(properties);
        }

        @Override
        @NotNull
        public StatementBuilder.BuildableMatchAndUpdate remove(Collection<Property> properties) {
            return this.remove(properties.toArray(new Property[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<IdentifiableElement> elements) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).with(elements);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Collection<IdentifiableElement> elements) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).withDistinct(elements);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere where(@NotNull Condition newCondition) {
            this.conditionBuilder.where(newCondition);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere and(Condition additionalCondition) {
            this.conditionBuilder.and(additionalCondition);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere or(Condition additionalCondition) {
            this.conditionBuilder.or(additionalCondition);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).match(optional, pattern);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).create(pattern);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingUpdate create(Collection<? extends PatternElement> pattern) {
            return this.create(pattern.toArray(new PatternElement[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).merge(pattern);
        }

        @Override
        public StatementBuilder.OngoingUnwind unwind(Expression expression) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).unwind(expression);
        }

        @Override
        @NotNull
        public ExposesSubqueryCall.BuildableSubquery call(Statement statement, IdentifiableElement ... imports) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).call(statement, imports);
        }

        @Override
        @NotNull
        public ExposesSubqueryCall.BuildableSubquery callRawCypher(String rawCypher, Object ... args) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).callRawCypher(rawCypher, args);
        }

        @Override
        @NotNull
        public ExposesSubqueryCall.BuildableSubquery callInTransactions(Statement statement, Integer rows, IdentifiableElement ... imports) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).callInTransactions(statement, rows, imports);
        }

        @Override
        @NotNull
        public InQueryCallBuilder call(String ... namespaceAndProcedure) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).call(namespaceAndProcedure);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere orderBy(SortItem ... sortItem) {
            this.orderBuilder.orderBy(sortItem);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithWhere orderBy(Collection<SortItem> sortItem) {
            return this.orderBy(sortItem.toArray(new SortItem[0]));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingOrderDefinition orderBy(@NotNull Expression expression) {
            this.orderBuilder.orderBy(expression);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingOrderDefinition and(@NotNull Expression expression) {
            this.orderBuilder.and(expression);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndWithWithWhereAndOrder descending() {
            this.orderBuilder.descending();
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndWithWithWhereAndOrder ascending() {
            this.orderBuilder.ascending();
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndWithWithSkip skip(Number number) {
            return this.skip(number == null ? null : new NumberLiteral(number));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndWithWithSkip skip(Expression expression) {
            this.orderBuilder.skip(expression);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndWith limit(Number number) {
            return this.limit(number == null ? null : new NumberLiteral(number));
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndWith limit(Expression expression) {
            this.orderBuilder.limit(expression);
            return this;
        }

        @Override
        @NotNull
        public LoadCSVStatementBuilder.OngoingLoadCSV loadCSV(URI from, boolean withHeaders) {
            DefaultStatementBuilder this0 = DefaultStatementBuilder.this.addWith(this.buildWith());
            return new DefaultLoadCSVStatementBuilder.PrepareLoadCSVStatementImpl(from, withHeaders, this0);
        }

        @Override
        @NotNull
        public StatementBuilder.ForeachSourceStep foreach(SymbolicName variable) {
            return DefaultStatementBuilder.this.addWith(this.buildWith()).foreach(variable);
        }

        @Override
        @NotNull
        public StatementBuilder.Terminal finish() {
            return DefaultStatementBuilder.this;
        }
    }

    static final class ConditionBuilder {
        private Condition condition;

        ConditionBuilder() {
        }

        void where(Condition newCondition) {
            Assertions.notNull(newCondition, "The new condition must not be null.");
            this.condition = newCondition;
        }

        void and(Condition additionalCondition) {
            this.condition = this.condition.and(additionalCondition);
        }

        void or(Condition additionalCondition) {
            this.condition = this.condition.or(additionalCondition);
        }

        private boolean hasCondition() {
            CompoundCondition compoundCondition;
            Condition condition;
            return this.condition != null && (!((condition = this.condition) instanceof CompoundCondition) || (compoundCondition = (CompoundCondition)condition).hasConditions());
        }

        Optional<Condition> buildCondition() {
            return this.hasCondition() ? Optional.of(this.condition) : Optional.empty();
        }
    }

    final class ForeachBuilder
    implements StatementBuilder.ForeachSourceStep,
    StatementBuilder.ForeachUpdateStep {
        private final SymbolicName variable;
        private Expression list;

        ForeachBuilder(SymbolicName variable) {
            this.variable = variable;
        }

        @Override
        public StatementBuilder.ForeachUpdateStep in(@NotNull Expression newVariableList) {
            this.list = Objects.requireNonNull(newVariableList);
            return this;
        }

        @Override
        public StatementBuilder.OngoingUpdate apply(UpdatingClause ... updatingClauses) {
            if (Arrays.stream(updatingClauses).anyMatch(Foreach.class::isInstance)) {
                throw new IllegalArgumentException("FOREACH clauses may not be nested");
            }
            DefaultStatementBuilder.this.addUpdatingClause(new Foreach(this.variable, this.list, Arrays.asList(updatingClauses)));
            return DefaultStatementBuilder.this;
        }
    }

    protected final class DefaultStatementWithFinishBuilder
    implements StatementBuilder.Terminal {
        protected DefaultStatementWithFinishBuilder() {
        }

        @Override
        @NotNull
        public Statement build() {
            return (ResultStatement)DefaultStatementBuilder.this.buildImpl(Finish.create());
        }
    }

    private static abstract class AbstractUpdatingClauseBuilder<T extends UpdatingClause>
    implements UpdatingClauseBuilder {
        protected final List<PatternElement> patternElements;

        AbstractUpdatingClauseBuilder(List<PatternElement> patternElements) {
            this.patternElements = patternElements;
        }

        abstract Function<Pattern, T> getUpdatingClauseProvider();

        public T build() {
            return (T)((UpdatingClause)this.getUpdatingClauseProvider().apply(Pattern.of(this.patternElements)));
        }

        static class MergeBuilder
        extends AbstractUpdatingClauseBuilder<Merge>
        implements SupportsActionsOnTheUpdatingClause {
            private final List<MergeAction> mergeActions = new ArrayList<MergeAction>();

            MergeBuilder(List<PatternElement> patternElements) {
                super(patternElements);
            }

            @Override
            Function<Pattern, Merge> getUpdatingClauseProvider() {
                return pattern -> new Merge((Pattern)pattern, this.mergeActions);
            }

            @Override
            public SupportsActionsOnTheUpdatingClause on(MergeAction.Type type, UpdateType updateType, Expression ... expressions) {
                ExpressionList expressionList = new ExpressionList(DefaultStatementBuilder.prepareSetExpressions(updateType, Arrays.asList(expressions)));
                this.mergeActions.add(MergeAction.of(type, new Set(expressionList)));
                return this;
            }
        }

        static class CreateBuilder
        extends AbstractUpdatingClauseBuilder<Create> {
            CreateBuilder(List<PatternElement> patternElements) {
                super(patternElements);
            }

            @Override
            Function<Pattern, Create> getUpdatingClauseProvider() {
                return Create::new;
            }
        }
    }

    final class InQueryCallBuilder
    extends AbstractCallBuilder
    implements StatementBuilder.OngoingInQueryCallWithoutArguments,
    StatementBuilder.OngoingInQueryCallWithArguments,
    StatementBuilder.OngoingInQueryCallWithReturnFields {
        private YieldItems yieldItems;

        InQueryCallBuilder(ProcedureName procedureName) {
            super(procedureName);
        }

        Statement buildCall() {
            return ProcedureCallImpl.create(this.procedureName, this.createArgumentList(), this.yieldItems, this.conditionBuilder.buildCondition().map(Where::new).orElse(null));
        }

        @Override
        @NotNull
        public InQueryCallBuilder withArgs(Expression ... arguments) {
            this.arguments = arguments;
            return this;
        }

        @Override
        @NotNull
        public InQueryCallBuilder yield(SymbolicName ... resultFields) {
            this.yieldItems = YieldItems.yieldAllOf(resultFields);
            return this;
        }

        @Override
        @NotNull
        public InQueryCallBuilder yield(AliasedExpression ... aliasedResultFields) {
            this.yieldItems = YieldItems.yieldAllOf(aliasedResultFields);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithWhere where(Condition newCondition) {
            this.conditionBuilder.where(newCondition);
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returning(Collection<? extends Expression> expressions) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.returning(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Collection<? extends Expression> expressions) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.returningDistinct(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.returningRaw(rawExpression);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<IdentifiableElement> elements) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.with(elements);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Collection<IdentifiableElement> elements) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.withDistinct(elements);
        }

        @Override
        @NotNull
        public ExposesSubqueryCall.BuildableSubquery call(Statement statement, IdentifiableElement ... imports) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.call(statement, imports);
        }

        @Override
        @NotNull
        public ExposesSubqueryCall.BuildableSubquery callRawCypher(String rawCypher, Object ... args) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.callRawCypher(rawCypher, args);
        }

        @Override
        @NotNull
        public ExposesSubqueryCall.BuildableSubquery callInTransactions(Statement statement, Integer rows, IdentifiableElement ... imports) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.callInTransactions(statement, rows, imports);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.match(optional, pattern);
        }

        @Override
        public StatementBuilder.VoidCall withoutResults() {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this;
        }

        @Override
        @NotNull
        public StatementBuilder.ForeachSourceStep foreach(SymbolicName variable) {
            DefaultStatementBuilder.this.currentSinglePartElements.add(this.buildCall());
            return DefaultStatementBuilder.this.foreach(variable);
        }

        @Override
        @NotNull
        public StatementBuilder.Terminal finish() {
            return DefaultStatementBuilder.this;
        }
    }

    static final class OrderBuilder {
        final List<SortItem> sortItemList = new ArrayList<SortItem>();
        SortItem lastSortItem;
        Skip skip;
        Limit limit;

        OrderBuilder() {
        }

        void reset() {
            this.sortItemList.clear();
            this.lastSortItem = null;
            this.skip = null;
            this.limit = null;
        }

        void orderBy(SortItem ... sortItem) {
            this.sortItemList.addAll(Arrays.asList(sortItem));
        }

        void orderBy(Collection<SortItem> sortItems) {
            if (sortItems != null) {
                this.sortItemList.addAll(sortItems);
            }
        }

        void orderBy(Expression expression) {
            this.lastSortItem = Cypher.sort(expression);
        }

        void and(Expression expression) {
            this.orderBy(expression);
        }

        void descending() {
            this.sortItemList.add(this.lastSortItem.descending());
            this.lastSortItem = null;
        }

        void ascending() {
            this.sortItemList.add(this.lastSortItem.ascending());
            this.lastSortItem = null;
        }

        void skip(Expression expression) {
            if (expression != null) {
                this.skip = Skip.create(expression);
            }
        }

        void limit(Expression expression) {
            if (expression != null) {
                this.limit = Limit.create(expression);
            }
        }

        Optional<Order> buildOrder() {
            if (this.lastSortItem != null) {
                this.sortItemList.add(this.lastSortItem);
            }
            Optional<Order> result = this.sortItemList.isEmpty() ? Optional.empty() : Optional.of(new Order(this.sortItemList));
            this.sortItemList.clear();
            this.lastSortItem = null;
            return result;
        }

        Skip getSkip() {
            return this.skip;
        }

        Limit getLimit() {
            return this.limit;
        }
    }

    static final class YieldingStandaloneCallBuilder
    extends AbstractCallBuilder
    implements ExposesWhere<StatementBuilder.OngoingReadingWithWhere>,
    ExposesReturning,
    ExposesFinish,
    StatementBuilder.OngoingStandaloneCallWithReturnFields {
        private final YieldItems yieldItems;
        private DefaultStatementBuilder delegate;

        YieldingStandaloneCallBuilder(ProcedureName procedureName, Expression[] arguments, SymbolicName ... resultFields) {
            super(procedureName, arguments);
            this.yieldItems = YieldItems.yieldAllOf(resultFields);
        }

        YieldingStandaloneCallBuilder(ProcedureName procedureName, Expression[] arguments, Asterisk asterisk) {
            super(procedureName, arguments);
            this.yieldItems = YieldItems.yieldAllOf(asterisk);
        }

        YieldingStandaloneCallBuilder(ProcedureName procedureName, Expression[] arguments, AliasedExpression ... aliasedResultFields) {
            super(procedureName, arguments);
            this.yieldItems = YieldItems.yieldAllOf(aliasedResultFields);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returning(Collection<? extends Expression> expressions) {
            return new DefaultStatementBuilder(this.buildCall()).returning(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningDistinct(Collection<? extends Expression> expressions) {
            return new DefaultStatementBuilder(this.buildCall()).returningDistinct(expressions);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
            return new DefaultStatementBuilder(this.buildCall()).returningRaw(rawExpression);
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithWhere where(Condition newCondition) {
            this.conditionBuilder.where(newCondition);
            return new DefaultStatementBuilder(this.buildCall());
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<IdentifiableElement> elements) {
            return new DefaultStatementBuilder(this.buildCall()).with(elements);
        }

        @Override
        @NotNull
        public StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere withDistinct(Collection<IdentifiableElement> elements) {
            return new DefaultStatementBuilder(this.buildCall()).withDistinct(elements);
        }

        @Override
        @NotNull
        public ExposesSubqueryCall.BuildableSubquery call(Statement statement, IdentifiableElement ... imports) {
            return new DefaultStatementBuilder(this.buildCall()).call(statement, imports);
        }

        @Override
        @NotNull
        public ExposesSubqueryCall.BuildableSubquery callRawCypher(String rawCypher, Object ... args) {
            return new DefaultStatementBuilder(this.buildCall()).callRawCypher(rawCypher, args);
        }

        @Override
        @NotNull
        public ExposesSubqueryCall.BuildableSubquery callInTransactions(Statement statement, Integer rows, IdentifiableElement ... imports) {
            return new DefaultStatementBuilder(this.buildCall()).callInTransactions(statement, rows, imports);
        }

        @Override
        @NotNull
        public Statement build() {
            if (this.delegate != null) {
                return this.delegate.build();
            }
            return ProcedureCallImpl.create(this.procedureName, this.createArgumentList(), this.yieldItems, this.conditionBuilder.buildCondition().map(Where::new).orElse(null));
        }

        Statement buildCall() {
            return this.build();
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
            return new DefaultStatementBuilder(this.buildCall()).match(optional, pattern);
        }

        @Override
        public ExposesAndThen<StatementBuilder.OngoingStandaloneCallWithReturnFields, Statement> andThen(Statement statement) {
            if (this.delegate == null) {
                this.delegate = new DefaultStatementBuilder(this.buildCall());
            }
            this.delegate.currentSinglePartElements.add(statement);
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.Terminal finish() {
            return new DefaultStatementBuilder(this.buildCall());
        }
    }

    static final class StandaloneCallBuilder
    extends AbstractCallBuilder
    implements StatementBuilder.OngoingStandaloneCallWithoutArguments,
    StatementBuilder.OngoingStandaloneCallWithArguments {
        StandaloneCallBuilder(ProcedureName procedureName) {
            super(procedureName);
        }

        @Override
        @NotNull
        public StandaloneCallBuilder withArgs(Expression ... arguments) {
            this.arguments = arguments;
            return this;
        }

        @Override
        @NotNull
        public StatementBuilder.OngoingStandaloneCallWithReturnFields yield(Asterisk asterisk) {
            return new YieldingStandaloneCallBuilder(this.procedureName, this.arguments, asterisk);
        }

        @Override
        @NotNull
        public YieldingStandaloneCallBuilder yield(SymbolicName ... resultFields) {
            return new YieldingStandaloneCallBuilder(this.procedureName, this.arguments, resultFields);
        }

        @Override
        @NotNull
        public YieldingStandaloneCallBuilder yield(AliasedExpression ... aliasedResultFields) {
            return new YieldingStandaloneCallBuilder(this.procedureName, this.arguments, aliasedResultFields);
        }

        @Override
        @NotNull
        public Expression asFunction(boolean distinct) {
            block5: {
                block4: {
                    if (this.arguments == null) break block4;
                    if (this.arguments.length != 0) break block5;
                }
                return FunctionInvocation.create(this.procedureName::getQualifiedName);
            }
            if (distinct) {
                return FunctionInvocation.createDistinct(this.procedureName::getQualifiedName, this.arguments);
            }
            return FunctionInvocation.create(this.procedureName::getQualifiedName, this.arguments);
        }

        @Override
        public StatementBuilder.VoidCall withoutResults() {
            return new DefaultStatementBuilder(this.build());
        }

        @Override
        @NotNull
        public ProcedureCall build() {
            return ProcedureCallImpl.create(this.procedureName, this.createArgumentList(), null, this.conditionBuilder.buildCondition().map(Where::new).orElse(null));
        }
    }

    static abstract class AbstractCallBuilder {
        protected final ProcedureName procedureName;
        protected Expression[] arguments;
        protected final ConditionBuilder conditionBuilder = new ConditionBuilder();

        AbstractCallBuilder(ProcedureName procedureName) {
            this(procedureName, null);
        }

        AbstractCallBuilder(ProcedureName procedureName, Expression[] arguments) {
            this.procedureName = procedureName;
            this.arguments = arguments;
        }

        Arguments createArgumentList() {
            Arguments argumentsList = null;
            if (this.arguments != null && this.arguments.length > 0) {
                argumentsList = new Arguments(this.arguments);
            }
            return argumentsList;
        }
    }

    static abstract class ReturnListWrapper {
        protected final List<Expression> returnList = new ArrayList<Expression>();

        ReturnListWrapper() {
        }

        protected final void addElements(Collection<IdentifiableElement> elements) {
            Assertions.notNull(elements, Cypher.MESSAGES.getString("assertions.expressions-required"));
            List<Expression> filteredElements = elements.stream().filter(Objects::nonNull).map(IdentifiableElement::asExpression).toList();
            Assertions.isTrue(!filteredElements.isEmpty(), Cypher.MESSAGES.getString("assertions.at-least-one-expression-required"));
            this.returnList.addAll(filteredElements);
        }

        protected final void addExpressions(Collection<? extends Expression> expressions) {
            Assertions.notNull(expressions, Cypher.MESSAGES.getString("assertions.expressions-required"));
            Assertions.isTrue(!expressions.isEmpty() && expressions.stream().noneMatch(Objects::isNull), Cypher.MESSAGES.getString("assertions.at-least-one-expression-required"));
            this.returnList.addAll(expressions);
        }
    }
}

