/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.Expander;
import org.neo4j.cypher.internal.runtime.KernelPredicate;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.AllInList;
import org.neo4j.cypher.internal.runtime.interpreted.commands.AstNode;
import org.neo4j.cypher.internal.runtime.interpreted.commands.NoneInList;
import org.neo4j.cypher.internal.runtime.interpreted.commands.ShortestPath;
import org.neo4j.cypher.internal.runtime.interpreted.commands.SingleNode;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expanders$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.ExtendedExpression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.NodesFunction;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.RelationshipFunction;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.ShortestPathExpression$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.TypeAndDirectionExpander;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Ands;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.CoercedPredicate;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Not;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.PropertyExists;
import org.neo4j.cypher.internal.runtime.interpreted.commands.values.KeyToken;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.util.NonEmptyList;
import org.neo4j.cypher.internal.util.NonEmptyList$;
import org.neo4j.cypher.internal.util.attribution.Id;
import org.neo4j.exceptions.ShortestPathCommonEndNodesForbiddenException;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.NodeReference;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r=f\u0001B\"E\u0001VC\u0001b\u0019\u0001\u0003\u0016\u0004%\t\u0001\u001a\u0005\tS\u0002\u0011\t\u0012)A\u0005K\"A!\u000e\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005\u007f\u0001\tE\t\u0015!\u0003m\u0011!y\bA!f\u0001\n\u0003Y\u0007\"CA\u0001\u0001\tE\t\u0015!\u0003m\u0011)\t\u0019\u0001\u0001BK\u0002\u0013\u0005\u0011Q\u0001\u0005\u000b\u0003\u001b\u0001!\u0011#Q\u0001\n\u0005\u001d\u0001BCA\b\u0001\tU\r\u0011\"\u0001\u0002\u0006!Q\u0011\u0011\u0003\u0001\u0003\u0012\u0003\u0006I!a\u0002\t\u0015\u0005M\u0001A!f\u0001\n\u0003\t)\u0002\u0003\u0006\u0002(\u0001\u0011\t\u0012)A\u0005\u0003/Aq!!\u000b\u0001\t\u0003\tY\u0003\u0003\u0005|\u0001\t\u0007I\u0011AA\u001e\u0011!\t9\u0005\u0001Q\u0001\n\u0005u\u0002bBA%\u0001\u0011\u0005\u00111\n\u0005\b\u0003\u0013\u0002A\u0011AA;\u0011\u001d\tY\t\u0001C\u0005\u0003\u001bCq!a+\u0001\t\u0013\ti\u000bC\u0004\u0002X\u0002!I!!7\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\"9\u0011Q\u001e\u0001\u0005B\u0005=\bb\u0002B\t\u0001\u0011\u0005#1\u0003\u0005\b\u0005/\u0001A\u0011\tB\r\u0011\u001d\u0011)\u0003\u0001C\u0005\u0005OAqA!\u0015\u0001\t\u0013\u0011\u0019\u0006C\u0004\u0003\\\u0001!IA!\u0018\t\u000f\tU\u0004\u0001\"\u0003\u0003x!9!Q\u0011\u0001\u0005\n\t\u001d\u0005b\u0002BF\u0001\u0011%!Q\u0012\u0005\b\u0005O\u0003A\u0011\u0002BU\u0011\u001d\u0011\u0019\r\u0001C\u0005\u0005\u000bDqAa2\u0001\t\u0013\u0011I\rC\u0004\u0003T\u0002!IA!6\t\u000f\tm\u0007\u0001\"\u0003\u0003^\"I!\u0011\u001d\u0001\u0002\u0002\u0013\u0005!1\u001d\u0005\n\u0005c\u0004\u0011\u0013!C\u0001\u0005gD\u0011b!\u0003\u0001#\u0003%\taa\u0003\t\u0013\r=\u0001!%A\u0005\u0002\r-\u0001\"CB\t\u0001E\u0005I\u0011AB\n\u0011%\u00199\u0002AI\u0001\n\u0003\u0019\u0019\u0002C\u0005\u0004\u001a\u0001\t\n\u0011\"\u0001\u0004\u001c!I1q\u0004\u0001\u0002\u0002\u0013\u00053\u0011\u0005\u0005\n\u0007c\u0001\u0011\u0011!C\u0001\u0007gA\u0011b!\u000e\u0001\u0003\u0003%\taa\u000e\t\u0013\ru\u0002!!A\u0005B\r}\u0002\"CB$\u0001\u0005\u0005I\u0011AB%\u0011%\u0019i\u0005AA\u0001\n\u0003\u001ay\u0005C\u0005\u0004R\u0001\t\t\u0011\"\u0011\u0004T\u001d91q\u000b#\t\u0002\recAB\"E\u0011\u0003\u0019Y\u0006C\u0004\u0002*M\"\ta!\u0018\t\u000f\r}3\u0007\"\u0001\u0004b!I\u0011\u0011J\u001a\u0002\u0002\u0013\u000551\u000f\u0005\n\u0007\u0003\u001b\u0014\u0013!C\u0001\u0007\u0017A\u0011ba!4#\u0003%\taa\u0003\t\u0013\r\u00155'%A\u0005\u0002\rM\u0001\"CBDgE\u0005I\u0011AB\n\u0011%\u0019IiMI\u0001\n\u0003\u0019Y\u0002C\u0005\u0004\fN\n\t\u0011\"!\u0004\u000e\"I11T\u001a\u0012\u0002\u0013\u000511\u0002\u0005\n\u0007;\u001b\u0014\u0013!C\u0001\u0007\u0017A\u0011ba(4#\u0003%\taa\u0005\t\u0013\r\u00056'%A\u0005\u0002\rM\u0001\"CBRgE\u0005I\u0011AB\u000e\u0011%\u0019)kMA\u0001\n\u0013\u00199K\u0001\fTQ>\u0014H/Z:u!\u0006$\b.\u0012=qe\u0016\u001c8/[8o\u0015\t)e)A\u0006fqB\u0014Xm]:j_:\u001c(BA$I\u0003!\u0019w.\\7b]\u0012\u001c(BA%K\u0003-Ig\u000e^3saJ,G/\u001a3\u000b\u0005-c\u0015a\u0002:v]RLW.\u001a\u0006\u0003\u001b:\u000b\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001fB\u000baaY=qQ\u0016\u0014(BA)S\u0003\u0015qWm\u001c\u001bk\u0015\u0005\u0019\u0016aA8sO\u000e\u00011\u0003\u0002\u0001W5\u0002\u0004\"a\u0016-\u000e\u0003\u0011K!!\u0017#\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002\\=6\tALC\u0001^\u0003\u0015\u00198-\u00197b\u0013\tyFLA\u0004Qe>$Wo\u0019;\u0011\u0005m\u000b\u0017B\u00012]\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003M\u0019\bn\u001c:uKN$\b+\u0019;i!\u0006$H/\u001a:o+\u0005)\u0007C\u00014h\u001b\u00051\u0015B\u00015G\u00051\u0019\u0006n\u001c:uKN$\b+\u0019;i\u0003Q\u0019\bn\u001c:uKN$\b+\u0019;i!\u0006$H/\u001a:oA\u0005\t\u0002/\u001a:Ti\u0016\u0004\bK]3eS\u000e\fG/Z:\u0016\u00031\u00042!\\;y\u001d\tq7O\u0004\u0002pe6\t\u0001O\u0003\u0002r)\u00061AH]8pizJ\u0011!X\u0005\u0003ir\u000bq\u0001]1dW\u0006<W-\u0003\u0002wo\n\u00191+Z9\u000b\u0005Qd\u0006CA=}\u001b\u0005Q(BA>G\u0003)\u0001(/\u001a3jG\u0006$Xm]\u0005\u0003{j\u0014\u0011\u0002\u0015:fI&\u001c\u0017\r^3\u0002%A,'o\u0015;faB\u0013X\rZ5dCR,7\u000fI\u0001\u0013MVdG\u000eU1uQB\u0013X\rZ5dCR,7/A\ngk2d\u0007+\u0019;i!J,G-[2bi\u0016\u001c\b%\u0001\u0007xSRDg)\u00197m\u0005\u0006\u001c7.\u0006\u0002\u0002\bA\u00191,!\u0003\n\u0007\u0005-ALA\u0004C_>dW-\u00198\u0002\u001b]LG\u000f\u001b$bY2\u0014\u0015mY6!\u0003A!\u0017n]1mY><8+Y7f\u001d>$W-A\teSN\fG\u000e\\8x'\u0006lWMT8eK\u0002\n!b\u001c9fe\u0006$xN]%e+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0017\u0005$HO]5ckRLwN\u001c\u0006\u0004\u0003Ca\u0015\u0001B;uS2LA!!\n\u0002\u001c\t\u0011\u0011\nZ\u0001\f_B,'/\u0019;pe&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u000f\u0003[\ty#!\r\u00024\u0005U\u0012qGA\u001d!\t9\u0006\u0001C\u0003d\u001b\u0001\u0007Q\rC\u0004k\u001bA\u0005\t\u0019\u00017\t\u000f}l\u0001\u0013!a\u0001Y\"I\u00111A\u0007\u0011\u0002\u0003\u0007\u0011q\u0001\u0005\n\u0003\u001fi\u0001\u0013!a\u0001\u0003\u000fA\u0011\"a\u0005\u000e!\u0003\u0005\r!a\u0006\u0016\u0005\u0005u\u0002#BA \u0003\u000bBXBAA!\u0015\r\t\u0019\u0005X\u0001\u000bG>dG.Z2uS>t\u0017b\u0001<\u0002B\u0005Y\u0001O]3eS\u000e\fG/Z:!\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\ti%!\u0017\u0002fA!\u0011qJA+\u001b\t\t\tFC\u0002\u0002TA\u000baA^1mk\u0016\u001c\u0018\u0002BA,\u0003#\u0012\u0001\"\u00118z-\u0006dW/\u001a\u0005\b\u00037\u0002\u0002\u0019AA/\u0003\r\u0011xn\u001e\t\u0005\u0003?\n\t'D\u0001K\u0013\r\t\u0019G\u0013\u0002\f%\u0016\fG-\u00192mKJ{w\u000fC\u0004\u0002hA\u0001\r!!\u001b\u0002\u000bM$\u0018\r^3\u0011\t\u0005-\u0014\u0011O\u0007\u0003\u0003[R1!a\u001cI\u0003\u0015\u0001\u0018\u000e]3t\u0013\u0011\t\u0019(!\u001c\u0003\u0015E+XM]=Ti\u0006$X\r\u0006\u0005\u0002N\u0005]\u0014\u0011PA>\u0011\u001d\tY&\u0005a\u0001\u0003;Bq!a\u001a\u0012\u0001\u0004\tI\u0007C\u0004\u0002~E\u0001\r!a \u0002\u001b5,Wn\u001c:z)J\f7m[3s!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAAC!\u00061Q.Z7pefLA!!#\u0002\u0004\niQ*Z7pef$&/Y2lKJ\f!bZ3u\u001b\u0006$8\r[3t)1\ti%a$\u0002\u0014\u0006\r\u0016qUAU\u0011\u001d\t\tJ\u0005a\u0001\u0003;\n1a\u0019;y\u0011\u001d\t)J\u0005a\u0001\u0003/\u000bQa\u001d;beR\u0004B!!'\u0002 6\u0011\u00111\u0014\u0006\u0005\u0003;\u000b\t&A\u0004wSJ$X/\u00197\n\t\u0005\u0005\u00161\u0014\u0002\n\u001d>$WMV1mk\u0016Dq!!*\u0013\u0001\u0004\t9*A\u0002f]\u0012Dq!a\u001a\u0013\u0001\u0004\tI\u0007C\u0004\u0002~I\u0001\r!a \u00027\r\u0014X-\u0019;f'\"|'\u000f^3tiB\u000bG\u000f\u001b)sK\u0012L7-\u0019;f)!\ty+!1\u0002L\u0006U\u0007CBA0\u0003c\u000b),C\u0002\u00024*\u0013qbS3s]\u0016d\u0007K]3eS\u000e\fG/\u001a\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111\u0018)\u0002\u000f\u001d\u0014\u0018\r\u001d5eE&!\u0011qXA]\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005\r7\u00031\u0001\u0002F\u0006Y\u0011N\\2p[&twm\u0011;y!\u0011\ty&a2\n\u0007\u0005%'JA\u0005DsBDWM\u001d*po\"9\u0011QZ\nA\u0002\u0005=\u0017AD7bs\n,\u0007K]3eS\u000e\fG/\u001a\t\u00057\u0006E\u00070C\u0002\u0002Tr\u0013aa\u00149uS>t\u0007bBA4'\u0001\u0007\u0011\u0011N\u0001\fO\u0016$XI\u001c3Q_&tG\u000f\u0006\u0005\u0002\u0018\u0006m\u0017Q\\Ap\u0011\u001d\t\t\n\u0006a\u0001\u0003;Bq!a\u001a\u0015\u0001\u0004\tI\u0007C\u0004\u0002\u0016R\u0001\r!!9\u0011\u0007\u0019\f\u0019/C\u0002\u0002f\u001a\u0013!bU5oO2,gj\u001c3f\u0003e\tg._*uCJ$\bo\\5oiN\u001cuN\u001c;bS:tU\u000f\u001c7\u0015\t\u0005\u001d\u00111\u001e\u0005\b\u0003#+\u0002\u0019AA/\u0003!\u0019\u0007.\u001b7ee\u0016tWCAAy!\u0011iW/a=1\t\u0005U\u0018q \t\u0006M\u0006]\u00181`\u0005\u0004\u0003s4%aB!ti:{G-\u001a\t\u0005\u0003{\fy\u0010\u0004\u0001\u0005\u0017\t\u0005a#!A\u0001\u0002\u000b\u0005!1\u0001\u0002\u0004?\u0012\n\u0014\u0003\u0002B\u0003\u0005\u0017\u00012a\u0017B\u0004\u0013\r\u0011I\u0001\u0018\u0002\b\u001d>$\b.\u001b8h!\rY&QB\u0005\u0004\u0005\u001fa&aA!os\u0006I\u0011M]4v[\u0016tGo]\u000b\u0003\u0005+\u00012!\\;W\u0003\u001d\u0011Xm\u001e:ji\u0016$2A\u0016B\u000e\u0011\u001d\u0011i\u0002\u0007a\u0001\u0005?\t\u0011A\u001a\t\u00067\n\u0005bKV\u0005\u0004\u0005Ga&!\u0003$v]\u000e$\u0018n\u001c82\u0003Y\u0001(o\u001c9feRLX\t_5tiN,\u0005\u0010]1oI\u0016\u0014H\u0003\u0002B\u0015\u0005{\u0011bAa\u000b\u00030\tUbA\u0002B\u00173\u0001\u0011IC\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u0002\\\u0005cI1Aa\r]\u0005\u0019\te.\u001f*fMB1\u0011qLAY\u0005o\u0001B!a.\u0003:%!!1HA]\u0005\u0019)e\u000e^5us\"9!qH\rA\u0002\t\u0005\u0013\u0001\u00028b[\u0016\u0004BAa\u0011\u0003L9!!Q\tB$!\tyG,C\u0002\u0003Jq\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B'\u0005\u001f\u0012aa\u0015;sS:<'b\u0001B%9\u0006I\u0002O]8qKJ$\u0018PT8u\u000bbL7\u000f^:FqB\fg\u000eZ3s)\u0011\u0011)F!\u0017\u0013\r\t]#q\u0006B\u001b\r\u0019\u0011iC\u0007\u0001\u0003V!9!q\b\u000eA\u0002\t\u0005\u0013AI2za\",'\u000fU8tSRLg/\u001a)sK\u0012L7-\u0019;fg\u0006\u001bX\t\u001f9b]\u0012,'\u000f\u0006\u0006\u0003`\t\r$Q\rB8\u0005g\u0012bA!\u0019\u00030\tUbA\u0002B\u00177\u0001\u0011y\u0006C\u0004\u0002Dn\u0001\r!!\u0018\t\u000f\t\u001d4\u00041\u0001\u0003j\u0005qa/\u0019:jC\ndWm\u00144gg\u0016$\bcA.\u0003l%\u0019!Q\u000e/\u0003\u0007%sG\u000f\u0003\u0004\u0003rm\u0001\r\u0001_\u0001\naJ,G-[2bi\u0016Dq!a\u001a\u001c\u0001\u0004\tI'\u0001\u0012dsBDWM\u001d(fO\u0006$\u0018N^3Qe\u0016$\u0017nY1uKN\f5/\u0012=qC:$WM\u001d\u000b\u000b\u0005s\u0012iHa \u0003\u0002\n\r%C\u0002B>\u0005_\u0011)D\u0002\u0004\u0003.q\u0001!\u0011\u0010\u0005\b\u0003\u0007d\u0002\u0019AA/\u0011\u001d\u00119\u0007\ba\u0001\u0005SBaA!\u001d\u001d\u0001\u0004A\bbBA49\u0001\u0007\u0011\u0011N\u0001\u000eM&tG\r\u0015:fI&\u001c\u0017\r^3\u0015\u0007Y\u0013I\t\u0003\u0004\u0003ru\u0001\r\u0001_\u0001!C\u0012$\u0017\t\u001c7Pe:{g.\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004X\t\u001f9b]\u0012,'\u000f\u0006\b\u0003\u0010\nU%q\u0013BN\u0005?\u0013\tK!*\u0011\t\u0005}#\u0011S\u0005\u0004\u0005'S%\u0001C#ya\u0006tG-\u001a:\t\u000f\u0005Ee\u00041\u0001\u0002^!9!\u0011\u0014\u0010A\u0002\t=\u0015aD2veJ,g\u000e^#ya\u0006tG-\u001a:\t\u000f\tue\u00041\u0001\u0002\b\u0005\u0019\u0011\r\u001c7\t\r\tEd\u00041\u0001y\u0011\u001d\u0011\u0019K\ba\u0001\u0005S\n\u0011C]3m-\u0006\u0014\u0018.\u00192mK>3gm]3u\u0011\u001d\t9G\ba\u0001\u0003S\n\u0001$\u00193e\u00032dwJ\u001d(p]\u0016tu\u000eZ3FqB\fg\u000eZ3s)A\u0011YKa-\u00036\n]&\u0011\u0018B^\u0005{\u0013\t\rE\u0004\\\u0005[\u0013yI!-\n\u0007\t=FL\u0001\u0004UkBdWM\r\t\u0005[V\u0014)\u0004C\u0004\u0002\u0012~\u0001\r!!\u0018\t\u000f\teu\u00041\u0001\u0003\u0010\"9!QT\u0010A\u0002\u0005\u001d\u0001B\u0002B9?\u0001\u0007\u0001\u0010C\u0004\u0003$~\u0001\rA!\u001b\t\u000f\t}v\u00041\u0001\u00032\u0006)2-\u001e:sK:$hj\u001c3f!J,G-[2bi\u0016\u001c\bbBA4?\u0001\u0007\u0011\u0011N\u0001\u001d[\u0006\\WMU3mCRLwN\\:iSB$\u0016\u0010]3FqB\fg\u000eZ3s)\t\u0011y)A\u0007bI\u0012\u0004&/\u001a3jG\u0006$Xm\u001d\u000b\t\u0005W\u0013YM!4\u0003R\"9\u0011\u0011S\u0011A\u0002\u0005u\u0003b\u0002BhC\u0001\u0007!qR\u0001\u0016e\u0016dG+\u001f9f\u0003:$G)\u001b:FqB\fg\u000eZ3s\u0011\u001d\t9'\ta\u0001\u0003S\nq\"[:O_\u0012,7OR;oGRLwN\u001c\u000b\u0005\u0003\u000f\u00119\u000e\u0003\u0004\u0003Z\n\u0002\rAV\u0001\u000bKb\u0004(/Z:tS>t\u0017aF5t%\u0016d\u0017\r^5p]ND\u0017\u000e]:Gk:\u001cG/[8o)\u0011\t9Aa8\t\r\te7\u00051\u0001W\u0003\u0011\u0019w\u000e]=\u0015\u001d\u00055\"Q\u001dBt\u0005S\u0014YO!<\u0003p\"91\r\nI\u0001\u0002\u0004)\u0007b\u00026%!\u0003\u0005\r\u0001\u001c\u0005\b\u007f\u0012\u0002\n\u00111\u0001m\u0011%\t\u0019\u0001\nI\u0001\u0002\u0004\t9\u0001C\u0005\u0002\u0010\u0011\u0002\n\u00111\u0001\u0002\b!I\u00111\u0003\u0013\u0011\u0002\u0003\u0007\u0011qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011)PK\u0002f\u0005o\\#A!?\u0011\t\tm8QA\u0007\u0003\u0005{TAAa@\u0004\u0002\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u0007a\u0016AC1o]>$\u0018\r^5p]&!1q\u0001B\u007f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019iAK\u0002m\u0005o\fabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\rU!\u0006BA\u0004\u0005o\fabY8qs\u0012\"WMZ1vYR$S'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\ru!\u0006BA\f\u0005o\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAB\u0012!\u0011\u0019)ca\f\u000e\u0005\r\u001d\"\u0002BB\u0015\u0007W\tA\u0001\\1oO*\u00111QF\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003N\r\u001d\u0012\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B5\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0003\u0004:!I11H\u0017\u0002\u0002\u0003\u0007!\u0011N\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r\u0005\u0003CBA \u0007\u0007\u0012Y!\u0003\u0003\u0004F\u0005\u0005#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0002\u0004L!I11H\u0018\u0002\u0002\u0003\u0007!1B\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!\u0011N\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d1Q\u000b\u0005\n\u0007w\t\u0014\u0011!a\u0001\u0005\u0017\tac\u00155peR,7\u000f\u001e)bi\",\u0005\u0010\u001d:fgNLwN\u001c\t\u0003/N\u001aBa\rB\u0018AR\u00111\u0011L\u0001\r]>$U\u000f\u001d7jG\u0006$Xm\u001d\u000b\u0005\u0003\u000f\u0019\u0019\u0007C\u0004\u0004fU\u0002\raa\u001a\u0002\u001bI,G.\u0019;j_:\u001c\b.\u001b9t!\u0015i7\u0011NB7\u0013\r\u0019Yg\u001e\u0002\t\u0013R,'/\u00192mKB!\u0011qWB8\u0013\u0011\u0019\t(!/\u0003\u0019I+G.\u0019;j_:\u001c\b.\u001b9\u0015\u001d\u000552QOB<\u0007s\u001aYh! \u0004\u0000!)1M\u000ea\u0001K\"9!N\u000eI\u0001\u0002\u0004a\u0007bB@7!\u0003\u0005\r\u0001\u001c\u0005\n\u0003\u00071\u0004\u0013!a\u0001\u0003\u000fA\u0011\"a\u00047!\u0003\u0005\r!a\u0002\t\u0013\u0005Ma\u0007%AA\u0002\u0005]\u0011aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$c'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r=5q\u0013\t\u00067\u0006E7\u0011\u0013\t\r7\u000eMU\r\u001c7\u0002\b\u0005\u001d\u0011qC\u0005\u0004\u0007+c&A\u0002+va2,g\u0007C\u0005\u0004\u001ar\n\t\u00111\u0001\u0002.\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'A\u0006sK\u0006$'+Z:pYZ,GCABU!\u0011\u0019)ca+\n\t\r56q\u0005\u0002\u0007\u001f\nTWm\u0019;")
public class ShortestPathExpression
extends Expression
implements Product,
scala.Serializable {
    private final ShortestPath shortestPathPattern;
    private final Seq<Predicate> perStepPredicates;
    private final Seq<Predicate> fullPathPredicates;
    private final boolean withFallBack;
    private final boolean disallowSameNode;
    private final int operatorId;
    private final Seq<Predicate> predicates;

    public static int $lessinit$greater$default$6() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$5() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$4();
    }

    public static Seq<Predicate> $lessinit$greater$default$3() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$3();
    }

    public static Seq<Predicate> $lessinit$greater$default$2() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple6<ShortestPath, Seq<Predicate>, Seq<Predicate>, Object, Object, Id>> unapply(ShortestPathExpression shortestPathExpression) {
        return ShortestPathExpression$.MODULE$.unapply(shortestPathExpression);
    }

    public static int apply$default$6() {
        return ShortestPathExpression$.MODULE$.apply$default$6();
    }

    public static boolean apply$default$5() {
        return ShortestPathExpression$.MODULE$.apply$default$5();
    }

    public static boolean apply$default$4() {
        return ShortestPathExpression$.MODULE$.apply$default$4();
    }

    public static Seq<Predicate> apply$default$3() {
        return ShortestPathExpression$.MODULE$.apply$default$3();
    }

    public static Seq<Predicate> apply$default$2() {
        return ShortestPathExpression$.MODULE$.apply$default$2();
    }

    public static boolean noDuplicates(Iterable<Relationship> iterable) {
        return ShortestPathExpression$.MODULE$.noDuplicates(iterable);
    }

    public ShortestPath shortestPathPattern() {
        return this.shortestPathPattern;
    }

    public Seq<Predicate> perStepPredicates() {
        return this.perStepPredicates;
    }

    public Seq<Predicate> fullPathPredicates() {
        return this.fullPathPredicates;
    }

    public boolean withFallBack() {
        return this.withFallBack;
    }

    public boolean disallowSameNode() {
        return this.disallowSameNode;
    }

    public int operatorId() {
        return this.operatorId;
    }

    public Seq<Predicate> predicates() {
        return this.predicates;
    }

    @Override
    public AnyValue apply(ReadableRow row, QueryState state) {
        return this.apply(row, state, state.memoryTracker().memoryTrackerForOperator(this.operatorId()));
    }

    public AnyValue apply(ReadableRow row, QueryState state, MemoryTracker memoryTracker) {
        Value value;
        if (this.anyStartpointsContainNull(row)) {
            value = Values.NO_VALUE;
        } else {
            NodeValue start = this.getEndPoint(row, state, this.shortestPathPattern().left());
            NodeValue end = this.getEndPoint(row, state, this.shortestPathPattern().right());
            if (!this.shortestPathPattern().allowZeroLength() && this.disallowSameNode() && start.equals((VirtualValue)end)) {
                throw new ShortestPathCommonEndNodesForbiddenException();
            }
            value = this.getMatches(row, start, end, state, memoryTracker);
        }
        return value;
    }

    private AnyValue getMatches(ReadableRow ctx, NodeValue start, NodeValue end, QueryState state, MemoryTracker memoryTracker) {
        Object object;
        Tuple2<Expander, Seq<KernelPredicate<Entity>>> tuple2 = this.addPredicates(ctx, this.makeRelationshipTypeExpander(), state);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expander expander = (Expander)tuple2._1();
        Seq nodePredicates = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)expander, (Object)nodePredicates);
        Tuple2 tuple23 = tuple22;
        Expander expander2 = (Expander)tuple23._1();
        Seq nodePredicates2 = (Seq)tuple23._2();
        None$ maybePredicate = this.predicates().isEmpty() ? None$.MODULE$ : new Some((Object)new Ands((NonEmptyList<Predicate>)NonEmptyList$.MODULE$.from(this.predicates())));
        CypherRow cypherRow = (CypherRow)ctx;
        KernelPredicate<Path> shortestPathPredicate = this.createShortestPathPredicate(cypherRow, (Option<Predicate>)maybePredicate, state);
        if (this.shortestPathPattern().single()) {
            Option result = state.query().singleShortestPath(start.id(), end.id(), BoxesRunTime.unboxToInt((Object)this.shortestPathPattern().maxDepth().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE)), expander2, shortestPathPredicate, nodePredicates2, memoryTracker);
            object = !this.shortestPathPattern().allowZeroLength() && result.forall((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ShortestPathExpression.$anonfun$getMatches$2(p))) ? Values.NO_VALUE : (AnyValue)result.map((Function1 & Serializable & scala.Serializable)x$1 -> ValueUtils.fromPath((Path)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Values.NO_VALUE);
        } else {
            PathValue[] result = (PathValue[])state.query().allShortestPath(start.id(), end.id(), BoxesRunTime.unboxToInt((Object)this.shortestPathPattern().maxDepth().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE)), expander2, shortestPathPredicate, nodePredicates2, memoryTracker).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ShortestPathExpression.$anonfun$getMatches$6(this, p))).map((Function1 & Serializable & scala.Serializable)x$1 -> ValueUtils.fromPath((Path)x$1)).toArray(ClassTag$.MODULE$.apply(PathValue.class));
            object = VirtualValues.list((AnyValue[])((AnyValue[])result));
        }
        return object;
    }

    private KernelPredicate<Path> createShortestPathPredicate(CypherRow incomingCtx, Option<Predicate> maybePredicate, QueryState state) {
        return new KernelPredicate<Path>(this, maybePredicate, incomingCtx, state){
            private final /* synthetic */ ShortestPathExpression $outer;
            private final Option maybePredicate$1;
            private final CypherRow incomingCtx$1;
            private final QueryState state$1;

            public boolean test(Path path) {
                return this.maybePredicate$1.forall((Function1 & Serializable & scala.Serializable)predicate -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$test$1(this, path, predicate))) && (!this.$outer.withFallBack() || ShortestPathExpression$.MODULE$.noDuplicates((Iterable<Relationship>)((Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(path.relationships()).asScala())));
            }

            public static final /* synthetic */ boolean $anonfun$test$1($anon$1 $this, Path path$1, Predicate predicate) {
                $this.incomingCtx$1.set($this.$outer.shortestPathPattern().pathName(), (AnyValue)ValueUtils.fromPath((Path)path$1));
                $this.incomingCtx$1.set((String)$this.$outer.shortestPathPattern().relIterator().get(), (AnyValue)ValueUtils.asListOfEdges((java.lang.Iterable)path$1.relationships()));
                return predicate.isTrue((ReadableRow)$this.incomingCtx$1, $this.state$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybePredicate$1 = maybePredicate$1;
                this.incomingCtx$1 = incomingCtx$1;
                this.state$1 = state$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$test$1$adapted(org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.ShortestPathExpression$$anon$1 org.neo4j.graphdb.Path org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate )}, serializedLambda);
            }
        };
    }

    private NodeValue getEndPoint(ReadableRow ctx, QueryState state, SingleNode start) {
        NodeValue nodeValue;
        try {
            NodeValue nodeValue2;
            AnyValue anyValue = ctx.getByName(start.name());
            if (anyValue instanceof NodeValue) {
                NodeValue nodeValue3;
                nodeValue2 = nodeValue3 = (NodeValue)anyValue;
            } else if (anyValue instanceof NodeReference) {
                NodeReference nodeReference = (NodeReference)anyValue;
                nodeValue2 = (NodeValue)state.query().nodeOps().getById(nodeReference.id());
            } else {
                throw new MatchError((Object)anyValue);
            }
            nodeValue = nodeValue2;
        }
        catch (NotFoundException notFoundException) {
            throw new SyntaxException(new StringBuilder(84).append("To find a shortest path, both ends of the path need to be provided. Couldn't find `").append(start).append("`").toString());
        }
        return nodeValue;
    }

    private boolean anyStartpointsContainNull(ReadableRow ctx) {
        return ctx.getByName(this.shortestPathPattern().left().name()) == Values.NO_VALUE || ctx.getByName(this.shortestPathPattern().right().name()) == Values.NO_VALUE;
    }

    @Override
    public Seq<AstNode<?>> children() {
        return (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ShortestPath[]{this.shortestPathPattern()}))).$plus$plus(this.perStepPredicates(), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.fullPathPredicates(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<Expression> arguments() {
        return (Seq)Seq$.MODULE$.empty();
    }

    @Override
    public Expression rewrite(Function1<Expression, Expression> f) {
        Object x$1 = this.shortestPathPattern().rewrite((Function1)f);
        int x$2 = this.operatorId();
        Seq<Predicate> x$3 = ShortestPathExpression$.MODULE$.apply$default$2();
        Seq<Predicate> x$4 = ShortestPathExpression$.MODULE$.apply$default$3();
        boolean x$5 = ShortestPathExpression$.MODULE$.apply$default$4();
        boolean x$6 = ShortestPathExpression$.MODULE$.apply$default$5();
        return (Expression)f.apply((Object)new ShortestPathExpression((ShortestPath)x$1, x$3, x$4, x$5, x$6, x$2));
    }

    private KernelPredicate<Entity> propertyExistsExpander(String name) {
        return new KernelPredicate<Entity>(null, name){
            private final String name$1;

            public boolean test(Entity t) {
                return t.hasProperty(this.name$1);
            }
            {
                this.name$1 = name$1;
            }
        };
    }

    private KernelPredicate<Entity> propertyNotExistsExpander(String name) {
        return new KernelPredicate<Entity>(null, name){
            private final String name$2;

            public boolean test(Entity t) {
                return !t.hasProperty(this.name$2);
            }
            {
                this.name$2 = name$2;
            }
        };
    }

    private KernelPredicate<Entity> cypherPositivePredicatesAsExpander(ReadableRow incomingCtx, int variableOffset, Predicate predicate, QueryState state) {
        return new KernelPredicate<Entity>(null, state, variableOffset, predicate, incomingCtx){
            private final QueryState state$2;
            private final int variableOffset$1;
            private final Predicate predicate$1;
            private final ReadableRow incomingCtx$2;

            public boolean test(Entity t) {
                this.state$2.expressionVariables()[this.variableOffset$1] = ValueUtils.asNodeOrEdgeValue((Entity)t);
                return this.predicate$1.isTrue(this.incomingCtx$2, this.state$2);
            }
            {
                this.state$2 = state$2;
                this.variableOffset$1 = variableOffset$1;
                this.predicate$1 = predicate$1;
                this.incomingCtx$2 = incomingCtx$2;
            }
        };
    }

    private KernelPredicate<Entity> cypherNegativePredicatesAsExpander(ReadableRow incomingCtx, int variableOffset, Predicate predicate, QueryState state) {
        return new KernelPredicate<Entity>(null, state, variableOffset, predicate, incomingCtx){
            private final QueryState state$3;
            private final int variableOffset$2;
            private final Predicate predicate$2;
            private final ReadableRow incomingCtx$3;

            public boolean test(Entity t) {
                this.state$3.expressionVariables()[this.variableOffset$2] = ValueUtils.asNodeOrEdgeValue((Entity)t);
                return !this.predicate$2.isTrue(this.incomingCtx$3, this.state$3);
            }
            {
                this.state$3 = state$3;
                this.variableOffset$2 = variableOffset$2;
                this.predicate$2 = predicate$2;
                this.incomingCtx$3 = incomingCtx$3;
            }
        };
    }

    private Expression findPredicate(Predicate predicate) {
        Expression expression;
        CoercedPredicate coercedPredicate;
        Expression inner;
        Predicate predicate2 = predicate;
        if (predicate2 instanceof CoercedPredicate && (inner = (coercedPredicate = (CoercedPredicate)predicate2).inner()) instanceof ExtendedExpression) {
            ExtendedExpression extendedExpression = (ExtendedExpression)((Object)inner);
            expression = extendedExpression.legacy();
        } else {
            expression = predicate;
        }
        return expression;
    }

    private Expander addAllOrNoneRelationshipExpander(ReadableRow ctx, Expander currentExpander, boolean all, Predicate predicate, int relVariableOffset, QueryState state) {
        Not not;
        Predicate predicate2;
        Expander expander;
        Expression expression = this.findPredicate(predicate);
        if (expression instanceof PropertyExists) {
            PropertyExists propertyExists = (PropertyExists)expression;
            KeyToken propertyKey = propertyExists.propertyKey();
            expander = currentExpander.addRelationshipFilter(all ? this.propertyExistsExpander(propertyKey.name()) : this.propertyNotExistsExpander(propertyKey.name()));
        } else if (expression instanceof Not && (predicate2 = (not = (Not)expression).a()) instanceof PropertyExists) {
            PropertyExists propertyExists = (PropertyExists)predicate2;
            KeyToken propertyKey = propertyExists.propertyKey();
            expander = currentExpander.addRelationshipFilter(all ? this.propertyNotExistsExpander(propertyKey.name()) : this.propertyExistsExpander(propertyKey.name()));
        } else {
            expander = currentExpander.addRelationshipFilter(all ? this.cypherPositivePredicatesAsExpander(ctx, relVariableOffset, predicate, state) : this.cypherNegativePredicatesAsExpander(ctx, relVariableOffset, predicate, state));
        }
        return expander;
    }

    private Tuple2<Expander, Seq<KernelPredicate<Entity>>> addAllOrNoneNodeExpander(ReadableRow ctx, Expander currentExpander, boolean all, Predicate predicate, int relVariableOffset, Seq<KernelPredicate<Entity>> currentNodePredicates, QueryState state) {
        Not not;
        Predicate predicate2;
        KernelPredicate<Entity> kernelPredicate;
        Expression expression = this.findPredicate(predicate);
        if (expression instanceof PropertyExists) {
            PropertyExists propertyExists = (PropertyExists)expression;
            KeyToken propertyKey = propertyExists.propertyKey();
            kernelPredicate = all ? this.propertyExistsExpander(propertyKey.name()) : this.propertyNotExistsExpander(propertyKey.name());
        } else if (expression instanceof Not && (predicate2 = (not = (Not)expression).a()) instanceof PropertyExists) {
            PropertyExists propertyExists = (PropertyExists)predicate2;
            KeyToken propertyKey = propertyExists.propertyKey();
            kernelPredicate = all ? this.propertyNotExistsExpander(propertyKey.name()) : this.propertyExistsExpander(propertyKey.name());
        } else {
            kernelPredicate = all ? this.cypherPositivePredicatesAsExpander(ctx, relVariableOffset, predicate, state) : this.cypherNegativePredicatesAsExpander(ctx, relVariableOffset, predicate, state);
        }
        KernelPredicate<Entity> filter = kernelPredicate;
        return new Tuple2((Object)currentExpander.addNodeFilter(filter), currentNodePredicates.$colon$plus(filter, Seq$.MODULE$.canBuildFrom()));
    }

    private Expander makeRelationshipTypeExpander() {
        return this.shortestPathPattern().relTypes().isEmpty() ? Expanders$.MODULE$.allTypes(this.shortestPathPattern().dir()) : (Expander)this.shortestPathPattern().relTypes().foldLeft((Object)Expanders$.MODULE$.typeDir(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TypeAndDirectionExpander e = (TypeAndDirectionExpander)tuple2._1();
            String t = (String)tuple2._2();
            TypeAndDirectionExpander typeAndDirectionExpander = e.add(t, this.shortestPathPattern().dir());
            return typeAndDirectionExpander;
        });
    }

    private Tuple2<Expander, Seq<KernelPredicate<Entity>>> addPredicates(ReadableRow ctx, Expander relTypeAndDirExpander, QueryState state) {
        return this.perStepPredicates().isEmpty() ? new Tuple2((Object)relTypeAndDirExpander, (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)) : (Tuple2)((TraversableOnce)this.perStepPredicates().map((Function1 & Serializable & scala.Serializable)predicate -> this.findPredicate((Predicate)predicate), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple2((Object)relTypeAndDirExpander, (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (arg_0, arg_1) -> ShortestPathExpression.$anonfun$addPredicates$2(this, ctx, state, arg_0, arg_1));
    }

    private boolean isNodesFunction(Expression expression) {
        boolean bl;
        block2: {
            while (true) {
                Expression expression2;
                if ((expression2 = expression) instanceof NodesFunction) {
                    bl = true;
                    break block2;
                }
                if (!(expression2 instanceof ExtendedExpression)) break;
                ExtendedExpression extendedExpression = (ExtendedExpression)((Object)expression2);
                expression = extendedExpression.legacy();
            }
            bl = false;
        }
        return bl;
    }

    private boolean isRelationshipsFunction(Expression expression) {
        boolean bl;
        block2: {
            while (true) {
                Expression expression2;
                if ((expression2 = expression) instanceof RelationshipFunction) {
                    bl = true;
                    break block2;
                }
                if (!(expression2 instanceof ExtendedExpression)) break;
                ExtendedExpression extendedExpression = (ExtendedExpression)((Object)expression2);
                expression = extendedExpression.legacy();
            }
            bl = false;
        }
        return bl;
    }

    public ShortestPathExpression copy(ShortestPath shortestPathPattern, Seq<Predicate> perStepPredicates, Seq<Predicate> fullPathPredicates, boolean withFallBack, boolean disallowSameNode, int operatorId) {
        return new ShortestPathExpression(shortestPathPattern, perStepPredicates, fullPathPredicates, withFallBack, disallowSameNode, operatorId);
    }

    public ShortestPath copy$default$1() {
        return this.shortestPathPattern();
    }

    public Seq<Predicate> copy$default$2() {
        return this.perStepPredicates();
    }

    public Seq<Predicate> copy$default$3() {
        return this.fullPathPredicates();
    }

    public boolean copy$default$4() {
        return this.withFallBack();
    }

    public boolean copy$default$5() {
        return this.disallowSameNode();
    }

    public int copy$default$6() {
        return this.operatorId();
    }

    public String productPrefix() {
        return "ShortestPathExpression";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.shortestPathPattern();
                break;
            }
            case 1: {
                object = this.perStepPredicates();
                break;
            }
            case 2: {
                object = this.fullPathPredicates();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.withFallBack());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.disallowSameNode());
                break;
            }
            case 5: {
                object = new Id(this.operatorId());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShortestPathExpression;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.shortestPathPattern()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.perStepPredicates()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.fullPathPredicates()));
        n = Statics.mix((int)n, (int)(this.withFallBack() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.disallowSameNode() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)new Id(this.operatorId())));
        return Statics.finalizeHash((int)n, (int)6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShortestPathExpression)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShortestPathExpression shortestPathExpression = (ShortestPathExpression)x$1;
        ShortestPath shortestPath = this.shortestPathPattern();
        ShortestPath shortestPath2 = shortestPathExpression.shortestPathPattern();
        if (shortestPath == null) {
            if (shortestPath2 != null) {
                return false;
            }
        } else if (!((Object)shortestPath).equals(shortestPath2)) return false;
        Seq<Predicate> seq = this.perStepPredicates();
        Seq<Predicate> seq2 = shortestPathExpression.perStepPredicates();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Predicate> seq3 = this.fullPathPredicates();
        Seq<Predicate> seq4 = shortestPathExpression.fullPathPredicates();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        if (this.withFallBack() != shortestPathExpression.withFallBack()) return false;
        if (this.disallowSameNode() != shortestPathExpression.disallowSameNode()) return false;
        if (this.operatorId() != shortestPathExpression.operatorId()) return false;
        if (!shortestPathExpression.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getMatches$2(Path p) {
        return p.length() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$getMatches$6(ShortestPathExpression $this, Path p) {
        return $this.shortestPathPattern().allowZeroLength() || p.length() > 0;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$addPredicates$2(ShortestPathExpression $this, ReadableRow ctx$1, QueryState state$4, Tuple2 x0$1, Expression x1$1) {
        block4: {
            block2: {
                block6: {
                    block5: {
                        block3: {
                            var7_5 = new Tuple2((Object)x0$1, (Object)x1$1);
                            if (var7_5 == null) break block2;
                            var8_6 = (Tuple2)var7_5._1();
                            predicate = (Expression)var7_5._2();
                            if (var8_6 == null) break block2;
                            currentExpander = (Expander)var8_6._1();
                            currentNodePredicates = (Seq)var8_6._2();
                            if (currentNodePredicates == null) break block2;
                            var12_10 = currentNodePredicates;
                            var13_11 = false;
                            var14_12 = null;
                            var15_13 = false;
                            var16_14 = null;
                            var17_15 = predicate;
                            if (!(var17_15 instanceof NoneInList)) break block3;
                            var13_11 = true;
                            var14_12 = (NoneInList)var17_15;
                            relFunction = var14_12.collection();
                            variableOffset = var14_12.innerVariableOffset();
                            innerPredicate = var14_12.inner();
                            if (!$this.isRelationshipsFunction(relFunction)) break block3;
                            expander = $this.addAllOrNoneRelationshipExpander(ctx$1, currentExpander, false, innerPredicate, variableOffset, state$4);
                            var6_20 = new Tuple2((Object)expander, (Object)var12_10);
                            break block4;
                        }
                        if (!(var17_15 instanceof AllInList)) break block5;
                        var15_13 = true;
                        var16_14 = (AllInList)var17_15;
                        relFunction = var16_14.collection();
                        variableOffset = var16_14.innerVariableOffset();
                        innerPredicate = var16_14.inner();
                        if (!$this.isRelationshipsFunction(relFunction)) break block5;
                        expander = $this.addAllOrNoneRelationshipExpander(ctx$1, currentExpander, true, innerPredicate, variableOffset, state$4);
                        var6_20 = new Tuple2((Object)expander, (Object)var12_10);
                        break block4;
                    }
                    if (!var13_11) break block6;
                    nodeFunction = var14_12.collection();
                    variableOffset = var14_12.innerVariableOffset();
                    innerPredicate = var14_12.inner();
                    if (!$this.isNodesFunction(nodeFunction)) break block6;
                    var6_20 = $this.addAllOrNoneNodeExpander(ctx$1, currentExpander, false, innerPredicate, variableOffset, (Seq<KernelPredicate<Entity>>)var12_10, state$4);
                    break block4;
                }
                if (!var15_13) ** GOTO lbl-1000
                nodeFunction = var16_14.collection();
                variableOffset = var16_14.innerVariableOffset();
                innerPredicate = var16_14.inner();
                if ($this.isNodesFunction(nodeFunction)) {
                    var6_20 = $this.addAllOrNoneNodeExpander(ctx$1, currentExpander, true, innerPredicate, variableOffset, (Seq<KernelPredicate<Entity>>)var12_10, state$4);
                } else lbl-1000:
                // 2 sources

                {
                    var6_20 = new Tuple2((Object)currentExpander, (Object)var12_10);
                }
                break block4;
            }
            throw new MatchError((Object)var7_5);
        }
        var5_31 = var6_20;
        return var5_31;
    }

    public ShortestPathExpression(ShortestPath shortestPathPattern, Seq<Predicate> perStepPredicates, Seq<Predicate> fullPathPredicates, boolean withFallBack, boolean disallowSameNode, int operatorId) {
        this.shortestPathPattern = shortestPathPattern;
        this.perStepPredicates = perStepPredicates;
        this.fullPathPredicates = fullPathPredicates;
        this.withFallBack = withFallBack;
        this.disallowSameNode = disallowSameNode;
        this.operatorId = operatorId;
        Product.$init$((Product)this);
        this.predicates = (Seq)perStepPredicates.$plus$plus(fullPathPredicates, Seq$.MODULE$.canBuildFrom());
    }
}

