/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation;

import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.AggregationFunction;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingDurations$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingNumbers$;
import org.neo4j.exceptions.InternalException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.ValueMath;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\r\u001a\u0001)B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\ty\u0001\u0011\t\u0011)A\u0005i!)Q\b\u0001C\u0001}!)\u0011\t\u0001C\u0001\u0005\"91\n\u0001a\u0001\n\u0013a\u0005bB*\u0001\u0001\u0004%I\u0001\u0016\u0005\u00075\u0002\u0001\u000b\u0015B'\t\u000fm\u0003\u0001\u0019!C\u00059\"9\u0001\r\u0001a\u0001\n\u0013\t\u0007BB2\u0001A\u0003&Q\fC\u0004e\u0001\u0001\u0007I\u0011\u0002/\t\u000f\u0015\u0004\u0001\u0019!C\u0005M\"1\u0001\u000e\u0001Q!\nuCq!\u001b\u0001A\u0002\u0013%A\fC\u0004k\u0001\u0001\u0007I\u0011B6\t\r5\u0004\u0001\u0015)\u0003^\u0011\u001dq\u0007\u00011A\u0005\nqCqa\u001c\u0001A\u0002\u0013%\u0001\u000f\u0003\u0004s\u0001\u0001\u0006K!\u0018\u0005\u0006g\u0002!\t\u0005\u001e\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aa!!\u000b\u0001\t\u0003a%aC!wO\u001a+hn\u0019;j_:T!AG\u000e\u0002\u0017\u0005<wM]3hCRLwN\u001c\u0006\u00039u\tQ\u0001]5qKNT!AH\u0010\u0002\u0017%tG/\u001a:qe\u0016$X\r\u001a\u0006\u0003A\u0005\nqA];oi&lWM\u0003\u0002#G\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002%K\u000511-\u001f9iKJT!AJ\u0014\u0002\u000b9,w\u000e\u000e6\u000b\u0003!\n1a\u001c:h\u0007\u0001\u00192\u0001A\u00160!\taS&D\u0001\u001a\u0013\tq\u0013DA\nBO\u001e\u0014XmZ1uS>tg)\u001e8di&|g\u000e\u0005\u0002-a%\u0011\u0011'\u0007\u0002'\u001dVlWM]5d\u001fJ$UO]1uS>t\u0017iZ4sK\u001e\fG/[8o\u000bb\u0004(/Z:tS>t\u0017!\u0002<bYV,W#\u0001\u001b\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014aC3yaJ,7o]5p]NT!!O\u000f\u0002\u0011\r|W.\\1oINL!a\u000f\u001c\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004wC2,X\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\u0002\u0005C\u0001\u0017\u0001\u0011\u0015\u00114\u00011\u00015\u0003\u0011q\u0017-\\3\u0016\u0003\r\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\t1\fgn\u001a\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQUI\u0001\u0004TiJLgnZ\u0001\u0006G>,h\u000e^\u000b\u0002\u001bB\u0011a*U\u0007\u0002\u001f*\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u001f\n!Aj\u001c8h\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0002V1B\u0011aJV\u0005\u0003/>\u0013A!\u00168ji\"9\u0011LBA\u0001\u0002\u0004i\u0015a\u0001=%c\u000511m\\;oi\u0002\n\u0001#\\8oi\"\u001c(+\u001e8oS:<\u0017I^4\u0016\u0003u\u0003\"A\u00140\n\u0005}{%A\u0002#pk\ndW-\u0001\u000bn_:$\bn\u001d*v]:LgnZ!wO~#S-\u001d\u000b\u0003+\nDq!W\u0005\u0002\u0002\u0003\u0007Q,A\tn_:$\bn\u001d*v]:LgnZ!wO\u0002\na\u0002Z1zgJ+hN\\5oO\u00063x-\u0001\neCf\u001c(+\u001e8oS:<\u0017I^4`I\u0015\fHCA+h\u0011\u001dIF\"!AA\u0002u\u000bq\u0002Z1zgJ+hN\\5oO\u00063x\rI\u0001\u0012g\u0016\u001cwN\u001c3t%Vtg.\u001b8h\u0003Z<\u0017!F:fG>tGm\u001d*v]:LgnZ!wO~#S-\u001d\u000b\u0003+2Dq!W\b\u0002\u0002\u0003\u0007Q,\u0001\ntK\u000e|g\u000eZ:Sk:t\u0017N\\4Bm\u001e\u0004\u0013a\u00048b]>\u001c(+\u001e8oS:<\u0017I^4\u0002'9\fgn\\:Sk:t\u0017N\\4Bm\u001e|F%Z9\u0015\u0005U\u000b\bbB-\u0013\u0003\u0003\u0005\r!X\u0001\u0011]\u0006twn\u001d*v]:LgnZ!wO\u0002\naA]3tk2$HCA;~!\t180D\u0001x\u0015\tA\u00180\u0001\u0005ti>\u0014\u0018M\u00197f\u0015\tQX%\u0001\u0004wC2,Xm]\u0005\u0003y^\u0014QAV1mk\u0016DQA \u000bA\u0002}\fQa\u001d;bi\u0016\u0004B!!\u0001\u0002\u00045\t1$C\u0002\u0002\u0006m\u0011!\"U;fef\u001cF/\u0019;f\u0003\u0015\t\u0007\u000f\u001d7z)\u0015)\u00161BA\f\u0011\u001d\ti!\u0006a\u0001\u0003\u001f\tA\u0001Z1uCB!\u0011\u0011CA\n\u001b\u0005y\u0012bAA\u000b?\tY!+Z1eC\ndWMU8x\u0011\u0015qX\u00031\u0001\u0000\u0003I\t\u0007\u000f\u001d7z-\u0006dW/\u001a#je\u0016\u001cG\u000f\\=\u0015\u0007U\u000bi\u0002C\u0004\u0002 Y\u0001\r!!\t\u0002\u0005Yd\u0007\u0003BA\u0012\u0003Ki\u0011!_\u0005\u0004\u0003OI(\u0001C!osZ\u000bG.^3\u0002%\u0005<wM]3hCR,GMU8x\u0007>,h\u000e\u001e")
public class AvgFunction
extends AggregationFunction
implements NumericOrDurationAggregationExpression {
    private final Expression value;
    private long count;
    private double monthsRunningAvg;
    private double daysRunningAvg;
    private double secondsRunningAvg;
    private double nanosRunningAvg;
    private volatile NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers$module;
    private volatile NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations$module;
    private NumberValue sumNumber;
    private DurationValue sumDuration;
    private Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType;

    @Override
    public void actOnNumberOrDuration(AnyValue vl, Function1<NumberValue, BoxedUnit> aggNumber, Function1<DurationValue, BoxedUnit> aggDuration) {
        NumericOrDurationAggregationExpression.actOnNumberOrDuration$(this, vl, aggNumber, aggDuration);
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers() {
        if (this.AggregatingNumbers$module == null) {
            this.AggregatingNumbers$lzycompute$1();
        }
        return this.AggregatingNumbers$module;
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations() {
        if (this.AggregatingDurations$module == null) {
            this.AggregatingDurations$lzycompute$1();
        }
        return this.AggregatingDurations$module;
    }

    @Override
    public NumberValue sumNumber() {
        return this.sumNumber;
    }

    @Override
    public void sumNumber_$eq(NumberValue x$1) {
        this.sumNumber = x$1;
    }

    @Override
    public DurationValue sumDuration() {
        return this.sumDuration;
    }

    @Override
    public void sumDuration_$eq(DurationValue x$1) {
        this.sumDuration = x$1;
    }

    @Override
    public Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType() {
        return this.aggregatingType;
    }

    @Override
    public void aggregatingType_$eq(Option<NumericOrDurationAggregationExpression.AggregatingType> x$1) {
        this.aggregatingType = x$1;
    }

    @Override
    public Expression value() {
        return this.value;
    }

    @Override
    public String name() {
        return "AVG";
    }

    private long count() {
        return this.count;
    }

    private void count_$eq(long x$1) {
        this.count = x$1;
    }

    private double monthsRunningAvg() {
        return this.monthsRunningAvg;
    }

    private void monthsRunningAvg_$eq(double x$1) {
        this.monthsRunningAvg = x$1;
    }

    private double daysRunningAvg() {
        return this.daysRunningAvg;
    }

    private void daysRunningAvg_$eq(double x$1) {
        this.daysRunningAvg = x$1;
    }

    private double secondsRunningAvg() {
        return this.secondsRunningAvg;
    }

    private void secondsRunningAvg_$eq(double x$1) {
        this.secondsRunningAvg = x$1;
    }

    private double nanosRunningAvg() {
        return this.nanosRunningAvg;
    }

    private void nanosRunningAvg_$eq(double x$1) {
        this.nanosRunningAvg = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value result(QueryState state) {
        boolean bl = false;
        Some some = null;
        Option<NumericOrDurationAggregationExpression.AggregatingType> option = this.aggregatingType();
        if (None$.MODULE$.equals(option)) {
            return Values.NO_VALUE;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
            if (this.AggregatingNumbers().equals(aggregatingType)) {
                return this.sumNumber();
            }
        }
        if (!bl) throw new InternalException(new StringBuilder(25).append("invalid aggregation type ").append(this.aggregatingType()).toString());
        NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
        if (!this.AggregatingDurations().equals(aggregatingType)) throw new InternalException(new StringBuilder(25).append("invalid aggregation type ").append(this.aggregatingType()).toString());
        return DurationValue.approximate((double)this.monthsRunningAvg(), (double)this.daysRunningAvg(), (double)this.secondsRunningAvg(), (double)this.nanosRunningAvg()).normalize();
    }

    @Override
    public void apply(ReadableRow data, QueryState state) {
        AnyValue vl = this.value().apply(data, state);
        this.applyValueDirectly(vl);
    }

    public void applyValueDirectly(AnyValue vl) {
        this.actOnNumberOrDuration(vl, (Function1<NumberValue, BoxedUnit>)(Function1 & Serializable & scala.Serializable)number -> {
            AvgFunction.$anonfun$applyValueDirectly$1(this, number);
            return BoxedUnit.UNIT;
        }, (Function1<DurationValue, BoxedUnit>)(Function1 & Serializable & scala.Serializable)duration -> {
            AvgFunction.$anonfun$applyValueDirectly$2(this, duration);
            return BoxedUnit.UNIT;
        });
    }

    public long aggregatedRowCount() {
        return this.count();
    }

    private final void AggregatingNumbers$lzycompute$1() {
        AvgFunction avgFunction = this;
        synchronized (avgFunction) {
            if (this.AggregatingNumbers$module == null) {
                this.AggregatingNumbers$module = new NumericOrDurationAggregationExpression$AggregatingNumbers$(this);
            }
        }
    }

    private final void AggregatingDurations$lzycompute$1() {
        AvgFunction avgFunction = this;
        synchronized (avgFunction) {
            if (this.AggregatingDurations$module == null) {
                this.AggregatingDurations$module = new NumericOrDurationAggregationExpression$AggregatingDurations$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$applyValueDirectly$1(AvgFunction $this, NumberValue number) {
        $this.count_$eq($this.count() + 1L);
        NumberValue diff = number.minus($this.sumNumber());
        NumberValue next = diff.dividedBy((double)$this.count());
        $this.sumNumber_$eq(ValueMath.overflowSafeAdd((NumberValue)$this.sumNumber(), (NumberValue)next));
    }

    public static final /* synthetic */ void $anonfun$applyValueDirectly$2(AvgFunction $this, DurationValue duration) {
        $this.count_$eq($this.count() + 1L);
        $this.monthsRunningAvg_$eq($this.monthsRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.MONTHS) - $this.monthsRunningAvg()) / (double)$this.count());
        $this.daysRunningAvg_$eq($this.daysRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.DAYS) - $this.daysRunningAvg()) / (double)$this.count());
        $this.secondsRunningAvg_$eq($this.secondsRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.SECONDS) - $this.secondsRunningAvg()) / (double)$this.count());
        $this.nanosRunningAvg_$eq($this.nanosRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.NANOS) - $this.nanosRunningAvg()) / (double)$this.count());
    }

    public AvgFunction(Expression value) {
        this.value = value;
        NumericOrDurationAggregationExpression.$init$(this);
        this.count = 0L;
        this.monthsRunningAvg = 0.0;
        this.daysRunningAvg = 0.0;
        this.secondsRunningAvg = 0.0;
        this.nanosRunningAvg = 0.0;
    }
}

