/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical.debug;

import java.io.Serializable;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.compiler.phases.PlannerContext;
import org.neo4j.cypher.internal.ir.PeriodicCommit;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.logical.plans.Argument;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.ProduceResult;
import org.neo4j.cypher.internal.logical.plans.UnwindCollection;
import org.neo4j.cypher.internal.planner.spi.PlanningAttributes;
import org.neo4j.cypher.internal.v4_0.ast.AliasedReturnItem;
import org.neo4j.cypher.internal.v4_0.ast.Query;
import org.neo4j.cypher.internal.v4_0.ast.QueryPart;
import org.neo4j.cypher.internal.v4_0.ast.Return;
import org.neo4j.cypher.internal.v4_0.ast.ReturnItems;
import org.neo4j.cypher.internal.v4_0.ast.ReturnItemsDef;
import org.neo4j.cypher.internal.v4_0.ast.SingleQuery;
import org.neo4j.cypher.internal.v4_0.ast.Statement;
import org.neo4j.cypher.internal.v4_0.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.v4_0.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.v4_0.expressions.Expression;
import org.neo4j.cypher.internal.v4_0.expressions.ListLiteral;
import org.neo4j.cypher.internal.v4_0.expressions.LogicalVariable;
import org.neo4j.cypher.internal.v4_0.expressions.StringLiteral;
import org.neo4j.cypher.internal.v4_0.expressions.Variable;
import org.neo4j.cypher.internal.v4_0.frontend.PlannerName;
import org.neo4j.cypher.internal.v4_0.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.v4_0.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.v4_0.frontend.phases.Condition;
import org.neo4j.cypher.internal.v4_0.frontend.phases.Phase;
import org.neo4j.cypher.internal.v4_0.frontend.phases.Transformer;
import org.neo4j.cypher.internal.v4_0.util.InputPosition;
import org.neo4j.cypher.internal.v4_0.util.attribution.IdGen;
import org.neo4j.cypher.internal.v4_0.util.attribution.SequentialIdGen;
import org.neo4j.cypher.internal.v4_0.util.attribution.SequentialIdGen$;
import org.neo4j.cypher.internal.v4_0.util.symbols.CypherType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class DebugPrinter$
implements Phase<PlannerContext, LogicalPlanState, LogicalPlanState> {
    public static DebugPrinter$ MODULE$;

    static {
        new DebugPrinter$();
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends PlannerContext, TO2> Transformer<D, LogicalPlanState, TO2> andThen(Transformer<D, LogicalPlanState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public Transformer<PlannerContext, LogicalPlanState, LogicalPlanState> adds(Condition condition) {
        return Transformer.adds$((Transformer)this, (Condition)condition);
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.LOGICAL_PLANNING;
    }

    public String description() {
        return "Print IR or AST as query result";
    }

    public LogicalPlanState process(LogicalPlanState from, PlannerContext context) {
        String string = context.debugOptions().contains((Object)"querygraph") ? from.query().toString() : (context.debugOptions().contains((Object)"ast") ? from.statement().toString() : (context.debugOptions().contains((Object)"semanticstate") ? from.semantics().toString() : (context.debugOptions().contains((Object)"logicalplan") ? from.logicalPlan().toString() : "Output options are: queryGraph, ast, semanticstate, logicalplan")));
        context.planContext().statistics().nodesAllCardinality();
        Tuple2<LogicalPlan, Statement> tuple2 = this.stringToLogicalPlan(string);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LogicalPlan plan = (LogicalPlan)tuple2._1();
        Statement newStatement = (Statement)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)plan, (Object)newStatement);
        Tuple2 tuple23 = tuple22;
        LogicalPlan plan2 = (LogicalPlan)tuple23._1();
        Statement newStatement2 = (Statement)tuple23._2();
        Some x$2 = new Some((Object)None$.MODULE$);
        Some x$3 = new Some((Object)plan2);
        Some x$4 = new Some((Object)newStatement2);
        String x$5 = from.copy$default$1();
        Option<InputPosition> x$6 = from.copy$default$2();
        PlannerName x$7 = from.copy$default$3();
        PlanningAttributes x$8 = from.copy$default$4();
        Option<SemanticState> x$9 = from.copy$default$6();
        Option<Map<String, Object>> x$10 = from.copy$default$7();
        Option<SemanticTable> x$11 = from.copy$default$8();
        Option<PlannerQuery> x$12 = from.copy$default$9();
        Set<Condition> x$13 = from.copy$default$12();
        Map<String, CypherType> x$14 = from.copy$default$13();
        boolean x$15 = from.copy$default$14();
        Option<Seq<String>> x$16 = from.copy$default$15();
        return from.copy(x$5, x$6, x$7, x$8, (Option<Statement>)x$4, x$9, x$10, x$11, x$12, (Option<LogicalPlan>)x$3, (Option<Option<PeriodicCommit>>)x$2, x$13, x$14, x$15, x$16);
    }

    private Tuple2<LogicalPlan, Statement> stringToLogicalPlan(String string) {
        SequentialIdGen idGen = new SequentialIdGen(SequentialIdGen$.MODULE$.$lessinit$greater$default$1());
        InputPosition pos = new InputPosition(0, 0, 0);
        StringLiteral[] stringValues = (StringLiteral[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.split(System.lineSeparator()))).map((Function1 & Serializable & scala.Serializable)s -> new StringLiteral(s, pos), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StringLiteral.class)));
        ListLiteral expression = new ListLiteral(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringValues)).toSeq(), pos);
        UnwindCollection unwind = new UnwindCollection((LogicalPlan)new Argument(Predef$.MODULE$.Set().empty(), (IdGen)idGen), "col", (Expression)expression, (IdGen)idGen);
        ProduceResult logicalPlan = new ProduceResult((LogicalPlan)unwind, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col"})), (IdGen)idGen);
        Variable variable = new Variable("col", pos);
        AliasedReturnItem returnItem = new AliasedReturnItem((Expression)variable, (LogicalVariable)variable, pos);
        Return returnClause = new Return(false, (ReturnItemsDef)new ReturnItems(false, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AliasedReturnItem[]{returnItem})), pos), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, Predef$.MODULE$.Set().empty(), pos);
        Query newStatement = new Query((Option)None$.MODULE$, (QueryPart)new SingleQuery((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Return[]{returnClause})), pos), pos);
        return new Tuple2((Object)logicalPlan, (Object)newStatement);
    }

    public Set<Condition> postConditions() {
        return Predef$.MODULE$.Set().empty();
    }

    private DebugPrinter$() {
        MODULE$ = this;
        Transformer.$init$((Transformer)this);
        Phase.$init$((Phase)this);
    }
}

