/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.collection;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.io.IOUtils;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

abstract class MemoryTrackingHeap<T>
extends DefaultCloseListenable
implements AutoCloseablePlus {
    protected final Comparator<? super T> comparator;
    protected final MemoryTracker memoryTracker;
    private long trackedSize;
    protected int size;
    protected T[] heap;

    protected MemoryTrackingHeap(Comparator<? super T> comparator, int initialSize, MemoryTracker memoryTracker) {
        this.comparator = Objects.requireNonNull(comparator);
        this.memoryTracker = memoryTracker;
        Preconditions.checkArgument((initialSize > 0 ? 1 : 0) != 0, (String)"Table size must be greater than 0");
        this.trackedSize = HeapEstimator.shallowSizeOfObjectArray((int)initialSize);
        memoryTracker.allocateHeap(this.shallowInstanceSize() + this.trackedSize);
        this.heap = new Object[initialSize];
    }

    protected abstract long shallowInstanceSize();

    protected boolean insert(T e) {
        int n = this.size;
        if (n >= this.heap.length) {
            this.grow(n + 1);
        }
        this.siftUp(n, e);
        this.size = n + 1;
        return true;
    }

    protected T replace(T e) {
        T head = this.heap[0];
        if (this.comparator.compare(head, e) > 0) {
            this.heap[0] = e;
            this.siftDown(0, e, this.size);
            return head;
        }
        return e;
    }

    protected void sort() {
        for (int n = this.size - 1; n > 0; --n) {
            T tmp = this.heap[n];
            this.heap[n] = this.heap[0];
            this.heap[0] = tmp;
            this.siftDown(0, tmp, n);
        }
    }

    protected void clear() {
        Arrays.fill(this.heap, 0, this.size, null);
        this.size = 0;
    }

    public void closeInternal() {
        if (this.heap != null) {
            this.memoryTracker.releaseHeap(this.shallowInstanceSize() + this.trackedSize);
            this.heap = null;
        }
    }

    public boolean isClosed() {
        return false;
    }

    protected Iterator<T> getIterator() {
        return Iterators.iterator((int)this.size, (Object[])this.heap);
    }

    protected Iterator<T> getAutoClosingIterator(final AutoCloseable closeable) {
        return new Iterator<T>(){
            int index;

            @Override
            public boolean hasNext() {
                if (this.index >= MemoryTrackingHeap.this.size) {
                    MemoryTrackingHeap.this.close();
                    if (closeable != null) {
                        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{closeable});
                    }
                    return false;
                }
                return true;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return MemoryTrackingHeap.this.heap[this.index++];
            }
        };
    }

    protected void heapify() {
        for (int i = (this.size >>> 1) - 1; i >= 0; --i) {
            this.siftDown(i, this.heap[i], this.size);
        }
    }

    protected void siftDown(int k, T x, int n) {
        int half = n >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            T c = this.heap[child];
            int right = child + 1;
            if (right < n && this.comparator.compare(c, this.heap[right]) < 0) {
                child = right;
                c = this.heap[child];
            }
            if (this.comparator.compare(x, c) >= 0) break;
            this.heap[k] = c;
            k = child;
        }
        this.heap[k] = x;
    }

    private void siftUp(int k, T x) {
        int parent;
        T e;
        while (k > 0 && this.comparator.compare(x, e = this.heap[parent = k - 1 >>> 1]) > 0) {
            this.heap[k] = e;
            k = parent;
        }
        this.heap[k] = x;
    }

    protected abstract void overflow(long var1);

    protected void grow(long minimumCapacity) {
        int oldCapacity = this.heap.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1) + 1;
        if (newCapacity > 0x7FFFFFF7 || newCapacity < 0) {
            if (minimumCapacity > 0x7FFFFFF7L) {
                this.overflow(0x7FFFFFF7L);
            }
            newCapacity = 0x7FFFFFF7;
        }
        long oldHeapUsage = this.trackedSize;
        this.trackedSize = HeapEstimator.shallowSizeOfObjectArray((int)newCapacity);
        this.memoryTracker.allocateHeap(this.trackedSize);
        Object[] newHeap = new Object[newCapacity];
        System.arraycopy(this.heap, 0, newHeap, 0, Math.min(this.size, newCapacity));
        this.heap = newHeap;
        this.memoryTracker.releaseHeap(oldHeapUsage);
    }
}

