/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.Optional;
import java.util.UUID;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public final class GraphFunctions {
    private GraphFunctions() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static AnyValue names(DatabaseReferenceImpl.Composite composite, SecurityContext securityContext) {
        Object[] graphNames = (String[])composite.constituents().stream().filter(constituent -> securityContext.databaseAccessMode().canAccessDatabase(constituent)).map(constituent -> constituent.fullName().name()).toArray(String[]::new);
        return Values.arrayValue((Object[])graphNames, (boolean)false);
    }

    public static DatabaseReference graphByName(String databaseName, DatabaseReferenceImpl.Composite composite, SecurityContext securityContext) {
        Optional graph = composite.getConstituentByName(databaseName);
        if (graph.isPresent() && securityContext.databaseAccessMode().canAccessDatabase((DatabaseReference)graph.get())) {
            return (DatabaseReference)graph.get();
        }
        throw GraphFunctions.graphNotFound(composite.fullName().name(), databaseName);
    }

    public static DatabaseReference graphById(UUID databaseId, DatabaseReferenceImpl.Composite composite, SecurityContext securityContext) {
        Optional graph = composite.getConstituentById(databaseId);
        if (graph.isPresent() && securityContext.databaseAccessMode().canAccessDatabase((DatabaseReference)graph.get())) {
            return (DatabaseReference)graph.get();
        }
        throw GraphFunctions.graphNotFound(composite.fullName().name(), databaseId.toString());
    }

    public static MapValue graphProperties(String databaseName, DatabaseReferenceImpl.Composite composite, SecurityContext securityContext, TopologyGraphDbmsModel topologyGraphDbmsModel) {
        DatabaseReference graph = GraphFunctions.graphByName(databaseName, composite, securityContext);
        Optional properties = topologyGraphDbmsModel.getAliasProperties(graph.fullName().name(), (String)graph.namespace().map(NormalizedDatabaseName::name).orElse(null));
        MapValueBuilder builder = new MapValueBuilder();
        properties.ifPresent(stringObjectMap -> stringObjectMap.forEach((key, value) -> builder.add(key, (AnyValue)Values.of((Object)value))));
        return builder.build();
    }

    private static EntityNotFoundException graphNotFound(String compositeGraph, String graph) {
        return new EntityNotFoundException(String.format("When connected to a composite database, access is allowed only to its constituents. Attempted to access '%s' while connected to '%s'", graph, compositeGraph));
    }
}

