/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.Objects;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.Lengths;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PGPathPropagatingBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TwoWaySignpost
implements Measurable {
    public static final int NO_TARGET_DISTANCE = -1;
    public final NodeState prevNode;
    public final NodeState forwardNode;
    protected final Lengths lengths;
    protected int minTargetDistance = -1;

    protected TwoWaySignpost(MemoryTracker mt, NodeState prevNode, NodeState forwardNode) {
        this.prevNode = prevNode;
        this.forwardNode = forwardNode;
        this.lengths = new Lengths();
        mt.allocateHeap(this.estimatedHeapUsage());
    }

    protected TwoWaySignpost(MemoryTracker mt, NodeState prevNode, NodeState forwardNode, int sourceLength) {
        this(mt, prevNode, forwardNode);
        this.lengths.set(sourceLength, Lengths.Type.Source);
    }

    public static RelSignpost fromRelExpansion(MemoryTracker mt, NodeState prevNode, long relId, NodeState forwardNode, RelationshipExpansion relationshipExpansion, int sourceLength) {
        return new RelSignpost(mt, prevNode, relId, forwardNode, relationshipExpansion, sourceLength);
    }

    public static RelSignpost fromRelExpansion(MemoryTracker mt, NodeState prevNode, long relId, NodeState forwardNode, RelationshipExpansion relationshipExpansion) {
        return new RelSignpost(mt, prevNode, relId, forwardNode, relationshipExpansion);
    }

    public static NodeSignpost fromNodeJuxtaposition(MemoryTracker mt, NodeState prevNode, NodeState forwardNode, int sourceLength) {
        return new NodeSignpost(mt, prevNode, forwardNode, sourceLength);
    }

    public static NodeSignpost fromNodeJuxtaposition(MemoryTracker mt, NodeState prevNode, NodeState forwardNode) {
        return new NodeSignpost(mt, prevNode, forwardNode);
    }

    public abstract int dataGraphLength();

    public boolean hasBeenTraced() {
        return this.minTargetDistance != -1;
    }

    public void setMinTargetDistance(int distance, PGPathPropagatingBFS.Phase phase) {
        Preconditions.checkState((this.minTargetDistance == -1 ? 1 : 0) != 0, (String)"A signpost should only have setMinDistToTarget() called upon it on the first trace");
        this.minTargetDistance = distance;
        this.prevNode.addTargetSignpost(this, distance, phase);
    }

    public int minTargetDistance() {
        return this.minTargetDistance;
    }

    public void addSourceLength(int sourceLength) {
        this.lengths.set(sourceLength, Lengths.Type.Source);
        this.prevNode.globalState.hooks.addSourceLength(this, sourceLength);
    }

    public boolean hasSourceLength(int sourceLength) {
        return this.lengths.get(sourceLength, Lengths.Type.Source);
    }

    public void propagate(int sourceLength, int targetLength) {
        int newLength = sourceLength + this.dataGraphLength();
        this.forwardNode.newPropagatedSourceLength(newLength, targetLength - this.dataGraphLength());
        this.addSourceLength(newLength);
    }

    public void pruneSourceLength(int sourceLength) {
        this.prevNode.globalState.hooks.pruneSourceLength(this, sourceLength);
        this.lengths.clear(sourceLength, Lengths.Type.Source);
        this.forwardNode.synchronizeLengthAfterPrune(sourceLength);
    }

    public void setVerified(int sourceLength) {
        this.prevNode.globalState.hooks.setVerified(this, sourceLength);
        this.lengths.set(sourceLength, Lengths.Type.ConfirmedSource);
    }

    public boolean isVerifiedAtLength(int sourceLength) {
        return this.lengths.get(sourceLength, Lengths.Type.ConfirmedSource);
    }

    public static final class RelSignpost
    extends TwoWaySignpost {
        public final long relId;
        public final RelationshipExpansion relationshipExpansion;
        private static long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelSignpost.class);

        private RelSignpost(MemoryTracker mt, NodeState prevNode, long relId, NodeState forwardNode, RelationshipExpansion relationshipExpansion, int lengthFromSource) {
            super(mt, prevNode, forwardNode, lengthFromSource);
            this.relId = relId;
            this.relationshipExpansion = relationshipExpansion;
        }

        private RelSignpost(MemoryTracker mt, NodeState prevNode, long relId, NodeState forwardNode, RelationshipExpansion relationshipExpansion) {
            super(mt, prevNode, forwardNode);
            this.relId = relId;
            this.relationshipExpansion = relationshipExpansion;
        }

        @Override
        public int dataGraphLength() {
            return 1;
        }

        private SlotOrName slotOrName() {
            return this.relationshipExpansion.slotOrName();
        }

        public String toString() {
            String sourceLengths;
            StringBuilder sb = new StringBuilder("RE ").append(this.prevNode).append("-[");
            if (this.slotOrName() != SlotOrName.none()) {
                sb.append(this.slotOrName()).append("@");
            }
            sb.append(this.relId).append("]->").append(this.forwardNode);
            if (this.minTargetDistance != -1) {
                sb.append(", minTargetDistance: ").append(this.minTargetDistance);
            }
            if (!(sourceLengths = this.lengths.renderSourceLengths()).isEmpty()) {
                sb.append(", sourceLengths: ").append(sourceLengths);
            }
            return sb.toString();
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE + Lengths.SHALLOW_SIZE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelSignpost that = (RelSignpost)o;
            return this.prevNode == that.prevNode && this.forwardNode == that.forwardNode && this.relId == that.relId;
        }

        public int hashCode() {
            return Objects.hash(this.prevNode, this.forwardNode, this.relId);
        }
    }

    public static final class NodeSignpost
    extends TwoWaySignpost {
        private static long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeSignpost.class);

        private NodeSignpost(MemoryTracker mt, NodeState prevNode, NodeState forwardNode, int lengthFromSource) {
            super(mt, prevNode, forwardNode, lengthFromSource);
            assert (prevNode != forwardNode) : "A state cannot have a node juxtaposition to itself";
        }

        private NodeSignpost(MemoryTracker mt, NodeState prevNode, NodeState forwardNode) {
            super(mt, prevNode, forwardNode);
            assert (prevNode != forwardNode) : "A state cannot have a node juxtaposition to itself";
        }

        @Override
        public int dataGraphLength() {
            return 0;
        }

        public String toString() {
            String sourceLengths;
            StringBuilder sb = new StringBuilder("NJ ").append(this.prevNode).append(" ").append(this.forwardNode);
            if (this.minTargetDistance != -1) {
                sb.append(", minTargetDistance: ").append(this.minTargetDistance);
            }
            if (!(sourceLengths = this.lengths.renderSourceLengths()).isEmpty()) {
                sb.append(", sourceLengths: ").append(sourceLengths);
            }
            return sb.toString();
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE + Lengths.SHALLOW_SIZE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeSignpost that = (NodeSignpost)o;
            return this.prevNode == that.prevNode && this.forwardNode == that.forwardNode;
        }

        public int hashCode() {
            return Objects.hash(this.prevNode, this.forwardNode);
        }
    }
}

