/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.javacompat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.cypher.ExtendedPlanDescription;
import org.neo4j.cypher.PlanDescription;
import org.neo4j.cypher.ProfilerStatisticsNotReadyException;
import org.neo4j.cypher.javacompat.ProfilerStatistics;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.helpers.Exceptions;
import scala.collection.JavaConversions;

class Description
implements ExecutionPlanDescription {
    private final PlanDescription description;

    public Description(PlanDescription description) {
        this.description = description;
    }

    public String toString() {
        return this.description.toString();
    }

    public String getName() {
        return this.description.name();
    }

    public List<ExecutionPlanDescription> getChildren() {
        ArrayList<ExecutionPlanDescription> result = new ArrayList<ExecutionPlanDescription>();
        for (PlanDescription child : JavaConversions.asJavaIterable(this.description.children())) {
            result.add(new Description(child));
        }
        return result;
    }

    public Map<String, Object> getArguments() {
        return JavaConversions.asJavaMap(this.description.arguments());
    }

    public Set<String> getIdentifiers() {
        if (this.description instanceof ExtendedPlanDescription) {
            return JavaConversions.asJavaSet(((ExtendedPlanDescription)this.description).identifiers());
        }
        return Collections.emptySet();
    }

    public boolean hasProfilerStatistics() {
        return this.description.hasProfilerStatistics();
    }

    public ExecutionPlanDescription.ProfilerStatistics getProfilerStatistics() {
        ProfilerStatistics statistics;
        try {
            statistics = this.description.asJava().getProfilerStatistics();
        }
        catch (ProfilerStatisticsNotReadyException e) {
            throw (NoSuchElementException)Exceptions.withCause((Throwable)new NoSuchElementException(e.getMessage()), (Throwable)e);
        }
        return new ExecutionPlanDescription.ProfilerStatistics(){

            public long getRows() {
                return statistics.getRows();
            }

            public long getDbHits() {
                return statistics.getDbHits();
            }

            public String toString() {
                return statistics.toString();
            }
        };
    }
}

