/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi.v2_3;

import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Cardinality;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Selectivity;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Selectivity$;
import org.neo4j.cypher.internal.compiler.v2_3.spi.GraphStatistics;
import org.neo4j.cypher.internal.compiler.v2_3.spi.StatisticsCompletingGraphStatistics;
import org.neo4j.cypher.internal.frontend.v2_3.LabelId;
import org.neo4j.cypher.internal.frontend.v2_3.NameId;
import org.neo4j.cypher.internal.frontend.v2_3.NameId$;
import org.neo4j.cypher.internal.frontend.v2_3.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v2_3.RelTypeId;
import org.neo4j.cypher.internal.spi.v2_3.TransactionBoundGraphStatistics$;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.impl.api.store.DefaultIndexReference;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u<Q!\u0001\u0002\t\u0002=\tq\u0004\u0016:b]N\f7\r^5p]\n{WO\u001c3He\u0006\u0004\bn\u0015;bi&\u001cH/[2t\u0015\t\u0019A!\u0001\u0003we}\u001b$BA\u0003\u0007\u0003\r\u0019\b/\u001b\u0006\u0003\u000f!\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u0013)\taaY=qQ\u0016\u0014(BA\u0006\r\u0003\u0015qWm\u001c\u001bk\u0015\u0005i\u0011aA8sO\u000e\u0001\u0001C\u0001\t\u0012\u001b\u0005\u0011a!\u0002\n\u0003\u0011\u0003\u0019\"a\b+sC:\u001c\u0018m\u0019;j_:\u0014u.\u001e8e\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dgN\u0011\u0011\u0003\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000bm\tB\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005y\u0001\"\u0002\u0010\u0012\t\u0003y\u0012!B1qa2LHc\u0001\u0011)gA\u0011\u0011EJ\u0007\u0002E)\u0011Qa\t\u0006\u0003\u0007\u0011R!!\n\u0004\u0002\u0011\r|W\u000e]5mKJL!a\n\u0012\u0003GM#\u0018\r^5ti&\u001c7oQ8na2,G/\u001b8h\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dg\")\u0011&\ba\u0001U\u0005!!/Z1e!\tY\u0013'D\u0001-\u0015\tic&A\u0002ba&T!a\f\u0019\u0002\r-,'O\\3m\u0015\t9!\"\u0003\u00023Y\t!!+Z1e\u0011\u0015!T\u00041\u00016\u0003)\u00198\r[3nCJ+\u0017\r\u001a\t\u0003WYJ!a\u000e\u0017\u0003\u0015M\u001b\u0007.Z7b%\u0016\fGM\u0002\u0003:#\u0011Q$a\t\"bg\u0016$&/\u00198tC\u000e$\u0018n\u001c8C_VtGm\u0012:ba\"\u001cF/\u0019;jgRL7m]\n\u0004qQY\u0004CA\u0011=\u0013\ti$EA\bHe\u0006\u0004\bn\u0015;bi&\u001cH/[2t\u0011!I\u0003H!A!\u0002\u0013Q\u0003\u0002\u0003\u001b9\u0005\u0003\u0005\u000b\u0011B\u001b\t\u000bmAD\u0011A!\u0015\u0007\t#U\t\u0005\u0002Dq5\t\u0011\u0003C\u0003*\u0001\u0002\u0007!\u0006C\u00035\u0001\u0002\u0007Q\u0007C\u0003Hq\u0011\u0005\u0001*\u0001\tj]\u0012,\u0007pU3mK\u000e$\u0018N^5usR\u0019\u0011\nV/\u0011\u0007UQE*\u0003\u0002L-\t1q\n\u001d;j_:\u0004\"!\u0014*\u000e\u00039S!a\u0014)\u0002\u000f1|w-[2bY*\u0011\u0011kI\u0001\ba2\fgN\\3s\u0013\t\u0019fJA\u0006TK2,7\r^5wSRL\b\"B+G\u0001\u00041\u0016!\u00027bE\u0016d\u0007CA,\\\u001b\u0005A&BA\u0002Z\u0015\tQf!\u0001\u0005ge>tG/\u001a8e\u0013\ta\u0006LA\u0004MC\n,G.\u00133\t\u000by3\u0005\u0019A0\u0002\u0011A\u0014x\u000e]3sif\u0004\"a\u00161\n\u0005\u0005D&!\u0004)s_B,'\u000f^=LKfLE\rC\u0003dq\u0011\u0005A-\u0001\u0010j]\u0012,\u0007\u0010\u0015:pa\u0016\u0014H/_#ySN$8oU3mK\u000e$\u0018N^5usR\u0019\u0011*\u001a4\t\u000bU\u0013\u0007\u0019\u0001,\t\u000by\u0013\u0007\u0019A0\t\u000b!DD\u0011A5\u000239|G-Z:XSRDG*\u00192fY\u000e\u000b'\u000fZ5oC2LG/\u001f\u000b\u0003U6\u0004\"!T6\n\u00051t%aC\"be\u0012Lg.\u00197jifDQA\\4A\u0002=\fq\u0001\\1cK2LE\rE\u0002\u0016\u0015ZCQ!\u001d\u001d\u0005\u0002I\faeY1sI&t\u0017\r\\5us\nKH*\u00192fYN\fe\u000e\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004H+\u001f9f)\u0011Q7/^>\t\u000bQ\u0004\b\u0019A8\u0002\u0013\u0019\u0014x.\u001c'bE\u0016d\u0007\"\u0002<q\u0001\u00049\u0018!\u0003:fYRK\b/Z%e!\r)\"\n\u001f\t\u0003/fL!A\u001f-\u0003\u0013I+G\u000eV=qK&#\u0007\"\u0002?q\u0001\u0004y\u0017a\u0002;p\u0019\u0006\u0014W\r\u001c")
public final class TransactionBoundGraphStatistics {
    public static StatisticsCompletingGraphStatistics apply(Read read, SchemaRead schemaRead) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(read, schemaRead);
    }

    public static class BaseTransactionBoundGraphStatistics
    implements GraphStatistics {
        private final Read read;
        private final SchemaRead schemaRead;

        public Option<Selectivity> indexSelectivity(LabelId label, PropertyKeyId property) {
            None$ none$;
            try {
                double labeledNodes = this.read.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode((NameId)label));
                double indexEntrySelectivity = this.schemaRead.indexUniqueValuesSelectivity(DefaultIndexReference.general((int)NameId$.MODULE$.toKernelEncode((NameId)label), (int[])new int[]{property.id()}));
                double frequencyOfNodesWithSameValue = 1.0 / indexEntrySelectivity;
                double indexSelectivity2 = frequencyOfNodesWithSameValue / labeledNodes;
                none$ = Selectivity$.MODULE$.of(indexSelectivity2);
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Option<Selectivity> indexPropertyExistsSelectivity(LabelId label, PropertyKeyId property) {
            None$ none$;
            try {
                double labeledNodes = this.read.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode((NameId)label));
                long indexSize = this.schemaRead.indexSize(DefaultIndexReference.general((int)NameId$.MODULE$.toKernelEncode((NameId)label), (int[])new int[]{property.id()}));
                double indexSelectivity2 = (double)indexSize / labeledNodes;
                none$ = Selectivity$.MODULE$.of(indexSelectivity2);
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Cardinality nodesWithLabelCardinality(Option<LabelId> labelId) {
            return new Cardinality((double)this.read.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode(labelId)));
        }

        public Cardinality cardinalityByLabelsAndRelationshipType(Option<LabelId> fromLabel, Option<RelTypeId> relTypeId, Option<LabelId> toLabel) {
            return new Cardinality((double)this.read.countsForRelationshipWithoutTxState(NameId$.MODULE$.toKernelEncode(fromLabel), NameId$.MODULE$.toKernelEncode(relTypeId), NameId$.MODULE$.toKernelEncode(toLabel)));
        }

        public BaseTransactionBoundGraphStatistics(Read read, SchemaRead schemaRead) {
            this.read = read;
            this.schemaRead = schemaRead;
        }
    }
}

