/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.security;

import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SaltedAuthenticationInfo;
import org.apache.shiro.codec.Hex;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.neo4j.cypher.internal.security.FormatException;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.kernel.impl.security.Credential;

public class SystemGraphCredential
implements Credential {
    private final SecureHasher secureHasher;
    private final SimpleHash hashedCredentials;

    private SystemGraphCredential(SecureHasher secureHasher, SimpleHash hash) {
        this.secureHasher = secureHasher;
        this.hashedCredentials = hash;
    }

    public boolean matchesPassword(final byte[] password) {
        return this.secureHasher.getHashedCredentialsMatcherWithIterations(this.hashedCredentials.getIterations()).doCredentialsMatch(new AuthenticationToken(){

            public Object getCredentials() {
                return password;
            }

            public Object getPrincipal() {
                return null;
            }
        }, (AuthenticationInfo)new SaltedAuthenticationInfo(){

            public Object getCredentials() {
                return SystemGraphCredential.this.hashedCredentials.getBytes();
            }

            public ByteSource getCredentialsSalt() {
                return SystemGraphCredential.this.hashedCredentials.getSalt();
            }

            public PrincipalCollection getPrincipals() {
                return null;
            }
        });
    }

    public static SystemGraphCredential createCredentialForPassword(byte[] password, SecureHasher secureHasher) {
        SimpleHash hash = secureHasher.hash(password);
        return new SystemGraphCredential(secureHasher, hash);
    }

    public String serialize() {
        return SystemGraphCredential.serialize(this);
    }

    public static String serialize(SystemGraphCredential credential) {
        String algorithm = credential.hashedCredentials.getAlgorithmName();
        String iterations = Integer.toString(credential.hashedCredentials.getIterations());
        String encodedSalt = credential.hashedCredentials.getSalt().toHex();
        String encodedPassword = credential.hashedCredentials.toHex();
        return String.join((CharSequence)",", algorithm, encodedPassword, encodedSalt, iterations);
    }

    public static SystemGraphCredential deserialize(String part, SecureHasher secureHasher) throws FormatException {
        String[] split = part.split(",", -1);
        if (split.length < 3 || split.length > 4) {
            throw new FormatException("wrong number of credential fields");
        }
        String algorithm = split[0];
        byte[] decodedPassword = Hex.decode((String)split[1]);
        byte[] decodedSalt = Hex.decode((String)split[2]);
        int iterations = split.length == 4 ? Integer.parseInt(split[3]) : 1;
        SimpleHash hash = new SimpleHash(algorithm);
        hash.setBytes(decodedPassword);
        hash.setSalt(ByteSource.Util.bytes((byte[])decodedSalt));
        hash.setIterations(iterations);
        return new SystemGraphCredential(secureHasher, hash);
    }
}

