/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.time.Clock;
import java.util.List;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.ExecutionEngineQueryCacheMonitor;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.javacompat.MonitoringCacheTracer;
import org.neo4j.cypher.internal.javacompat.ResultSubscriber;
import org.neo4j.cypher.internal.javacompat.SystemExecutionEngine;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.tracing.TimingCompilationTracer;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.util.WrappingEntity;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;

public class ExecutionEngine
implements QueryExecutionEngine {
    protected org.neo4j.cypher.internal.ExecutionEngine cypherExecutionEngine;

    public ExecutionEngine(GraphDatabaseQueryService queryService, CaffeineCacheFactory cacheFactory, LogProvider logProvider, CompilerFactory compilerFactory) {
        this.cypherExecutionEngine = ExecutionEngine.makeExecutionEngine(queryService, cacheFactory, logProvider, new CompilerLibrary(compilerFactory, (Function0<org.neo4j.cypher.internal.ExecutionEngine>)((Function0)this::getCypherExecutionEngine)));
    }

    public ExecutionEngine(SystemExecutionEngine inner) {
        this.cypherExecutionEngine = inner.normalExecutionEngine();
    }

    protected ExecutionEngine() {
    }

    public org.neo4j.cypher.internal.ExecutionEngine getCypherExecutionEngine() {
        return this.cypherExecutionEngine;
    }

    protected static org.neo4j.cypher.internal.ExecutionEngine makeExecutionEngine(GraphDatabaseQueryService queryService, CaffeineCacheFactory cacheFactory, LogProvider logProvider, CompilerLibrary compilerLibrary) {
        DependencyResolver resolver = queryService.getDependencyResolver();
        Monitors monitors = (Monitors)resolver.resolveDependency(Monitors.class);
        MonitoringCacheTracer cacheTracer = new MonitoringCacheTracer((ExecutionEngineQueryCacheMonitor)monitors.newMonitor(ExecutionEngineQueryCacheMonitor.class, new String[0]));
        Config config = (Config)resolver.resolveDependency(Config.class);
        CypherConfiguration cypherConfiguration = CypherConfiguration.fromConfig((Config)config);
        TimingCompilationTracer tracer = new TimingCompilationTracer((TimingCompilationTracer.EventListener)monitors.newMonitor(TimingCompilationTracer.EventListener.class, new String[0]));
        return new org.neo4j.cypher.internal.ExecutionEngine(queryService, monitors, tracer, cacheTracer, cypherConfiguration, compilerLibrary, cacheFactory, logProvider, Clock.systemUTC());
    }

    public Result executeQuery(String query, MapValue parameters, TransactionalContext context, boolean prePopulate) throws QueryExecutionKernelException {
        ResultSubscriber subscriber = new ResultSubscriber(context);
        QueryExecution queryExecution = this.executeQuery(query, parameters, context, false, subscriber);
        subscriber.init(queryExecution);
        return subscriber;
    }

    public QueryExecution executeQuery(String query, MapValue parameters, TransactionalContext context, boolean prePopulate, QuerySubscriber subscriber) throws QueryExecutionKernelException {
        try {
            ExecutionEngine.checkParams(context, parameters);
            return this.cypherExecutionEngine.execute(query, parameters, context, false, prePopulate, subscriber);
        }
        catch (Neo4jException e) {
            throw new QueryExecutionKernelException((Throwable)e);
        }
    }

    public QueryExecution executeQuery(FullyParsedQuery query, MapValue parameters, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) throws QueryExecutionKernelException {
        try {
            ExecutionEngine.checkParams(context, parameters);
            return this.cypherExecutionEngine.execute(query, parameters, context, prePopulate, input, queryMonitor, subscriber);
        }
        catch (Neo4jException e) {
            throw new QueryExecutionKernelException((Throwable)e);
        }
    }

    private static void checkParams(TransactionalContext context, MapValue parameters) {
        parameters.foreach((s, n) -> {
            if (n instanceof WrappingEntity) {
                context.transaction().validateSameDB(((WrappingEntity)n).getEntity());
            }
        });
    }

    public boolean isPeriodicCommit(String query) {
        return this.cypherExecutionEngine.isPeriodicCommit(query);
    }

    public long clearQueryCaches() {
        return this.cypherExecutionEngine.clearQueryCaches();
    }

    public List<FunctionInformation> getProvidedLanguageFunctions() {
        return this.cypherExecutionEngine.getCypherFunctions();
    }
}

