/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4AAB\u0004\u0001%!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003-\u0001\u0011\u0005S\u0006C\u0003-\u0001\u0011\u0005C\nC\u0003-\u0001\u0011\u0005\u0013LA\u0011Fq\u0016\u001cW\u000f^8s\u0005\u0006\u001cX\rZ\"bM\u001a,\u0017N\\3DC\u000eDWMR1di>\u0014\u0018P\u0003\u0002\t\u0013\u0005)1-Y2iK*\u0011!bC\u0001\tS:$XM\u001d8bY*\u0011A\"D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00059y\u0011!\u00028f_RR'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035mi\u0011aB\u0005\u00039\u001d\u0011AcQ1gM\u0016Lg.Z\"bG\",g)Y2u_JL\u0018\u0001C3yK\u000e,Ho\u001c:\u0011\u0005}1S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013AC2p]\u000e,(O]3oi*\u00111\u0005J\u0001\u0005kRLGNC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0002#\u0001C#yK\u000e,Ho\u001c:\u0002\rqJg.\u001b;?)\tQ3\u0006\u0005\u0002\u001b\u0001!)QD\u0001a\u0001=\u0005Y1M]3bi\u0016\u001c\u0015m\u00195f+\rqc(\u0012\u000b\u0003_\u001d\u0003B\u0001\r\u001e=\t6\t\u0011G\u0003\u0002\te)\u00111\u0007N\u0001\tG\u00064g-Z5oK*\u0011QGN\u0001\tE\u0016tW.\u00198fg*\u0011q\u0007O\u0001\u0007O&$\b.\u001e2\u000b\u0003e\n1aY8n\u0013\tY\u0014GA\u0003DC\u000eDW\r\u0005\u0002>}1\u0001A!B \u0004\u0005\u0004\u0001%!A&\u0012\u0005\u0005\u001b\u0002C\u0001\u000bC\u0013\t\u0019UCA\u0004O_RD\u0017N\\4\u0011\u0005u*E!\u0002$\u0004\u0005\u0004\u0001%!\u0001,\t\u000b!\u001b\u0001\u0019A%\u0002\tML'0\u001a\t\u0003))K!aS\u000b\u0003\u0007%sG/F\u0002N!J#2AT*U!\u0011\u0001$hT)\u0011\u0005u\u0002F!B \u0005\u0005\u0004\u0001\u0005CA\u001fS\t\u00151EA1\u0001A\u0011\u0015AE\u00011\u0001J\u0011\u0015)F\u00011\u0001W\u00039!H\u000f\\!gi\u0016\u0014\u0018iY2fgN\u0004\"\u0001F,\n\u0005a+\"\u0001\u0002'p]\u001e,2AW/`)\u0011Y\u0006-Z4\u0011\tARDL\u0018\t\u0003{u#QaP\u0003C\u0002\u0001\u0003\"!P0\u0005\u000b\u0019+!\u0019\u0001!\t\u000b\u0005,\u0001\u0019\u00012\u0002\rQL7m[3s!\t\u00014-\u0003\u0002ec\t1A+[2lKJDQAZ\u0003A\u0002Y\u000bQ\u0002\u001e;m\u0003\u001a$XM],sSR,\u0007\"\u0002%\u0006\u0001\u0004I\u0005")
public class ExecutorBasedCaffeineCacheFactory
implements CaffeineCacheFactory {
    private final Executor executor;

    @Override
    public <K, V> Cache<K, V> createCache(int size) {
        return Caffeine.newBuilder().executor(this.executor).maximumSize((long)size).build();
    }

    @Override
    public <K, V> Cache<K, V> createCache(int size, long ttlAfterAccess) {
        return Caffeine.newBuilder().executor(this.executor).maximumSize((long)size).expireAfterAccess(ttlAfterAccess, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public <K, V> Cache<K, V> createCache(Ticker ticker, long ttlAfterWrite, int size) {
        return Caffeine.newBuilder().executor(this.executor).maximumSize((long)size).ticker(ticker).expireAfterWrite(ttlAfterWrite, TimeUnit.MILLISECONDS).build();
    }

    public ExecutorBasedCaffeineCacheFactory(Executor executor) {
        this.executor = executor;
    }
}

