/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.neo4j.internal.collector.RecentBuffer;

public class ConcurrentLinkedQueueRecentBuffer<T>
implements RecentBuffer<T> {
    private final ConcurrentLinkedQueue<T> queue;
    private final int maxSize;
    private final AtomicInteger size;

    public ConcurrentLinkedQueueRecentBuffer(int bitSize) {
        this.maxSize = 1 << bitSize;
        this.queue = new ConcurrentLinkedQueue();
        this.size = new AtomicInteger(0);
    }

    @Override
    public void produce(T t) {
        this.queue.add(t);
        int newSize = this.size.incrementAndGet();
        if (newSize > this.maxSize) {
            this.queue.poll();
            this.size.decrementAndGet();
        }
    }

    @Override
    public void clear() {
        this.queue.clear();
        this.size.set(0);
    }

    @Override
    public void foreach(Consumer<T> consumer) {
        this.queue.forEach(consumer);
    }
}

