/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.function.Supplier;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

class TruncatedQuerySnapshot {
    final NamedDatabaseId databaseId;
    final int fullQueryTextHash;
    final String queryText;
    final Supplier<ExecutionPlanDescription> queryPlanSupplier;
    final MapValue queryParameters;
    final long elapsedTimeMicros;
    final long compilationTimeMicros;
    final long startTimestampMillis;
    final long estimatedHeap;
    static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TruncatedQuerySnapshot.class) + HeapEstimator.shallowSizeOfInstance(Supplier.class);
    private static final ValueTruncater VALUE_TRUNCATER = new ValueTruncater();
    private static final int MAX_TEXT_PARAMETER_LENGTH = 100;
    private static final int MAX_PARAMETER_KEY_LENGTH = 1000;

    TruncatedQuerySnapshot(NamedDatabaseId databaseId, String fullQueryText, Supplier<ExecutionPlanDescription> queryPlanSupplier, MapValue queryParameters, long elapsedTimeMicros, long compilationTimeMicros, long startTimestampMillis, int maxQueryTextLength) {
        this.databaseId = databaseId;
        this.fullQueryTextHash = fullQueryText.hashCode();
        this.queryText = TruncatedQuerySnapshot.truncateQueryText(fullQueryText, maxQueryTextLength);
        this.queryPlanSupplier = queryPlanSupplier;
        this.queryParameters = TruncatedQuerySnapshot.truncateParameters(queryParameters);
        this.elapsedTimeMicros = elapsedTimeMicros;
        this.compilationTimeMicros = compilationTimeMicros;
        this.startTimestampMillis = startTimestampMillis;
        this.estimatedHeap = SHALLOW_SIZE + HeapEstimator.sizeOf((String)this.queryText) + this.queryParameters.estimatedHeapUsage();
    }

    private static String truncateQueryText(String queryText, int maxLength) {
        return queryText.length() > maxLength ? queryText.substring(0, maxLength) : queryText;
    }

    private static MapValue truncateParameters(MapValue parameters) {
        int size = parameters.size();
        if (size == 0) {
            return VirtualValues.EMPTY_MAP;
        }
        MapValueBuilder mapValueBuilder = new MapValueBuilder(size);
        parameters.foreach((key, value) -> mapValueBuilder.add(key.length() <= 1000 ? key : key.substring(0, 1000), (AnyValue)value.map((ValueMapper)VALUE_TRUNCATER)));
        return mapValueBuilder.build();
    }

    static class ValueTruncater
    implements ValueMapper<AnyValue> {
        ValueTruncater() {
        }

        public AnyValue mapPath(PathValue value) {
            return Values.stringValue((String)("\u00a7PATH[" + value.size() + "]"));
        }

        public AnyValue mapNode(VirtualNodeValue value) {
            if (value instanceof NodeValue) {
                return VirtualValues.node((long)value.id());
            }
            return value;
        }

        public AnyValue mapRelationship(VirtualRelationshipValue value) {
            if (value instanceof RelationshipValue) {
                return VirtualValues.relationship((long)value.id());
            }
            return value;
        }

        public AnyValue mapMap(MapValue map) {
            return Values.stringValue((String)("\u00a7MAP[" + map.size() + "]"));
        }

        public AnyValue mapNoValue() {
            return Values.NO_VALUE;
        }

        public AnyValue mapSequence(SequenceValue value) {
            return Values.stringValue((String)("\u00a7LIST[" + value.length() + "]"));
        }

        public AnyValue mapText(TextValue value) {
            if (value.length() > 100) {
                return Values.stringValue((String)value.stringValue().substring(0, 100));
            }
            return value;
        }

        public AnyValue mapBoolean(BooleanValue value) {
            return value;
        }

        public AnyValue mapNumber(NumberValue value) {
            return value;
        }

        public AnyValue mapDateTime(DateTimeValue value) {
            return value;
        }

        public AnyValue mapLocalDateTime(LocalDateTimeValue value) {
            return value;
        }

        public AnyValue mapDate(DateValue value) {
            return value;
        }

        public AnyValue mapTime(TimeValue value) {
            return value;
        }

        public AnyValue mapLocalTime(LocalTimeValue value) {
            return value;
        }

        public AnyValue mapDuration(DurationValue value) {
            return value;
        }

        public AnyValue mapPoint(PointValue value) {
            return value;
        }
    }
}

