/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.dbms.DumpCommand;
import org.neo4j.commandline.dbms.OfflineBackupCommandSection;
import org.neo4j.dbms.archive.Dumper;

public class DumpCommandProvider
extends AdminCommand.Provider {
    public DumpCommandProvider() {
        super("dump", new String[0]);
    }

    @Nonnull
    public Arguments allArguments() {
        return DumpCommand.arguments();
    }

    @Nonnull
    public String description() {
        return "Dump a database into a single-file archive. The archive can be used by the load command. <destination-path> can be a file or directory (in which case a file called <database>.dump will be created). It is not possible to dump a database that is mounted in a running Neo4j server.";
    }

    @Nonnull
    public String summary() {
        return "Dump a database into a single-file archive.";
    }

    @Nonnull
    public AdminCommandSection commandSection() {
        return OfflineBackupCommandSection.instance();
    }

    @Nonnull
    public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        return new DumpCommand(homeDir, configDir, new Dumper(outsideWorld.errorStream()), outsideWorld.errorStream());
    }
}

