/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import com.github.luben.zstd.util.Native;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.IOUtils;

public enum CompressionFormat {
    GZIP{

        @Override
        public OutputStream compress(OutputStream stream) throws IOException {
            return new GZIPOutputStream(stream);
        }

        @Override
        public InputStream decompress(InputStream stream) throws IOException {
            return new GZIPInputStream(stream);
        }
    }
    ,
    ZSTD{
        private final byte[] HEADER = new byte[]{122, 115, 116, 100};

        @Override
        public OutputStream compress(OutputStream stream) throws IOException {
            ZstdOutputStream zstdout = new ZstdOutputStream(stream);
            zstdout.setChecksum(true);
            if (Runtime.getRuntime().availableProcessors() > 2) {
                zstdout.setWorkers(Runtime.getRuntime().availableProcessors());
            }
            zstdout.write(this.HEADER);
            return zstdout;
        }

        @Override
        public InputStream decompress(InputStream stream) throws IOException {
            ZstdInputStream zstdin = new ZstdInputStream(stream);
            byte[] header = new byte[this.HEADER.length];
            if (zstdin.read(header) != this.HEADER.length || !Arrays.equals(header, this.HEADER)) {
                throw new IOException("Not in ZSTD format");
            }
            return zstdin;
        }
    };


    public abstract OutputStream compress(OutputStream var1) throws IOException;

    public abstract InputStream decompress(InputStream var1) throws IOException;

    public boolean isFormat(InputStream stream) {
        return this == ZSTD && stream instanceof ZstdInputStream || this == GZIP && stream instanceof GZIPInputStream;
    }

    public static OutputStream compress(ThrowingSupplier<OutputStream, IOException> streamSupplier) throws IOException {
        return CompressionFormat.compress(streamSupplier, CompressionFormat.selectCompressionFormat());
    }

    public static OutputStream compress(ThrowingSupplier<OutputStream, IOException> streamSupplier, CompressionFormat format) throws IOException {
        OutputStream sink = (OutputStream)streamSupplier.get();
        try {
            return new BufferedOutputStream(format.compress(sink));
        }
        catch (IOException ioe) {
            IOUtils.closeAllSilently((AutoCloseable[])new OutputStream[]{sink});
            throw ioe;
        }
    }

    public static InputStream decompress(ThrowingSupplier<InputStream, IOException> streamSupplier) throws IOException {
        if (CompressionFormat.selectCompressionFormat().equals((Object)ZSTD)) {
            try {
                return CompressionFormat.decompress(streamSupplier, ZSTD);
            }
            catch (IOException zstdIOe) {
                try {
                    return CompressionFormat.decompress(streamSupplier, GZIP);
                }
                catch (IOException gzipIOe) {
                    throw (IOException)Exceptions.chain((Throwable)zstdIOe, (Throwable)gzipIOe);
                }
            }
        }
        return CompressionFormat.decompress(streamSupplier, GZIP);
    }

    public static InputStream decompress(ThrowingSupplier<InputStream, IOException> streamSupplier, CompressionFormat format) throws IOException {
        InputStream source = (InputStream)streamSupplier.get();
        try {
            return format.decompress(source);
        }
        catch (IOException ioe) {
            IOUtils.closeAllSilently((AutoCloseable[])new InputStream[]{source});
            throw ioe;
        }
    }

    public static CompressionFormat selectCompressionFormat() {
        return CompressionFormat.selectCompressionFormat(null);
    }

    public static CompressionFormat selectCompressionFormat(PrintStream output) {
        block3: {
            try {
                Native.load();
                if (Native.isLoaded()) {
                    return ZSTD;
                }
            }
            catch (Throwable t) {
                if (output == null) break block3;
                output.println("Failed to load " + ZSTD.name() + ": " + t.getMessage());
                output.println("Fallback to " + GZIP.name());
            }
        }
        return GZIP;
    }
}

