/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.internal.NativeIndexFileFilter;
import org.neo4j.storageengine.api.StorageEngineFactory;

public final class MemoryRecommendation {
    private static final Bracket[] datapoints = new Bracket[]{new Bracket(0.01, 0.007, 0.002), new Bracket(1.0, 0.65, 0.3), new Bracket(2.0, 1.0, 0.5), new Bracket(4.0, 1.5, 2.0), new Bracket(6.0, 2.0, 3.0), new Bracket(8.0, 2.5, 3.5), new Bracket(10.0, 3.0, 4.0), new Bracket(12.0, 3.5, 4.5), new Bracket(16.0, 4.0, 5.0), new Bracket(24.0, 6.0, 8.0), new Bracket(32.0, 8.0, 12.0), new Bracket(64.0, 12.0, 24.0), new Bracket(128.0, 16.0, 31.0), new Bracket(256.0, 20.0, 31.0), new Bracket(512.0, 24.0, 31.0), new Bracket(1024.0, 30.0, 31.0)};

    private MemoryRecommendation() {
    }

    public static String bytesToString(double bytes) {
        double gibi1 = ByteUnit.ONE_GIBI_BYTE;
        double mebi1 = ByteUnit.ONE_MEBI_BYTE;
        double mebi100 = 100.0 * mebi1;
        double kibi1 = ByteUnit.ONE_KIBI_BYTE;
        double kibi100 = 100.0 * kibi1;
        if (bytes >= gibi1) {
            double gibibytes = bytes / gibi1;
            double modMebi = bytes % gibi1;
            if (modMebi >= mebi100) {
                return String.format(Locale.ROOT, "%dm", Math.round(bytes / mebi100) * 100L);
            }
            return String.format(Locale.ROOT, "%.0fg", gibibytes);
        }
        if (bytes >= mebi1) {
            double mebibytes = bytes / mebi1;
            double modKibi = bytes % mebi1;
            if (modKibi >= kibi100) {
                return String.format(Locale.ROOT, "%dk", Math.round(bytes / kibi100) * 100L);
            }
            return String.format(Locale.ROOT, "%.0fm", mebibytes);
        }
        double kibiBytes = bytes / kibi1;
        return String.format(Locale.ROOT, "%dk", (long)Math.ceil(kibiBytes));
    }

    public static long recommendOsMemory(long totalMemoryBytes) {
        Brackets brackets = MemoryRecommendation.findMemoryBrackets(totalMemoryBytes);
        return brackets.recommend(Bracket::osMemory);
    }

    public static long recommendHeapMemory(long totalMemoryBytes) {
        Brackets brackets = MemoryRecommendation.findMemoryBrackets(totalMemoryBytes);
        return brackets.recommend(Bracket::heapMemory);
    }

    public static long recommendTxStateMemory(Config config, long heapMemoryBytes) {
        switch ((GraphDatabaseSettings.TransactionStateMemoryAllocation)config.get(GraphDatabaseSettings.tx_state_memory_allocation)) {
            case OFF_HEAP: {
                long recommendation = heapMemoryBytes / 4L;
                recommendation = Math.max(ByteUnit.mebiBytes((long)128L), recommendation);
                recommendation = Math.min(ByteUnit.gibiBytes((long)8L), recommendation);
                return recommendation;
            }
            case ON_HEAP: {
                return 0L;
            }
        }
        throw new IllegalArgumentException("Unsupported type of memory allocation.");
    }

    public static long recommendPageCacheMemory(long totalMemoryBytes, long offHeapMemory) {
        long osMemory = MemoryRecommendation.recommendOsMemory(totalMemoryBytes);
        long heapMemory = MemoryRecommendation.recommendHeapMemory(totalMemoryBytes);
        long recommendation = totalMemoryBytes - osMemory - heapMemory - offHeapMemory;
        recommendation = Math.max(ByteUnit.mebiBytes((long)8L), recommendation);
        recommendation = Math.min(ByteUnit.tebiBytes((long)16L), recommendation);
        return recommendation;
    }

    public static long recommendPageCacheMemory(long totalMemoryBytes) {
        return MemoryRecommendation.recommendPageCacheMemory(totalMemoryBytes, 0L);
    }

    private static Brackets findMemoryBrackets(long totalMemoryBytes) {
        double totalMemoryGB = (double)totalMemoryBytes / (double)ByteUnit.gibiBytes((long)1L);
        Bracket lower = null;
        Bracket upper = null;
        for (int i = 1; i < datapoints.length; ++i) {
            if (!(totalMemoryGB < MemoryRecommendation.datapoints[i].totalMemory)) continue;
            lower = datapoints[i - 1];
            upper = datapoints[i];
            break;
        }
        if (lower == null) {
            lower = datapoints[datapoints.length - 1];
            upper = datapoints[datapoints.length - 1];
        }
        return new Brackets(totalMemoryGB, lower, upper);
    }

    public static DirectoryStream.Filter<Path> getNativeIndexFileFilter(Path storeDir, boolean inverse, FileSystemAbstraction fs) {
        NativeIndexFileFilter nativeIndexFilter = new NativeIndexFileFilter(storeDir);
        return arg_0 -> MemoryRecommendation.lambda$getNativeIndexFileFilter$0(fs, inverse, (Predicate)nativeIndexFilter, arg_0);
    }

    public static long sumStoreFiles(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem) {
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.defaultStorageEngine();
        try {
            long total = 0L;
            for (Path path : storageEngineFactory.listStorageFiles(fileSystem, databaseLayout)) {
                total += fileSystem.getFileSize(path);
            }
            total += MemoryRecommendation.sizeOfFileIfExists(databaseLayout.labelScanStore(), fileSystem);
            return total += MemoryRecommendation.sizeOfFileIfExists(databaseLayout.relationshipTypeScanStore(), fileSystem);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    private static long sizeOfFileIfExists(Path file, FileSystemAbstraction fileSystem) throws IOException {
        return fileSystem.fileExists(file) ? fileSystem.getFileSize(file) : 0L;
    }

    public static long sumIndexFiles(Path file, DirectoryStream.Filter<Path> filter, FileSystemAbstraction fs) throws IOException {
        long total = 0L;
        if (fs.isDirectory(file)) {
            Path[] children = fs.listFiles(file, filter);
            if (children != null) {
                for (Path child : children) {
                    total += MemoryRecommendation.sumIndexFiles(child, filter, fs);
                }
            }
        } else if (fs.fileExists(file)) {
            total += fs.getFileSize(file);
        }
        return total;
    }

    private static /* synthetic */ boolean lambda$getNativeIndexFileFilter$0(FileSystemAbstraction fs, boolean inverse, Predicate nativeIndexFilter, Path file) throws IOException {
        if (fs.isDirectory(file)) {
            return true;
        }
        if (file.getFileName().toString().equals("failure-message")) {
            return false;
        }
        return inverse != nativeIndexFilter.test(file);
    }

    private static final class Brackets {
        private final double totalMemoryGB;
        private final Bracket lower;
        private final Bracket upper;

        private Brackets(double totalMemoryGB, Bracket lower, Bracket upper) {
            this.totalMemoryGB = totalMemoryGB;
            this.lower = lower;
            this.upper = upper;
        }

        private double differenceFactor() {
            if (this.lower == this.upper) {
                return 0.0;
            }
            return (this.totalMemoryGB - this.lower.totalMemory) / (this.upper.totalMemory - this.lower.totalMemory);
        }

        private long recommend(ToDoubleFunction<Bracket> parameter) {
            double factor = this.differenceFactor();
            double lowerParam = parameter.applyAsDouble(this.lower);
            double upperParam = parameter.applyAsDouble(this.upper);
            double diff = upperParam - lowerParam;
            double recommend = lowerParam + diff * factor;
            return ByteUnit.mebiBytes((long)((long)(recommend * 1024.0)));
        }
    }

    private static final class Bracket {
        private final double totalMemory;
        private final double osMemory;
        private final double heapMemory;

        private Bracket(double totalMemory, double osMemory, double heapMemory) {
            this.totalMemory = totalMemory;
            this.osMemory = osMemory;
            this.heapMemory = heapMemory;
        }

        double osMemory() {
            return this.osMemory;
        }

        double heapMemory() {
            return this.heapMemory;
        }
    }
}

