/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.enterprise.api.security;

import java.util.Collections;
import java.util.Set;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.SecurityContext;

public interface EnterpriseSecurityContext
extends SecurityContext {
    public static final EnterpriseSecurityContext AUTH_DISABLED = new AuthDisabled((AccessMode)AccessMode.Static.FULL);

    public EnterpriseSecurityContext freeze();

    public EnterpriseSecurityContext withMode(AccessMode var1);

    public Set<String> roles();

    public static final class Frozen
    implements EnterpriseSecurityContext {
        private final AuthSubject subject;
        private final AccessMode mode;
        private final Set<String> roles;
        private final boolean isAdmin;

        public Frozen(AuthSubject subject, AccessMode mode, Set<String> roles, boolean isAdmin) {
            this.subject = subject;
            this.mode = mode;
            this.roles = roles;
            this.isAdmin = isAdmin;
        }

        public boolean isAdmin() {
            return this.isAdmin;
        }

        public AccessMode mode() {
            return this.mode;
        }

        public AuthSubject subject() {
            return this.subject;
        }

        @Override
        public EnterpriseSecurityContext freeze() {
            return this;
        }

        @Override
        public EnterpriseSecurityContext withMode(AccessMode mode) {
            return new Frozen(this.subject, mode, this.roles, this.isAdmin);
        }

        @Override
        public Set<String> roles() {
            return this.roles;
        }
    }

    public static final class AuthDisabled
    implements EnterpriseSecurityContext {
        private final AccessMode mode;

        private AuthDisabled(AccessMode mode) {
            this.mode = mode;
        }

        @Override
        public EnterpriseSecurityContext freeze() {
            return this;
        }

        @Override
        public EnterpriseSecurityContext withMode(AccessMode mode) {
            return new AuthDisabled(mode);
        }

        @Override
        public Set<String> roles() {
            return Collections.emptySet();
        }

        public AuthSubject subject() {
            return AuthSubject.AUTH_DISABLED;
        }

        public AccessMode mode() {
            return this.mode;
        }

        public String description() {
            return "AUTH_DISABLED with " + this.mode().name();
        }

        public String toString() {
            return this.defaultString("enterprise-auth-disabled");
        }

        public boolean isAdmin() {
            return true;
        }
    }
}

