/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise;

import java.util.Iterator;
import java.util.function.BiPredicate;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.NodePropertyExistenceException;
import org.neo4j.kernel.api.exceptions.schema.RelationshipPropertyExistenceException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.enterprise.PropertyExistenceEnforcer;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class EnterpriseConstraintSemantics
extends StandardConstraintSemantics {
    protected ConstraintDescriptor readNonStandardConstraint(ConstraintRule rule, String errorMessage) {
        if (!rule.getConstraintDescriptor().enforcesPropertyExistence()) {
            throw new IllegalStateException("Unsupported constraint type: " + rule);
        }
        return rule.getConstraintDescriptor();
    }

    public ConstraintRule createNodeKeyConstraintRule(long ruleId, NodeKeyConstraintDescriptor descriptor, long indexId) {
        return ConstraintRule.constraintRule((long)ruleId, (IndexBackedConstraintDescriptor)descriptor, (long)indexId);
    }

    public ConstraintRule createExistenceConstraint(long ruleId, ConstraintDescriptor descriptor) {
        return ConstraintRule.constraintRule((long)ruleId, (ConstraintDescriptor)descriptor);
    }

    public void validateNodePropertyExistenceConstraint(Iterator<Cursor<NodeItem>> allNodes, LabelSchemaDescriptor descriptor, BiPredicate<NodeItem, Integer> hasPropertyCheck) throws CreateConstraintFailureException {
        while (allNodes.hasNext()) {
            Cursor<NodeItem> cursor = allNodes.next();
            Throwable throwable = null;
            try {
                NodeItem node = (NodeItem)cursor.get();
                for (int propertyKey : descriptor.getPropertyIds()) {
                    this.validateNodePropertyExistenceConstraint(node, propertyKey, descriptor, hasPropertyCheck);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor == null) continue;
                if (throwable != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                cursor.close();
            }
        }
    }

    public void validateNodeKeyConstraint(Iterator<Cursor<NodeItem>> allNodes, LabelSchemaDescriptor descriptor, BiPredicate<NodeItem, Integer> hasPropertyCheck) throws CreateConstraintFailureException {
        this.validateNodePropertyExistenceConstraint(allNodes, descriptor, hasPropertyCheck);
    }

    private void validateNodePropertyExistenceConstraint(NodeItem node, int propertyKey, LabelSchemaDescriptor descriptor, BiPredicate<NodeItem, Integer> hasPropertyCheck) throws CreateConstraintFailureException {
        if (!hasPropertyCheck.test(node, propertyKey)) {
            throw this.createConstraintFailure((ConstraintValidationException)new NodePropertyExistenceException(descriptor, ConstraintValidationException.Phase.VERIFICATION, node.id()));
        }
    }

    public void validateRelationshipPropertyExistenceConstraint(Cursor<RelationshipItem> allRelationships, RelationTypeSchemaDescriptor descriptor, BiPredicate<RelationshipItem, Integer> hasPropertyCheck) throws CreateConstraintFailureException {
        while (allRelationships.next()) {
            RelationshipItem relationship = (RelationshipItem)allRelationships.get();
            for (int propertyId : descriptor.getPropertyIds()) {
                if (relationship.type() != descriptor.getRelTypeId() || hasPropertyCheck.test(relationship, propertyId)) continue;
                throw this.createConstraintFailure((ConstraintValidationException)new RelationshipPropertyExistenceException(descriptor, ConstraintValidationException.Phase.VERIFICATION, relationship.id()));
            }
        }
    }

    private CreateConstraintFailureException createConstraintFailure(ConstraintValidationException it) {
        return new CreateConstraintFailureException(it.constraint(), (Throwable)it);
    }

    public TxStateVisitor decorateTxStateVisitor(StoreReadLayer storeLayer, ReadableTransactionState txState, TxStateVisitor visitor) {
        if (!txState.hasDataChanges()) {
            return visitor;
        }
        return PropertyExistenceEnforcer.getOrCreatePropertyExistenceEnforcerFrom(storeLayer).decorate(visitor, txState, storeLayer);
    }
}

