/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;

public enum Reference {
    BYTE_3(3, 0, 1),
    BYTE_4(4, 2, 2),
    BYTE_5(5, 6, 3),
    BYTE_6(6, 14, 4),
    BYTE_7(7, 30, 5),
    BYTE_8(8, 31, 5);

    private static final Reference[] ENCODINGS;
    static final int MAX_BITS = 58;
    private final int numberOfBytes;
    private final short highHeader;
    private final int headerShift;
    private final long valueOverflowMask;

    private Reference(int numberOfBytes, byte header, int headerBits) {
        this.numberOfBytes = numberOfBytes;
        this.headerShift = 8 - headerBits;
        this.highHeader = (short)((byte)(header << this.headerShift) & 0xFF);
        this.valueOverflowMask = this.valueMask(numberOfBytes, this.headerShift - 1) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private long valueMask(int numberOfBytes, int headerShift) {
        long mask = (1L << headerShift) - 1L;
        for (int i = 0; i < numberOfBytes - 1; ++i) {
            mask <<= 8;
            mask |= 0xFFL;
        }
        return mask;
    }

    private boolean canEncode(long absoluteReference) {
        return (absoluteReference & this.valueOverflowMask) == 0L;
    }

    private void encode(long absoluteReference, boolean positive, PageCursor source) throws IOException {
        int shift = this.numberOfBytes - 1 << 3;
        byte signBit = (byte)((positive ? 0 : 1) << this.headerShift - 1);
        source.putByte((byte)(this.highHeader | signBit | (byte)(absoluteReference >>> shift)));
        do {
            source.putByte((byte)(absoluteReference >>> (shift -= 8)));
        } while (shift > 0);
    }

    private int maxBitsSupported() {
        return 64 - Long.numberOfLeadingZeros(this.valueOverflowMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void encode(long reference, PageCursor target) throws IOException {
        boolean positive = reference >= 0L;
        long absoluteReference = positive ? reference : reference ^ 0xFFFFFFFFFFFFFFFFL;
        for (Reference encoding : ENCODINGS) {
            if (!encoding.canEncode(absoluteReference)) continue;
            encoding.encode(absoluteReference, positive, target);
            return;
        }
        throw Reference.unsupportedOperationDueToTooBigReference(reference);
    }

    private static UnsupportedOperationException unsupportedOperationDueToTooBigReference(long reference) {
        return new UnsupportedOperationException(String.format("Reference %d uses too many bits to be encoded by current compression scheme, max %d bits allowed", reference, Reference.maxBits()));
    }

    public static int length(long reference) {
        boolean positive = reference >= 0L;
        long absoluteReference = positive ? reference : reference ^ 0xFFFFFFFFFFFFFFFFL;
        for (Reference encoding : ENCODINGS) {
            if (!encoding.canEncode(absoluteReference)) continue;
            return encoding.numberOfBytes;
        }
        throw Reference.unsupportedOperationDueToTooBigReference(reference);
    }

    private static int maxBits() {
        int max = 0;
        for (Reference encoding : ENCODINGS) {
            max = Math.max(max, encoding.maxBitsSupported());
        }
        return max;
    }

    public static long decode(PageCursor source) {
        int sizeMarks;
        int header = source.getByte() & 0xFF;
        int signShift = 8 - sizeMarks - ((sizeMarks = Integer.numberOfLeadingZeros(~(header & 0xF8) & 0xFF) - 24) == 5 ? 1 : 2);
        long signComponent = ~(header >>> signShift & 1) + 1;
        long register = (header & (1 << signShift) - 1) << 16;
        register += (long)(((source.getByte() & 0xFF) << 8) + (source.getByte() & 0xFF));
        while (sizeMarks > 0) {
            register <<= 8;
            register += (long)(source.getByte() & 0xFF);
            --sizeMarks;
        }
        return signComponent ^ register;
    }

    public static long toRelative(long reference, long basisReference) {
        return Math.subtractExact(reference, basisReference);
    }

    public static long toAbsolute(long relativeReference, long basisReference) {
        return Math.addExact(relativeReference, basisReference);
    }

    static {
        ENCODINGS = Reference.values();
    }
}

