/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit.v300;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.highlimit.v300.BaseHighLimitRecordFormatV3_0_0;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class NodeRecordFormatV3_0_0
extends BaseHighLimitRecordFormatV3_0_0<NodeRecord> {
    public static final int RECORD_SIZE = 16;
    private static final long NULL_LABELS = Record.NO_LABELS_FIELD.intValue();
    private static final int DENSE_NODE_BIT = 8;
    private static final int HAS_RELATIONSHIP_BIT = 16;
    private static final int HAS_PROPERTY_BIT = 32;
    private static final int HAS_LABELS_BIT = 64;

    public NodeRecordFormatV3_0_0() {
        this(16);
    }

    NodeRecordFormatV3_0_0(int recordSize) {
        super(NodeRecordFormatV3_0_0.fixedRecordSize((int)recordSize), 0);
    }

    public NodeRecord newRecord() {
        return new NodeRecord(-1L);
    }

    @Override
    protected void doReadInternal(NodeRecord record, PageCursor cursor, int recordSize, long headerByte, boolean inUse) {
        boolean dense = NodeRecordFormatV3_0_0.has((long)headerByte, (int)8);
        long nextRel = NodeRecordFormatV3_0_0.decodeCompressedReference(cursor, headerByte, 16, NULL);
        long nextProp = NodeRecordFormatV3_0_0.decodeCompressedReference(cursor, headerByte, 32, NULL);
        long labelField = NodeRecordFormatV3_0_0.decodeCompressedReference(cursor, headerByte, 64, NULL_LABELS);
        record.initialize(inUse, nextProp, dense, nextRel, labelField);
    }

    @Override
    public int requiredDataLength(NodeRecord record) {
        return NodeRecordFormatV3_0_0.length(record.getNextRel(), NULL) + NodeRecordFormatV3_0_0.length(record.getNextProp(), NULL) + NodeRecordFormatV3_0_0.length(record.getLabelField(), NULL_LABELS);
    }

    @Override
    protected byte headerBits(NodeRecord record) {
        byte header = 0;
        header = NodeRecordFormatV3_0_0.set((byte)header, (int)8, (boolean)record.isDense());
        header = NodeRecordFormatV3_0_0.set(header, 16, record.getNextRel(), NULL);
        header = NodeRecordFormatV3_0_0.set(header, 32, record.getNextProp(), NULL);
        header = NodeRecordFormatV3_0_0.set(header, 64, record.getLabelField(), NULL_LABELS);
        return header;
    }

    @Override
    protected void doWriteInternal(NodeRecord record, PageCursor cursor) throws IOException {
        NodeRecordFormatV3_0_0.encode(cursor, record.getNextRel(), NULL);
        NodeRecordFormatV3_0_0.encode(cursor, record.getNextProp(), NULL);
        NodeRecordFormatV3_0_0.encode(cursor, record.getLabelField(), NULL_LABELS);
    }
}

