/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit.v300;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.highlimit.v300.BaseHighLimitRecordFormatV3_0_0;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class RelationshipGroupRecordFormatV3_0_0
extends BaseHighLimitRecordFormatV3_0_0<RelationshipGroupRecord> {
    public static final int RECORD_SIZE = 32;
    private static final int HAS_OUTGOING_BIT = 8;
    private static final int HAS_INCOMING_BIT = 16;
    private static final int HAS_LOOP_BIT = 32;
    private static final int HAS_NEXT_BIT = 64;

    public RelationshipGroupRecordFormatV3_0_0() {
        this(32);
    }

    RelationshipGroupRecordFormatV3_0_0(int recordSize) {
        super(RelationshipGroupRecordFormatV3_0_0.fixedRecordSize((int)recordSize), 0);
    }

    public RelationshipGroupRecord newRecord() {
        return new RelationshipGroupRecord(-1L);
    }

    @Override
    protected void doReadInternal(RelationshipGroupRecord record, PageCursor cursor, int recordSize, long headerByte, boolean inUse) {
        record.initialize(inUse, cursor.getShort() & 0xFFFF, RelationshipGroupRecordFormatV3_0_0.decodeCompressedReference(cursor, headerByte, 8, NULL), RelationshipGroupRecordFormatV3_0_0.decodeCompressedReference(cursor, headerByte, 16, NULL), RelationshipGroupRecordFormatV3_0_0.decodeCompressedReference(cursor, headerByte, 32, NULL), RelationshipGroupRecordFormatV3_0_0.decodeCompressedReference(cursor), RelationshipGroupRecordFormatV3_0_0.decodeCompressedReference(cursor, headerByte, 64, NULL));
    }

    @Override
    protected byte headerBits(RelationshipGroupRecord record) {
        byte header = 0;
        header = RelationshipGroupRecordFormatV3_0_0.set(header, 8, record.getFirstOut(), NULL);
        header = RelationshipGroupRecordFormatV3_0_0.set(header, 16, record.getFirstIn(), NULL);
        header = RelationshipGroupRecordFormatV3_0_0.set(header, 32, record.getFirstLoop(), NULL);
        header = RelationshipGroupRecordFormatV3_0_0.set(header, 64, record.getNext(), NULL);
        return header;
    }

    @Override
    protected int requiredDataLength(RelationshipGroupRecord record) {
        return 2 + RelationshipGroupRecordFormatV3_0_0.length(record.getFirstOut(), NULL) + RelationshipGroupRecordFormatV3_0_0.length(record.getFirstIn(), NULL) + RelationshipGroupRecordFormatV3_0_0.length(record.getFirstLoop(), NULL) + RelationshipGroupRecordFormatV3_0_0.length(record.getOwningNode()) + RelationshipGroupRecordFormatV3_0_0.length(record.getNext(), NULL);
    }

    @Override
    protected void doWriteInternal(RelationshipGroupRecord record, PageCursor cursor) throws IOException {
        cursor.putShort((short)record.getType());
        RelationshipGroupRecordFormatV3_0_0.encode(cursor, record.getFirstOut(), NULL);
        RelationshipGroupRecordFormatV3_0_0.encode(cursor, record.getFirstIn(), NULL);
        RelationshipGroupRecordFormatV3_0_0.encode(cursor, record.getFirstLoop(), NULL);
        RelationshipGroupRecordFormatV3_0_0.encode(cursor, record.getOwningNode());
        RelationshipGroupRecordFormatV3_0_0.encode(cursor, record.getNext(), NULL);
    }
}

