/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit.v300;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.highlimit.Reference;
import org.neo4j.kernel.impl.store.format.highlimit.v300.BaseHighLimitRecordFormatV3_0_0;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class RelationshipRecordFormatV3_0_0
extends BaseHighLimitRecordFormatV3_0_0<RelationshipRecord> {
    public static final int RECORD_SIZE = 32;
    private static final int FIRST_IN_FIRST_CHAIN_BIT = 8;
    private static final int FIRST_IN_SECOND_CHAIN_BIT = 16;
    private static final int HAS_FIRST_CHAIN_NEXT_BIT = 32;
    private static final int HAS_SECOND_CHAIN_NEXT_BIT = 64;
    private static final int HAS_PROPERTY_BIT = 128;

    public RelationshipRecordFormatV3_0_0() {
        this(32);
    }

    RelationshipRecordFormatV3_0_0(int recordSize) {
        super(RelationshipRecordFormatV3_0_0.fixedRecordSize((int)recordSize), 0);
    }

    public RelationshipRecord newRecord() {
        return new RelationshipRecord(-1L);
    }

    @Override
    protected void doReadInternal(RelationshipRecord record, PageCursor cursor, int recordSize, long headerByte, boolean inUse) {
        int type = cursor.getShort() & 0xFFFF;
        long recordId = record.getId();
        record.initialize(inUse, RelationshipRecordFormatV3_0_0.decodeCompressedReference(cursor, headerByte, 128, NULL), RelationshipRecordFormatV3_0_0.decodeCompressedReference(cursor), RelationshipRecordFormatV3_0_0.decodeCompressedReference(cursor), type, this.decodeAbsoluteOrRelative(cursor, headerByte, 8, recordId), this.decodeAbsoluteIfPresent(cursor, headerByte, 32, recordId), this.decodeAbsoluteOrRelative(cursor, headerByte, 16, recordId), this.decodeAbsoluteIfPresent(cursor, headerByte, 64, recordId), RelationshipRecordFormatV3_0_0.has((long)headerByte, (int)8), RelationshipRecordFormatV3_0_0.has((long)headerByte, (int)16));
    }

    private long decodeAbsoluteOrRelative(PageCursor cursor, long headerByte, int firstInStartBit, long recordId) {
        return RelationshipRecordFormatV3_0_0.has((long)headerByte, (int)firstInStartBit) ? RelationshipRecordFormatV3_0_0.decodeCompressedReference(cursor) : Reference.toAbsolute(RelationshipRecordFormatV3_0_0.decodeCompressedReference(cursor), recordId);
    }

    @Override
    protected byte headerBits(RelationshipRecord record) {
        byte header = 0;
        header = RelationshipRecordFormatV3_0_0.set((byte)header, (int)8, (boolean)record.isFirstInFirstChain());
        header = RelationshipRecordFormatV3_0_0.set((byte)header, (int)16, (boolean)record.isFirstInSecondChain());
        header = RelationshipRecordFormatV3_0_0.set(header, 128, record.getNextProp(), NULL);
        header = RelationshipRecordFormatV3_0_0.set(header, 32, record.getFirstNextRel(), NULL);
        header = RelationshipRecordFormatV3_0_0.set(header, 64, record.getSecondNextRel(), NULL);
        return header;
    }

    @Override
    protected int requiredDataLength(RelationshipRecord record) {
        long recordId = record.getId();
        return 2 + RelationshipRecordFormatV3_0_0.length(record.getNextProp(), NULL) + RelationshipRecordFormatV3_0_0.length(record.getFirstNode()) + RelationshipRecordFormatV3_0_0.length(record.getSecondNode()) + RelationshipRecordFormatV3_0_0.length(this.getFirstPrevReference(record, recordId)) + this.getRelativeReferenceLength(record.getFirstNextRel(), recordId) + RelationshipRecordFormatV3_0_0.length(this.getSecondPrevReference(record, recordId)) + this.getRelativeReferenceLength(record.getSecondNextRel(), recordId);
    }

    @Override
    protected void doWriteInternal(RelationshipRecord record, PageCursor cursor) throws IOException {
        cursor.putShort((short)record.getType());
        long recordId = record.getId();
        RelationshipRecordFormatV3_0_0.encode(cursor, record.getNextProp(), NULL);
        RelationshipRecordFormatV3_0_0.encode(cursor, record.getFirstNode());
        RelationshipRecordFormatV3_0_0.encode(cursor, record.getSecondNode());
        RelationshipRecordFormatV3_0_0.encode(cursor, this.getFirstPrevReference(record, recordId));
        if (record.getFirstNextRel() != NULL) {
            RelationshipRecordFormatV3_0_0.encode(cursor, Reference.toRelative(record.getFirstNextRel(), recordId));
        }
        RelationshipRecordFormatV3_0_0.encode(cursor, this.getSecondPrevReference(record, recordId));
        if (record.getSecondNextRel() != NULL) {
            RelationshipRecordFormatV3_0_0.encode(cursor, Reference.toRelative(record.getSecondNextRel(), recordId));
        }
    }

    private long getSecondPrevReference(RelationshipRecord record, long recordId) {
        return record.isFirstInSecondChain() ? record.getSecondPrevRel() : Reference.toRelative(record.getSecondPrevRel(), recordId);
    }

    private long getFirstPrevReference(RelationshipRecord record, long recordId) {
        return record.isFirstInFirstChain() ? record.getFirstPrevRel() : Reference.toRelative(record.getFirstPrevRel(), recordId);
    }

    private int getRelativeReferenceLength(long absoluteReference, long recordId) {
        return absoluteReference != NULL ? RelationshipRecordFormatV3_0_0.length(Reference.toRelative(absoluteReference, recordId)) : 0;
    }

    private long decodeAbsoluteIfPresent(PageCursor cursor, long headerByte, int conditionBit, long recordId) {
        return RelationshipRecordFormatV3_0_0.has((long)headerByte, (int)conditionBit) ? Reference.toAbsolute(RelationshipRecordFormatV3_0_0.decodeCompressedReference(cursor), recordId) : NULL;
    }
}

