/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.enterprise.builtinprocs;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;

public class ProceduresTimeFormatHelper {
    static String formatTime(long startTime, ZoneId zoneId) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(startTime), zoneId).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    static String formatInterval(long l) {
        long hr = TimeUnit.MILLISECONDS.toHours(l);
        long min = TimeUnit.MILLISECONDS.toMinutes(l - TimeUnit.HOURS.toMillis(hr));
        long sec = TimeUnit.MILLISECONDS.toSeconds(l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min));
        long ms = l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min) - TimeUnit.SECONDS.toMillis(sec);
        return String.format("%02d:%02d:%02d.%03d", hr, min, sec, ms);
    }
}

