/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.bolt.ManagedBoltStateMachine;

public class StandardBoltConnectionTracker
implements BoltConnectionTracker {
    private Map<ManagedBoltStateMachine, String> sessions = new ConcurrentHashMap<ManagedBoltStateMachine, String>();

    public void onRegister(ManagedBoltStateMachine machine, String owner) {
        this.sessions.put(machine, owner);
    }

    public void onTerminate(ManagedBoltStateMachine machine) {
        this.sessions.remove(machine);
    }

    public Set<ManagedBoltStateMachine> getActiveConnections() {
        return new HashSet<ManagedBoltStateMachine>(this.sessions.keySet());
    }

    public Set<ManagedBoltStateMachine> getActiveConnections(String owner) {
        return this.sessions.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(owner)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

