/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring.tracing;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.logging.Log;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.FeatureToggles;

public class VerbosePageCacheTracer
extends DefaultPageCacheTracer {
    private static final boolean USE_RAW_REPORTING_UNITS = FeatureToggles.flag(VerbosePageCacheTracer.class, (String)"reportInRawUnits", (boolean)false);
    private static final int SPEED_REPORTING_TIME_THRESHOLD = FeatureToggles.getInteger(VerbosePageCacheTracer.class, (String)"speedReportingThresholdSeconds", (int)10);
    private final Log log;
    private final SystemNanoClock clock;
    private final AtomicLong flushedPages = new AtomicLong();
    private final AtomicLong flushBytesWritten = new AtomicLong();
    private final FlushEvent flushEvent = new FlushEvent(){

        public void addBytesWritten(long bytes) {
            VerbosePageCacheTracer.this.bytesWritten.add(bytes);
            VerbosePageCacheTracer.this.flushBytesWritten.getAndAdd(bytes);
        }

        public void done() {
            VerbosePageCacheTracer.this.flushes.increment();
        }

        public void done(IOException exception) {
            this.done();
        }

        public void addPagesFlushed(int pageCount) {
            VerbosePageCacheTracer.this.flushedPages.getAndAdd(pageCount);
        }
    };

    VerbosePageCacheTracer(Log log, SystemNanoClock clock) {
        this.log = log;
        this.clock = clock;
    }

    public void mappedFile(File file) {
        this.log.info(String.format("Map file: '%s'.", file.getName()));
        super.mappedFile(file);
    }

    public void unmappedFile(File file) {
        this.log.info(String.format("Unmap file: '%s'.", file.getName()));
        super.unmappedFile(file);
    }

    public MajorFlushEvent beginCacheFlush() {
        this.log.info("Start whole page cache flush.");
        return new PageCacheMajorFlushEvent(this.flushedPages.get(), this.flushBytesWritten.get(), this.clock.nanos());
    }

    public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
        String fileName = swapper.file().getName();
        this.log.info(String.format("Flushing file: '%s'.", fileName));
        return new FileFlushEvent(fileName, this.flushedPages.get(), this.flushBytesWritten.get(), this.clock.nanos());
    }

    private static String nanosToString(long nanos) {
        if (USE_RAW_REPORTING_UNITS) {
            return nanos + "ns";
        }
        return TimeUtil.nanosToString((long)nanos);
    }

    private static String flushSpeed(long bytesWrittenInTotal, long flushTimeNanos) {
        if (USE_RAW_REPORTING_UNITS) {
            return VerbosePageCacheTracer.bytesInNanoSeconds(bytesWrittenInTotal, flushTimeNanos);
        }
        long seconds = TimeUnit.NANOSECONDS.toSeconds(flushTimeNanos);
        if (seconds > 0L) {
            return VerbosePageCacheTracer.bytesToString(bytesWrittenInTotal / seconds) + "/s";
        }
        return VerbosePageCacheTracer.bytesInNanoSeconds(bytesWrittenInTotal, flushTimeNanos);
    }

    private static String bytesInNanoSeconds(long bytesWrittenInTotal, long flushTimeNanos) {
        long bytesInNanoSecond = flushTimeNanos > 0L ? bytesWrittenInTotal / flushTimeNanos : bytesWrittenInTotal;
        return bytesInNanoSecond + "bytes/ns";
    }

    private static String bytesToString(long bytes) {
        if (USE_RAW_REPORTING_UNITS) {
            return bytes + "bytes";
        }
        return ByteUnit.bytesToString((long)bytes);
    }

    private class VerboseFlushOpportunity
    implements FlushEventOpportunity {
        private final String fileName;
        private long lastReportingTime;
        private long lastReportedBytesWritten;

        VerboseFlushOpportunity(String fileName, long nanoStartTime, long bytesWrittenOnStart) {
            this.fileName = fileName;
            this.lastReportingTime = nanoStartTime;
            this.lastReportedBytesWritten = bytesWrittenOnStart;
        }

        public FlushEvent beginFlush(long filePageId, long cachePageId, PageSwapper swapper) {
            long now = VerbosePageCacheTracer.this.clock.nanos();
            long opportunityIntervalNanos = now - this.lastReportingTime;
            if (TimeUnit.NANOSECONDS.toSeconds(opportunityIntervalNanos) > (long)SPEED_REPORTING_TIME_THRESHOLD) {
                long writtenBytes = VerbosePageCacheTracer.this.flushBytesWritten.get();
                VerbosePageCacheTracer.this.log.info(String.format("'%s' flushing speed: %s.", this.fileName, VerbosePageCacheTracer.flushSpeed(writtenBytes - this.lastReportedBytesWritten, opportunityIntervalNanos)));
                this.lastReportingTime = now;
                this.lastReportedBytesWritten = writtenBytes;
            }
            return VerbosePageCacheTracer.this.flushEvent;
        }
    }

    private class PageCacheMajorFlushEvent
    implements MajorFlushEvent {
        private final long flushesOnStart;
        private final long bytesWrittenOnStart;
        private final long startTimeNanos;

        PageCacheMajorFlushEvent(long flushesOnStart, long bytesWrittenOnStart, long startTimeNanos) {
            this.flushesOnStart = flushesOnStart;
            this.bytesWrittenOnStart = bytesWrittenOnStart;
            this.startTimeNanos = startTimeNanos;
        }

        public FlushEventOpportunity flushEventOpportunity() {
            return new VerboseFlushOpportunity("Page Cache", this.startTimeNanos, this.bytesWrittenOnStart);
        }

        public void close() {
            long pageCacheFlushNanos = VerbosePageCacheTracer.this.clock.nanos() - this.startTimeNanos;
            long bytesWrittenInTotal = VerbosePageCacheTracer.this.flushBytesWritten.get() - this.bytesWrittenOnStart;
            long flushedPagesInTotal = VerbosePageCacheTracer.this.flushedPages.get() - this.flushesOnStart;
            VerbosePageCacheTracer.this.log.info("Page cache flush completed. Flushed %s in %d pages. Flush took: %s. Average speed: %s.", new Object[]{VerbosePageCacheTracer.bytesToString(bytesWrittenInTotal), flushedPagesInTotal, VerbosePageCacheTracer.nanosToString(pageCacheFlushNanos), VerbosePageCacheTracer.flushSpeed(bytesWrittenInTotal, pageCacheFlushNanos)});
        }
    }

    private class FileFlushEvent
    implements MajorFlushEvent {
        private final long startTimeNanos;
        private final String fileName;
        private long flushesOnStart;
        private long bytesWrittenOnStart;

        FileFlushEvent(String fileName, long flushesOnStart, long bytesWrittenOnStart, long startTimeNanos) {
            this.fileName = fileName;
            this.flushesOnStart = flushesOnStart;
            this.bytesWrittenOnStart = bytesWrittenOnStart;
            this.startTimeNanos = startTimeNanos;
        }

        public FlushEventOpportunity flushEventOpportunity() {
            return new VerboseFlushOpportunity(this.fileName, this.startTimeNanos, this.bytesWrittenOnStart);
        }

        public void close() {
            long fileFlushNanos = VerbosePageCacheTracer.this.clock.nanos() - this.startTimeNanos;
            long bytesWrittenInTotal = VerbosePageCacheTracer.this.flushBytesWritten.get() - this.bytesWrittenOnStart;
            long flushedPagesInTotal = VerbosePageCacheTracer.this.flushedPages.get() - this.flushesOnStart;
            VerbosePageCacheTracer.this.log.info("'%s' flush completed. Flushed %s in %d pages. Flush took: %s. Average speed: %s.", new Object[]{this.fileName, VerbosePageCacheTracer.bytesToString(bytesWrittenInTotal), flushedPagesInTotal, VerbosePageCacheTracer.nanosToString(fileFlushNanos), VerbosePageCacheTracer.flushSpeed(bytesWrittenInTotal, fileFlushNanos)});
        }
    }
}

