/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bootstrap;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import reactor.core.publisher.Hooks;

class FabricReactorHooksService
extends LifecycleAdapter {
    private static final Set<Consumer<? super Throwable>> ERROR_CONSUMERS = ConcurrentHashMap.newKeySet();
    private final Consumer<? super Throwable> errorConsumer = throwable -> errorReporter.report("Unhandled error", (Throwable)throwable, (Status)Status.General.UnknownError);

    FabricReactorHooksService(ErrorReporter errorReporter) {
        ERROR_CONSUMERS.add(this.errorConsumer);
    }

    public void stop() {
        ERROR_CONSUMERS.remove(this.errorConsumer);
    }

    static {
        Hooks.onErrorDropped(e -> ERROR_CONSUMERS.forEach(consumer -> consumer.accept(e)));
    }
}

