/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.transaction;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.configuration.Config;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.transaction.FabricTransactionImpl;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.logging.internal.LogService;
import org.neo4j.time.SystemNanoClock;

public class FabricTransactionMonitor
extends TransactionMonitor<FabricMonitoredTransaction> {
    private final Map<FabricTransactionImpl, FabricMonitoredTransaction> transactions = new ConcurrentHashMap<FabricTransactionImpl, FabricMonitoredTransaction>();
    private final SystemNanoClock clock;
    private final FabricConfig fabricConfig;

    public FabricTransactionMonitor(Config config, SystemNanoClock clock, LogService logService, FabricConfig fabricConfig) {
        super(config, clock, logService);
        this.clock = clock;
        this.fabricConfig = fabricConfig;
    }

    public void startMonitoringTransaction(FabricTransactionImpl transaction, FabricTransactionInfo transactionInfo) {
        long startTimeNanos = this.clock.nanos();
        TransactionTimeout timeout = transactionInfo.getTxTimeout() != null ? new TransactionTimeout(transactionInfo.getTxTimeout(), (Status)Status.Transaction.TransactionTimedOutClientConfiguration) : new TransactionTimeout(this.fabricConfig.getTransactionTimeout(), (Status)Status.Transaction.TransactionTimedOut);
        this.transactions.put(transaction, new FabricMonitoredTransaction(transaction, startTimeNanos, timeout));
    }

    public void stopMonitoringTransaction(FabricTransactionImpl transaction) {
        this.transactions.remove(transaction);
    }

    protected Set<FabricMonitoredTransaction> getActiveTransactions() {
        return new HashSet<FabricMonitoredTransaction>(this.transactions.values());
    }

    static class FabricMonitoredTransaction
    implements TransactionMonitor.MonitoredTransaction {
        private final FabricTransactionImpl fabricTransaction;
        private final long startTimeNanos;
        private final TransactionTimeout timeout;

        private FabricMonitoredTransaction(FabricTransactionImpl fabricTransaction, long startTimeNanos, TransactionTimeout timeout) {
            this.fabricTransaction = fabricTransaction;
            this.startTimeNanos = startTimeNanos;
            this.timeout = timeout;
        }

        public long startTimeNanos() {
            return this.startTimeNanos;
        }

        public TransactionTimeout timeout() {
            return this.timeout;
        }

        public boolean isSchemaTransaction() {
            return this.fabricTransaction.isSchemaTransaction();
        }

        public Optional<TerminationMark> terminationMark() {
            return this.fabricTransaction.getTerminationMark();
        }

        public boolean markForTermination(Status reason) {
            return this.fabricTransaction.markForTermination(reason);
        }

        public String getIdentifyingDescription() {
            StringBuilder sb = new StringBuilder();
            sb.append("QueryRouterTransaction[");
            String rawAddress = this.fabricTransaction.getTransactionInfo().getClientConnectionInfo().clientAddress();
            String address = rawAddress == null ? "embedded" : rawAddress;
            sb.append("clientAddress=").append(address);
            AuthSubject authSubject = this.fabricTransaction.getTransactionInfo().getLoginContext().subject();
            if (authSubject != AuthSubject.ANONYMOUS && authSubject != AuthSubject.AUTH_DISABLED) {
                sb.append(",").append("username=").append(authSubject.executingUser());
            }
            sb.append("]");
            return sb.toString();
        }

        public TransactionInitializationTrace transactionInitialisationTrace() {
            return this.fabricTransaction.getInitializationTrace();
        }
    }
}

