/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import org.apache.lucene.analysis.Analyzer;
import org.neo4j.function.Factory;
import org.neo4j.kernel.api.impl.fulltext.DatabaseFulltextIndex;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.IndexUpdateSink;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextIndex;
import org.neo4j.kernel.api.impl.fulltext.NullIndexUpdateSink;
import org.neo4j.kernel.api.impl.fulltext.ReadOnlyFulltextIndex;
import org.neo4j.kernel.api.impl.fulltext.WritableFulltextIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.ReadOnlyIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.TokenHolder;

public class FulltextIndexBuilder
extends AbstractLuceneIndexBuilder<FulltextIndexBuilder> {
    private final FulltextIndexDescriptor descriptor;
    private final TokenHolder propertyKeyTokenHolder;
    private boolean populating;
    private IndexUpdateSink indexUpdateSink = NullIndexUpdateSink.INSTANCE;

    private FulltextIndexBuilder(FulltextIndexDescriptor descriptor, Config config, TokenHolder propertyKeyTokenHolder) {
        super(config);
        this.descriptor = descriptor;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
    }

    public static FulltextIndexBuilder create(FulltextIndexDescriptor descriptor, Config config, TokenHolder propertyKeyTokenHolder) {
        return new FulltextIndexBuilder(descriptor, config, propertyKeyTokenHolder);
    }

    FulltextIndexBuilder withPopulatingMode(boolean isPopulating) {
        this.populating = isPopulating;
        return this;
    }

    FulltextIndexBuilder withIndexUpdateSink(IndexUpdateSink indexUpdateSink) {
        this.indexUpdateSink = indexUpdateSink;
        return this;
    }

    public DatabaseFulltextIndex build() {
        if (this.isReadOnly()) {
            ReadOnlyIndexPartitionFactory partitionFactory = new ReadOnlyIndexPartitionFactory();
            LuceneFulltextIndex fulltextIndex = new LuceneFulltextIndex(this.storageBuilder.build(), (IndexPartitionFactory)partitionFactory, this.descriptor, this.propertyKeyTokenHolder);
            return new ReadOnlyFulltextIndex(fulltextIndex);
        }
        Factory writerConfigFactory = this.populating ? () -> IndexWriterConfigs.population((Analyzer)this.descriptor.analyzer()) : () -> IndexWriterConfigs.standard((Analyzer)this.descriptor.analyzer());
        WritableIndexPartitionFactory partitionFactory = new WritableIndexPartitionFactory(writerConfigFactory);
        LuceneFulltextIndex fulltextIndex = new LuceneFulltextIndex(this.storageBuilder.build(), (IndexPartitionFactory)partitionFactory, this.descriptor, this.propertyKeyTokenHolder);
        return new WritableFulltextIndex(this.indexUpdateSink, fulltextIndex);
    }
}

