/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Properties;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.lock.ResourceType;

class FulltextSchemaDescriptor
implements SchemaDescriptor {
    private final SchemaDescriptor schema;
    private final Properties indexConfiguration;

    FulltextSchemaDescriptor(SchemaDescriptor schema, Properties indexConfiguration) {
        this.schema = schema;
        this.indexConfiguration = indexConfiguration;
    }

    public boolean isAffected(long[] entityTokenIds) {
        return this.schema.isAffected(entityTokenIds);
    }

    public <R> R computeWith(SchemaComputer<R> computer) {
        return (R)this.schema.computeWith(computer);
    }

    public void processWith(SchemaProcessor processor) {
        this.schema.processWith(processor);
    }

    public String userDescription(TokenNameLookup tokenNameLookup) {
        return this.schema.userDescription(tokenNameLookup);
    }

    public int[] getPropertyIds() {
        return this.schema.getPropertyIds();
    }

    public int getPropertyId() {
        return this.schema.getPropertyId();
    }

    public int[] getEntityTokenIds() {
        return this.schema.getEntityTokenIds();
    }

    public int keyId() {
        return this.schema.keyId();
    }

    public ResourceType keyType() {
        return this.schema.keyType();
    }

    public EntityType entityType() {
        return this.schema.entityType();
    }

    public SchemaDescriptor.PropertySchemaType propertySchemaType() {
        return this.schema.propertySchemaType();
    }

    public SchemaDescriptor schema() {
        return this;
    }

    public int hashCode() {
        return this.schema.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FulltextSchemaDescriptor) {
            return this.schema.equals(((FulltextSchemaDescriptor)obj).schema);
        }
        return this.schema.equals(obj);
    }

    Properties getIndexConfiguration() {
        return this.indexConfiguration;
    }

    boolean isEventuallyConsistent() {
        return Boolean.parseBoolean(this.indexConfiguration.getProperty("eventually_consistent"));
    }
}

