/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext.analyzer.providers;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.email.UAX29URLEmailAnalyzer;
import org.neo4j.graphdb.schema.AnalyzerProvider;

public class UrlOrEmail
extends AnalyzerProvider {
    public UrlOrEmail() {
        this("url_or_email");
    }

    private UrlOrEmail(String name) {
        super(name);
    }

    @Override
    public Analyzer createAnalyzer() {
        return new UAX29URLEmailAnalyzer();
    }

    @Override
    public String description() {
        return "Tokenizes into sequences of alpha-numeric, numeric, URL, email, southeast asian terms, and into terms of individual ideographic and hiragana characters. English stop words are filtered out.";
    }

    public static class EmailAnalyzer
    extends UrlOrEmail {
        public EmailAnalyzer() {
            super("email");
        }
    }

    public static class UrlAnalyzer
    extends UrlOrEmail {
        public UrlAnalyzer() {
            super("url");
        }
    }
}

