/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.collection.trackable.HeapTrackingLongArrayList;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdUtils;
import org.neo4j.internal.id.range.PageIdRange;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;

class BufferingIdGenerator
extends IdGenerator.Delegate {
    private static final int MAX_BUFFERED_RANGES = 1000;
    private final ConcurrentLinkedQueue<PageIdRange> rangeCache = new ConcurrentLinkedQueue();
    private final BufferingIdGeneratorFactory bufferedFactory;
    private final int idTypeOrdinal;
    private final MemoryTracker memoryTracker;
    private final Runnable collector;
    private HeapTrackingLongArrayList bufferedDeletedIds;

    BufferingIdGenerator(BufferingIdGeneratorFactory bufferedFactory, IdGenerator delegate, int idTypeOrdinal, MemoryTracker memoryTracker, Runnable collector) {
        super(delegate);
        this.bufferedFactory = bufferedFactory;
        this.idTypeOrdinal = idTypeOrdinal;
        this.memoryTracker = memoryTracker;
        this.collector = collector;
        this.newFreeBuffer();
    }

    private void newFreeBuffer() {
        this.bufferedDeletedIds = HeapTrackingLongArrayList.newLongArrayList((int)10, (MemoryTracker)this.memoryTracker);
    }

    @Override
    public PageIdRange nextPageRange(CursorContext cursorContext, int idsPerPage) {
        PageIdRange range = this.rangeCache.poll();
        if (range != null) {
            return range;
        }
        return this.delegate.nextPageRange(cursorContext, idsPerPage);
    }

    @Override
    public void releasePageRange(PageIdRange range, CursorContext cursorContext) {
        if (this.rangeCache.size() < 1000 && range.hasNext()) {
            this.rangeCache.add(range);
        } else {
            this.delegate.releasePageRange(range, cursorContext);
        }
    }

    @Override
    public void close() {
        this.releaseRanges();
        this.bufferedFactory.release(this.idType());
        this.delegate.close();
    }

    @Override
    public IdGenerator.TransactionalMarker transactionalMarker(CursorContext cursorContext) {
        IdGenerator.TransactionalMarker actualMarker = super.transactionalMarker(cursorContext);
        if (!this.allocationEnabled()) {
            return actualMarker;
        }
        return new IdGenerator.TransactionalMarker.Delegate(actualMarker){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void markDeleted(long id, int numberOfIds) {
                this.actual.markDeleted(id, numberOfIds);
                BufferingIdGenerator bufferingIdGenerator = BufferingIdGenerator.this;
                synchronized (bufferingIdGenerator) {
                    BufferingIdGenerator.this.bufferedDeletedIds.add(IdUtils.combinedIdAndNumberOfIds(id, numberOfIds, false));
                }
                if (BufferingIdGenerator.this.bufferedDeletedIds.size() > 10000) {
                    BufferingIdGenerator.this.collector.run();
                }
            }
        };
    }

    @Override
    public synchronized void clearCache(boolean allocationEnabled, CursorContext cursorContext) {
        if (!this.bufferedDeletedIds.isEmpty()) {
            this.newFreeBuffer();
        }
        this.delegate.clearCache(allocationEnabled, cursorContext);
    }

    public void releaseRanges() {
        if (!this.rangeCache.isEmpty()) {
            this.rangeCache.forEach(pageIdRange -> this.delegate.releasePageRange((PageIdRange)pageIdRange, CursorContext.NULL_CONTEXT));
            this.rangeCache.clear();
        }
    }

    synchronized void collectBufferedIds(List<BufferingIdGeneratorFactory.IdBuffer> idBuffers) {
        if (!this.bufferedDeletedIds.isEmpty()) {
            idBuffers.add(new BufferingIdGeneratorFactory.IdBuffer(this.idTypeOrdinal, this.bufferedDeletedIds));
            this.newFreeBuffer();
        }
    }
}

