/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.io.pagecache.context.CursorContext;

public class BatchingIdSequence
implements IdSequence {
    private final long startId;
    private long nextId;

    public BatchingIdSequence() {
        this(0L);
    }

    public BatchingIdSequence(long startId) {
        this.startId = startId;
        this.nextId = startId;
    }

    @Override
    public long nextId(CursorContext ignored) {
        long result = this.peek();
        ++this.nextId;
        return result;
    }

    public void reset() {
        this.nextId = this.startId;
    }

    public void set(long nextId) {
        this.nextId = nextId;
    }

    public long peek() {
        if (IdValidator.isReservedId(this.nextId)) {
            ++this.nextId;
        }
        return this.nextId;
    }
}

