/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.File;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreePointerType;
import org.neo4j.io.pagecache.PageCursor;

class RightmostInChain {
    private final File file;
    private long currentRightmostNode = 0L;
    private long currentRightmostRightSiblingPointer = 0L;
    private long currentRightmostRightSiblingPointerGeneration;
    private long currentRightmostNodeGeneration;

    RightmostInChain(File file) {
        this.file = file;
    }

    void assertNext(PageCursor cursor, long newRightmostNodeGeneration, long newRightmostLeftSiblingPointer, long newRightmostLeftSiblingPointerGeneration, long newRightmostRightSiblingPointer, long newRightmostRightSiblingPointerGeneration, GBPTreeConsistencyCheckVisitor visitor) {
        long newRightmostNode = cursor.getCurrentPageId();
        this.assertSiblingsAgreeOnBeingSiblings(this.currentRightmostNode, this.currentRightmostNodeGeneration, this.currentRightmostRightSiblingPointer, this.currentRightmostRightSiblingPointerGeneration, newRightmostNode, newRightmostNodeGeneration, newRightmostLeftSiblingPointer, newRightmostLeftSiblingPointerGeneration, visitor);
        this.assertSiblingPointerGeneration(this.currentRightmostNode, this.currentRightmostNodeGeneration, this.currentRightmostRightSiblingPointer, this.currentRightmostRightSiblingPointerGeneration, newRightmostNode, newRightmostNodeGeneration, newRightmostLeftSiblingPointer, newRightmostLeftSiblingPointerGeneration, visitor);
        this.currentRightmostNode = newRightmostNode;
        this.currentRightmostNodeGeneration = newRightmostNodeGeneration;
        this.currentRightmostRightSiblingPointer = newRightmostRightSiblingPointer;
        this.currentRightmostRightSiblingPointerGeneration = newRightmostRightSiblingPointerGeneration;
    }

    private void assertSiblingPointerGeneration(long currentRightmostNode, long currentRightmostNodeGeneration, long currentRightmostRightSiblingPointer, long currentRightmostRightSiblingPointerGeneration, long newRightmostNode, long newRightmostNodeGeneration, long newRightmostLeftSiblingPointer, long newRightmostLeftSiblingPointerGeneration, GBPTreeConsistencyCheckVisitor visitor) {
        if (currentRightmostNodeGeneration > newRightmostLeftSiblingPointerGeneration && currentRightmostNode != 0L) {
            visitor.pointerHasLowerGenerationThanNode(GBPTreePointerType.leftSibling(), newRightmostNode, newRightmostLeftSiblingPointerGeneration, newRightmostLeftSiblingPointer, currentRightmostNodeGeneration, this.file);
        }
        if (currentRightmostRightSiblingPointerGeneration < newRightmostNodeGeneration && currentRightmostRightSiblingPointer != 0L) {
            visitor.pointerHasLowerGenerationThanNode(GBPTreePointerType.rightSibling(), currentRightmostNode, currentRightmostRightSiblingPointerGeneration, currentRightmostRightSiblingPointer, newRightmostNodeGeneration, this.file);
        }
    }

    private void assertSiblingsAgreeOnBeingSiblings(long currentRightmostNode, long currentRightmostNodeGeneration, long currentRightmostRightSiblingPointer, long currentRightmostRightSiblingPointerGeneration, long newRightmostNode, long newRightmostNodeGeneration, long newRightmostLeftSiblingPointer, long newRightmostLeftSiblingPointerGeneration, GBPTreeConsistencyCheckVisitor visitor) {
        boolean siblingsPointToEachOther = true;
        if (newRightmostLeftSiblingPointer != currentRightmostNode) {
            siblingsPointToEachOther = false;
        }
        if (newRightmostNode != currentRightmostRightSiblingPointer && (currentRightmostRightSiblingPointer != 0L || currentRightmostNode != 0L)) {
            siblingsPointToEachOther = false;
        }
        if (!siblingsPointToEachOther) {
            visitor.siblingsDontPointToEachOther(currentRightmostNode, currentRightmostNodeGeneration, currentRightmostRightSiblingPointerGeneration, currentRightmostRightSiblingPointer, newRightmostLeftSiblingPointer, newRightmostLeftSiblingPointerGeneration, newRightmostNode, newRightmostNodeGeneration, this.file);
        }
    }

    void assertLast(GBPTreeConsistencyCheckVisitor visitor) {
        if (this.currentRightmostRightSiblingPointer != 0L) {
            visitor.rightmostNodeHasRightSibling(this.currentRightmostRightSiblingPointer, this.currentRightmostNode, this.file);
        }
    }
}

