/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableLongListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.index.internal.gbptree.GBPTreeInspection;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.TreeStatePair;

public class InspectingVisitor<KEY, VALUE>
extends GBPTreeVisitor.Adaptor<KEY, VALUE> {
    private final MutableLongList internalNodes = LongLists.mutable.empty();
    private final MutableLongList leafNodes = LongLists.mutable.empty();
    private final MutableLongList allNodes = LongLists.mutable.empty();
    private final Map<Long, Integer> allKeyCounts = new HashMap<Long, Integer>();
    private final List<LongList> nodesPerLevel = new ArrayList<LongList>();
    private final List<FreelistEntry> allFreelistEntries = new ArrayList<FreelistEntry>();
    private long rootNode;
    private int lastLevel;
    private TreeState treeState;
    private MutableLongList currentLevelNodes;
    private long currentFreelistPage;

    public InspectingVisitor() {
        this.clear();
    }

    public GBPTreeInspection<KEY, VALUE> get() {
        List<ImmutableLongList> immutableNodesPerLevel = this.nodesPerLevel.stream().map(arg_0 -> ((ImmutableLongListFactory)LongLists.immutable).ofAll(arg_0)).collect(Collectors.toList());
        return new GBPTreeInspection(LongLists.immutable.ofAll((LongIterable)this.internalNodes), LongLists.immutable.ofAll((LongIterable)this.leafNodes), LongLists.immutable.ofAll((LongIterable)this.allNodes), Collections.unmodifiableMap(this.allKeyCounts), immutableNodesPerLevel, Collections.unmodifiableList(this.allFreelistEntries), this.rootNode, this.lastLevel, this.treeState);
    }

    @Override
    public void treeState(Pair<TreeState, TreeState> statePair) {
        this.treeState = TreeStatePair.selectNewestValidState(statePair);
    }

    @Override
    public void beginLevel(int level) {
        this.lastLevel = level;
        this.currentLevelNodes = LongLists.mutable.empty();
        this.nodesPerLevel.add((LongList)this.currentLevelNodes);
    }

    @Override
    public void beginNode(long pageId, boolean isLeaf, long generation, int keyCount) {
        if (this.lastLevel == 0) {
            if (this.rootNode != -1L) {
                throw new IllegalStateException("Expected to only have a single node on level 0");
            }
            this.rootNode = pageId;
        }
        this.currentLevelNodes.add(pageId);
        this.allNodes.add(pageId);
        this.allKeyCounts.put(pageId, keyCount);
        if (isLeaf) {
            this.leafNodes.add(pageId);
        } else {
            this.internalNodes.add(pageId);
        }
    }

    @Override
    public void beginFreelistPage(long pageId) {
        this.currentFreelistPage = pageId;
    }

    @Override
    public void freelistEntry(long pageId, long generation, int pos) {
        this.allFreelistEntries.add(new FreelistEntry(this.currentFreelistPage, pos, pageId, generation));
    }

    private void clear() {
        this.rootNode = -1L;
        this.lastLevel = -1;
    }

    static class FreelistEntry {
        final long freelistPageId;
        final int pos;
        final long id;
        final long generation;

        private FreelistEntry(long freelistPageId, int pos, long id, long generation) {
            this.freelistPageId = freelistPageId;
            this.pos = pos;
            this.id = id;
            this.generation = generation;
        }
    }
}

