/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.File;
import org.neo4j.index.internal.gbptree.GBPTreePointerType;
import org.neo4j.index.internal.gbptree.KeyRange;
import org.neo4j.kernel.impl.annotations.Documented;

public interface GBPTreeConsistencyCheckVisitor<KEY> {
    public static final String indexFile = "Index file: %s.";

    @Documented(value="Index inconsistency: Page: %d is not a tree node page. Index file: %s.")
    public void notATreeNode(long var1, File var3);

    @Documented(value="Index inconsistency: Page: %d has an unknown tree node type: %d.%nIndex file: %s.")
    public void unknownTreeNodeType(long var1, byte var3, File var4);

    @Documented(value="Index inconsistency: Sibling pointers misaligned.%nLeft siblings view:  {%d(%d)}-(%d)->{%d},%nRight siblings view: {%d}<-(%d)-{%d(%d)}.%nIndex file: %s.")
    public void siblingsDontPointToEachOther(long var1, long var3, long var5, long var7, long var9, long var11, long var13, long var15, File var17);

    @Documented(value="Index inconsistency: Expected rightmost node to have no right sibling but was %d. Current rightmost node is %d.%nIndex file: %s.")
    public void rightmostNodeHasRightSibling(long var1, long var3, File var5);

    @Documented(value="Index inconsistency: We ended up on tree node %d which has a newer generation, successor is: %d.%nIndex file: %s.")
    public void pointerToOldVersionOfTreeNode(long var1, long var3, File var5);

    @Documented(value="Index inconsistency: Pointer (%s) in tree node %d has pointer generation %d, but target node %d has a higher generation %d.%nIndex file: %s.")
    public void pointerHasLowerGenerationThanNode(GBPTreePointerType var1, long var2, long var4, long var6, long var8, File var10);

    @Documented(value="Index inconsistency: Keys in tree node %d are out of order.%nIndex file: %s.")
    public void keysOutOfOrderInNode(long var1, File var3);

    @Documented(value="Index inconsistency: Expected range for this tree node is %n%s%n but found %s in position %d, with keyCount %d on page %d.%nIndex file: %s.")
    public void keysLocatedInWrongNode(KeyRange<KEY> var1, KEY var2, int var3, int var4, long var5, File var7);

    @Documented(value="Index inconsistency: Index has a leaked page that will never be reclaimed, pageId=%d.%nIndex file: %s.")
    public void unusedPage(long var1, File var3);

    @Documented(value="Index inconsistency: Tree node has page id larger than registered last id, lastId=%d, pageId=%d.%nIndex file: %s.")
    public void pageIdExceedLastId(long var1, long var3, File var5);

    @Documented(value="Index inconsistency: Tree node %d has inconsistent meta data: %s.%nIndex file: %s.")
    public void nodeMetaInconsistency(long var1, String var3, File var4);

    @Documented(value="Index inconsistency: Page id seen multiple times, this means either active tree node is present in freelist or pointers in tree create a loop, pageId=%d.%nIndex file: %s.")
    public void pageIdSeenMultipleTimes(long var1, File var3);

    @Documented(value="Index inconsistency: Crashed pointer found in tree node %d, pointerType='%s',%nslotA[generation=%d, readPointer=%d, pointer=%d, state=%s],%nslotB[generation=%d, readPointer=%d, pointer=%d, state=%s].%nIndex file: %s.")
    public void crashedPointer(long var1, GBPTreePointerType var3, long var4, long var6, long var8, byte var10, long var11, long var13, long var15, byte var17, File var18);

    @Documented(value="Index inconsistency: Broken pointer found in tree node %d, pointerType='%s',%nslotA[generation=%d, readPointer=%d, pointer=%d, state=%s],%nslotB[generation=%d, readPointer=%d, pointer=%d, state=%s].%nIndex file: %s.")
    public void brokenPointer(long var1, GBPTreePointerType var3, long var4, long var6, long var8, byte var10, long var11, long var13, long var15, byte var17, File var18);

    @Documented(value="Index inconsistency: Unexpected keyCount on pageId %d, keyCount=%d.%nIndex file: %s.")
    public void unreasonableKeyCount(long var1, int var3, File var4);

    @Documented(value="Index inconsistency: Circular reference, child tree node found among parent nodes. Parents:%n%s,%nlevel: %d, pageId: %d.%nIndex file: %s.")
    public void childNodeFoundAmongParentNodes(KeyRange<KEY> var1, int var2, long var3, File var5);

    @Documented(value="Index inconsistency: Caught exception during consistency check: %s")
    public void exception(Exception var1);

    public static class Adaptor<KEY>
    implements GBPTreeConsistencyCheckVisitor<KEY> {
        @Override
        public void notATreeNode(long pageId, File file) {
        }

        @Override
        public void unknownTreeNodeType(long pageId, byte treeNodeType, File file) {
        }

        @Override
        public void siblingsDontPointToEachOther(long leftNode, long leftNodeGeneration, long leftRightSiblingPointerGeneration, long leftRightSiblingPointer, long rightLeftSiblingPointer, long rightLeftSiblingPointerGeneration, long rightNode, long rightNodeGeneration, File file) {
        }

        @Override
        public void rightmostNodeHasRightSibling(long rightSiblingPointer, long rightmostNode, File file) {
        }

        @Override
        public void pointerToOldVersionOfTreeNode(long pageId, long successorPointer, File file) {
        }

        @Override
        public void pointerHasLowerGenerationThanNode(GBPTreePointerType pointerType, long sourceNode, long pointerGeneration, long pointer, long targetNodeGeneration, File file) {
        }

        @Override
        public void keysOutOfOrderInNode(long pageId, File file) {
        }

        @Override
        public void keysLocatedInWrongNode(KeyRange<KEY> range, KEY key, int pos, int keyCount, long pageId, File file) {
        }

        @Override
        public void unusedPage(long pageId, File file) {
        }

        @Override
        public void pageIdExceedLastId(long lastId, long pageId, File file) {
        }

        @Override
        public void nodeMetaInconsistency(long pageId, String message, File file) {
        }

        @Override
        public void pageIdSeenMultipleTimes(long pageId, File file) {
        }

        @Override
        public void crashedPointer(long pageId, GBPTreePointerType pointerType, long generationA, long readPointerA, long pointerA, byte stateA, long generationB, long readPointerB, long pointerB, byte stateB, File file) {
        }

        @Override
        public void brokenPointer(long pageId, GBPTreePointerType pointerType, long generationA, long readPointerA, long pointerA, byte stateA, long generationB, long readPointerB, long pointerB, byte stateB, File file) {
        }

        @Override
        public void unreasonableKeyCount(long pageId, int keyCount, File file) {
        }

        @Override
        public void childNodeFoundAmongParentNodes(KeyRange<KEY> superRange, int level, long pageId, File file) {
        }

        @Override
        public void exception(Exception e) {
        }
    }
}

