/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Meta;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.TreeStatePair;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;

public class GBPTreeStructure<KEY, VALUE> {
    private final TreeNode<KEY, VALUE> node;
    private final Layout<KEY, VALUE> layout;
    private final long stableGeneration;
    private final long unstableGeneration;

    GBPTreeStructure(TreeNode<KEY, VALUE> node, Layout<KEY, VALUE> layout, long stableGeneration, long unstableGeneration) {
        this.node = node;
        this.layout = layout;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
    }

    public static void visitHeader(PageCache pageCache, File file, GBPTreeVisitor visitor) throws IOException {
        try (PagedFile pagedFile = pageCache.map(file, pageCache.pageSize(), new OpenOption[]{StandardOpenOption.READ});
             PageCursor cursor = pagedFile.io(1L, 1);){
            GBPTreeStructure.visitMeta(cursor, visitor);
            GBPTreeStructure.visitTreeState(cursor, visitor);
        }
    }

    private static void visitMeta(PageCursor cursor, GBPTreeVisitor visitor) throws IOException {
        PageCursorUtil.goTo(cursor, "meta page", 0L);
        Meta meta = Meta.read(cursor, null);
        visitor.meta(meta);
    }

    static void visitTreeState(PageCursor cursor, GBPTreeVisitor visitor) throws IOException {
        Pair<TreeState, TreeState> statePair = TreeStatePair.readStatePages(cursor, 1L, 2L);
        visitor.treeState(statePair);
    }

    void visitTree(PageCursor cursor, PageCursor writeCursor, GBPTreeVisitor<KEY, VALUE> visitor) throws IOException {
        long currentPage = cursor.getCurrentPageId();
        Pair<TreeState, TreeState> statePair = TreeStatePair.readStatePages(cursor, 1L, 2L);
        visitor.treeState(statePair);
        TreeNode.goTo(cursor, "back to tree node from reading state", currentPage);
        GBPTreeStructure.assertOnTreeNode(GBPTreeStructure.select(cursor, writeCursor));
        int level = 0;
        do {
            visitor.beginLevel(level);
            long leftmostSibling = cursor.getCurrentPageId();
            this.visitLevel(cursor, writeCursor, visitor);
            visitor.endLevel(level);
            ++level;
            TreeNode.goTo(cursor, "back", leftmostSibling);
        } while (this.goToLeftmostChild(cursor, writeCursor));
    }

    private static void assertOnTreeNode(PageCursor cursor) throws IOException {
        boolean isLeaf;
        boolean isInternal;
        byte nodeType;
        do {
            nodeType = TreeNode.nodeType(cursor);
            isInternal = TreeNode.isInternal(cursor);
            isLeaf = TreeNode.isLeaf(cursor);
        } while (cursor.shouldRetry());
        if (nodeType != 1) {
            throw new IllegalArgumentException("Cursor is not pinned to a tree node page. pageId:" + cursor.getCurrentPageId());
        }
        if (!isInternal && !isLeaf) {
            throw new IllegalArgumentException("Cursor is not pinned to a page containing a tree node. pageId:" + cursor.getCurrentPageId());
        }
    }

    void visitTreeNode(PageCursor cursor, GBPTreeVisitor<KEY, VALUE> visitor) throws IOException {
        int keyCount;
        boolean isLeaf;
        long generation = -1L;
        do {
            isLeaf = TreeNode.isLeaf(cursor);
            keyCount = TreeNode.keyCount(cursor);
            if (!this.node.reasonableKeyCount(keyCount)) {
                cursor.setCursorException("Unexpected keyCount " + keyCount);
            }
            generation = TreeNode.generation(cursor);
        } while (cursor.shouldRetry());
        visitor.beginNode(cursor.getCurrentPageId(), isLeaf, generation, keyCount);
        KEY key = this.layout.newKey();
        VALUE value = this.layout.newValue();
        for (int i = 0; i < keyCount; ++i) {
            long child = -1L;
            do {
                this.node.keyAt(cursor, key, i, isLeaf ? TreeNode.Type.LEAF : TreeNode.Type.INTERNAL);
                if (isLeaf) {
                    this.node.valueAt(cursor, value, i);
                    continue;
                }
                child = GenerationSafePointerPair.pointer(this.node.childAt(cursor, i, this.stableGeneration, this.unstableGeneration));
            } while (cursor.shouldRetry());
            visitor.position(i);
            if (isLeaf) {
                visitor.key(key, isLeaf);
                visitor.value(value);
                continue;
            }
            visitor.child(child);
            visitor.key(key, isLeaf);
        }
        if (!isLeaf) {
            long child;
            do {
                child = GenerationSafePointerPair.pointer(this.node.childAt(cursor, keyCount, this.stableGeneration, this.unstableGeneration));
            } while (cursor.shouldRetry());
            visitor.position(keyCount);
            visitor.child(child);
        }
        visitor.endNode(cursor.getCurrentPageId());
    }

    private boolean goToLeftmostChild(PageCursor readCursor, PageCursor writeCursor) throws IOException {
        boolean isInternal;
        long leftmostSibling = -1L;
        PageCursor cursor = GBPTreeStructure.select(readCursor, writeCursor);
        do {
            if (!(isInternal = TreeNode.isInternal(cursor))) continue;
            leftmostSibling = this.node.childAt(cursor, 0, this.stableGeneration, this.unstableGeneration);
        } while (cursor.shouldRetry());
        if (isInternal) {
            TreeNode.goTo(readCursor, "child", leftmostSibling);
        }
        return isInternal;
    }

    private void visitLevel(PageCursor readCursor, PageCursor writeCursor, GBPTreeVisitor<KEY, VALUE> visitor) throws IOException {
        long rightSibling = -1L;
        do {
            PageCursor cursor = GBPTreeStructure.select(readCursor, writeCursor);
            this.visitTreeNode(cursor, visitor);
            do {
                rightSibling = TreeNode.rightSibling(cursor, this.stableGeneration, this.unstableGeneration);
            } while (cursor.shouldRetry());
            if (!TreeNode.isNode(rightSibling)) continue;
            TreeNode.goTo(readCursor, "right sibling", rightSibling);
        } while (TreeNode.isNode(rightSibling));
    }

    private static PageCursor select(PageCursor readCursor, PageCursor writeCursor) {
        return writeCursor == null ? readCursor : (readCursor.getCurrentPageId() == writeCursor.getCurrentPageId() ? writeCursor : readCursor);
    }
}

