/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;

public class Meta {
    static final byte CURRENT_STATE_VERSION = 0;
    static final byte CURRENT_GBPTREE_VERSION = 0;
    private static final int MASK_BYTE = 255;
    private static final int SHIFT_FORMAT_IDENTIFIER = 0;
    private static final int SHIFT_FORMAT_VERSION = 8;
    private static final int SHIFT_UNUSED_VERSION_SLOT_3 = 16;
    private static final int SHIFT_UNUSED_VERSION_SLOT_4 = 24;
    static final byte UNUSED_VERSION = 0;
    private final byte formatIdentifier;
    private final byte formatVersion;
    private final byte unusedVersionSlot3;
    private final byte unusedVersionSlot4;
    private final int pageSize;
    private final long layoutIdentifier;
    private final int layoutMajorVersion;
    private final int layoutMinorVersion;

    private Meta(byte formatIdentifier, byte formatVersion, byte unusedVersionSlot3, byte unusedVersionSlot4, int pageSize, long layoutIdentifier, int layoutMajorVersion, int layoutMinorVersion) {
        this.formatIdentifier = formatIdentifier;
        this.formatVersion = formatVersion;
        this.unusedVersionSlot3 = unusedVersionSlot3;
        this.unusedVersionSlot4 = unusedVersionSlot4;
        this.pageSize = pageSize;
        this.layoutIdentifier = layoutIdentifier;
        this.layoutMajorVersion = layoutMajorVersion;
        this.layoutMinorVersion = layoutMinorVersion;
    }

    Meta(byte formatIdentifier, byte formatVersion, int pageSize, Layout<?, ?> layout) {
        this(formatIdentifier, formatVersion, 0, 0, pageSize, layout.identifier(), layout.majorVersion(), layout.minorVersion());
    }

    private static Meta parseMeta(int format, int pageSize, long layoutIdentifier, int majorVersion, int minorVersion) {
        return new Meta(Meta.extractIndividualVersion(format, 0), Meta.extractIndividualVersion(format, 8), Meta.extractIndividualVersion(format, 16), Meta.extractIndividualVersion(format, 24), pageSize, layoutIdentifier, majorVersion, minorVersion);
    }

    static Meta read(PageCursor cursor, Layout<?, ?> layout) throws IOException {
        int layoutMinorVersion;
        int layoutMajorVersion;
        long layoutIdentifier;
        int pageSize;
        int format;
        try {
            do {
                format = cursor.getInt();
                pageSize = cursor.getInt();
                layoutIdentifier = cursor.getLong();
                layoutMajorVersion = cursor.getInt();
                layoutMinorVersion = cursor.getInt();
                if (layout == null) continue;
                layout.readMetaData(cursor);
            } while (cursor.shouldRetry());
            PageCursorUtil.checkOutOfBounds(cursor);
            cursor.checkAndClearCursorException();
        }
        catch (CursorException e) {
            throw new MetadataMismatchException(e, "Tried to open, but caught an error while reading meta data. File is expected to be corrupt, try to rebuild.", new Object[0]);
        }
        return Meta.parseMeta(format, pageSize, layoutIdentifier, layoutMajorVersion, layoutMinorVersion);
    }

    public void verify(Layout<?, ?> layout) {
        if (this.unusedVersionSlot3 != 0) {
            throw new MetadataMismatchException("Unexpected version " + this.unusedVersionSlot3 + " for unused version slot 3", new Object[0]);
        }
        if (this.unusedVersionSlot4 != 0) {
            throw new MetadataMismatchException("Unexpected version " + this.unusedVersionSlot4 + " for unused version slot 4", new Object[0]);
        }
        if (!layout.compatibleWith(this.layoutIdentifier, this.layoutMajorVersion, this.layoutMinorVersion)) {
            throw new MetadataMismatchException("Tried to open using layout not compatible with what the index was created with. Created with: layoutIdentifier=%d,majorVersion=%d,minorVersion=%d. Opened with layoutIdentifier=%d,majorVersion=%d,minorVersion=%d", this.layoutIdentifier, this.layoutMajorVersion, this.layoutMinorVersion, layout.identifier(), layout.majorVersion(), layout.minorVersion());
        }
        TreeNodeSelector.Factory formatByLayout = TreeNodeSelector.selectByLayout(layout);
        if (formatByLayout.formatIdentifier() != this.formatIdentifier || formatByLayout.formatVersion() != this.formatVersion) {
            throw new MetadataMismatchException("Tried to open using layout not compatible with what index was created with. Created with formatIdentifier:%d,formatVersion:%d. Opened with formatIdentifier:%d,formatVersion%d", this.formatIdentifier, this.formatVersion, formatByLayout.formatIdentifier(), formatByLayout.formatVersion());
        }
    }

    void write(PageCursor cursor, Layout<?, ?> layout) {
        cursor.putInt(this.allVersionsCombined());
        cursor.putInt(this.getPageSize());
        cursor.putLong(this.getLayoutIdentifier());
        cursor.putInt(this.getLayoutMajorVersion());
        cursor.putInt(this.getLayoutMinorVersion());
        layout.writeMetaData(cursor);
        PageCursorUtil.checkOutOfBounds(cursor);
    }

    private static byte extractIndividualVersion(int format, int shift) {
        return (byte)(format >>> shift & 0xFF);
    }

    private int allVersionsCombined() {
        return this.formatIdentifier << 0 | this.formatVersion << 8;
    }

    int getPageSize() {
        return this.pageSize;
    }

    byte getFormatIdentifier() {
        return this.formatIdentifier;
    }

    byte getFormatVersion() {
        return this.formatVersion;
    }

    byte getUnusedVersionSlot3() {
        return this.unusedVersionSlot3;
    }

    byte getUnusedVersionSlot4() {
        return this.unusedVersionSlot4;
    }

    long getLayoutIdentifier() {
        return this.layoutIdentifier;
    }

    int getLayoutMajorVersion() {
        return this.layoutMajorVersion;
    }

    int getLayoutMinorVersion() {
        return this.layoutMinorVersion;
    }
}

