/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.util.VisibleForTesting;

class GBPTreeLock {
    private static final long writerLockBit = 1L;
    private static final long cleanerLockBit = 2L;
    private long state;
    private static final VarHandle STATE;

    GBPTreeLock() {
    }

    GBPTreeLock copy() {
        GBPTreeLock copy = new GBPTreeLock();
        STATE.setVolatile(copy, STATE.getVolatile(this));
        return copy;
    }

    void writerLock() {
        this.doLock(1L);
    }

    void writerUnlock() {
        this.doUnlock(1L);
    }

    void cleanerLock() {
        this.doLock(2L);
    }

    void cleanerUnlock() {
        this.doUnlock(2L);
    }

    void writerAndCleanerLock() {
        this.doLock(3L);
    }

    void writerAndCleanerUnlock() {
        this.doUnlock(3L);
    }

    private void doLock(long targetLockBit) {
        long newState;
        long currentState;
        do {
            currentState = STATE.getVolatile(this);
            while (!GBPTreeLock.canLock(currentState, targetLockBit)) {
                GBPTreeLock.sleep();
                currentState = STATE.getVolatile(this);
            }
        } while (!STATE.weakCompareAndSet(this, currentState, newState = currentState | targetLockBit));
    }

    private void doUnlock(long targetLockBit) {
        long newState;
        long currentState;
        do {
            if (GBPTreeLock.canUnlock(currentState = STATE.getVolatile(this), targetLockBit)) continue;
            throw new IllegalStateException("Can not unlock lock that is already locked");
        } while (!STATE.weakCompareAndSet(this, currentState, newState = currentState & (targetLockBit ^ 0xFFFFFFFFFFFFFFFFL)));
    }

    private static boolean canLock(long state, long targetLockBit) {
        return (state & targetLockBit) == 0L;
    }

    private static boolean canUnlock(long state, long targetLockBit) {
        return (state & targetLockBit) == targetLockBit;
    }

    private static void sleep() {
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
    }

    @VisibleForTesting
    void forceUnlock() {
        STATE.setVolatile(this, 0);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            STATE = l.findVarHandle(GBPTreeLock.class, "state", Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

