/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.index.internal.gbptree.LongSpinLatch;
import org.neo4j.util.VisibleForTesting;

public class TreeNodeLatchService {
    private final ConcurrentHashMap<Long, LongSpinLatch> latches = new ConcurrentHashMap();

    LongSpinLatch latch(long treeNodeId) {
        LongSpinLatch latch;
        while (!(latch = this.latches.computeIfAbsent(treeNodeId, id -> new LongSpinLatch((long)id, this.latches::remove))).ref()) {
        }
        return latch;
    }

    @VisibleForTesting
    int size() {
        return this.latches.size();
    }
}

