/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.io.pagecache.PageSwapper;

final class SwapperSet {
    private static final SwapperMapping SENTINEL = new SwapperMapping(0, null);
    private static final SwapperMapping TOMBSTONE = new SwapperMapping(0, null);
    private static final int MAX_SWAPPER_ID = 0x1FFFFF;
    private volatile SwapperMapping[] swapperMappings = new SwapperMapping[]{SENTINEL};
    private final PrimitiveIntSet free = Primitive.intSet();
    private final Object vacuumLock = new Object();
    private int freeCounter;

    SwapperSet() {
    }

    SwapperMapping getAllocation(int id) {
        this.checkId(id);
        SwapperMapping swapperMapping = this.swapperMappings[id];
        if (swapperMapping == null || swapperMapping == TOMBSTONE) {
            return null;
        }
        return swapperMapping;
    }

    private void checkId(int id) {
        if (id == 0) {
            throw new IllegalArgumentException("0 is an invalid swapper id");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int allocate(PageSwapper swapper) {
        SwapperMapping[] swapperMappings = this.swapperMappings;
        PrimitiveIntSet primitiveIntSet = this.free;
        synchronized (primitiveIntSet) {
            if (!this.free.isEmpty()) {
                int id = this.free.iterator().next();
                this.free.remove(id);
                swapperMappings[id] = new SwapperMapping(id, swapper);
                this.swapperMappings = swapperMappings;
                return id;
            }
        }
        int id = swapperMappings.length;
        if (id + 1 > 0x1FFFFF) {
            throw new IllegalStateException("All swapper ids are allocated: 2097151");
        }
        swapperMappings = Arrays.copyOf(swapperMappings, id + 1);
        swapperMappings[id] = new SwapperMapping(id, swapper);
        this.swapperMappings = swapperMappings;
        return id;
    }

    synchronized boolean free(int id) {
        this.checkId(id);
        SwapperMapping[] swapperMappings = this.swapperMappings;
        SwapperMapping current = swapperMappings[id];
        if (current == null || current == TOMBSTONE) {
            throw new IllegalStateException("PageSwapper allocation id " + id + " is currently not allocated. Likely a double free bug.");
        }
        swapperMappings[id] = TOMBSTONE;
        this.swapperMappings = swapperMappings;
        ++this.freeCounter;
        if (this.freeCounter == 20) {
            this.freeCounter = 0;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void vacuum(Consumer<IntPredicate> evictAllLoadedPagesCallback) {
        Object object = this.vacuumLock;
        synchronized (object) {
            PrimitiveIntSet freeIds = Primitive.intSet();
            SwapperMapping[] swapperMappings = this.swapperMappings;
            for (int id = 0; id < swapperMappings.length; ++id) {
                SwapperMapping swapperMapping = swapperMappings[id];
                if (swapperMapping != TOMBSTONE) continue;
                freeIds.add(id);
            }
            evictAllLoadedPagesCallback.accept((IntPredicate)freeIds);
            SwapperSet swapperSet = this;
            synchronized (swapperSet) {
                for (int freeId : freeIds) {
                    swapperMappings[freeId] = null;
                }
                this.swapperMappings = swapperMappings;
            }
            swapperSet = this.free;
            synchronized (swapperSet) {
                this.free.addAll(freeIds.iterator());
            }
        }
    }

    synchronized int countAvailableIds() {
        int available = 0x1FFFFF;
        available -= this.swapperMappings.length;
        return available += this.free.size();
    }

    static final class SwapperMapping {
        public final int id;
        public final PageSwapper swapper;

        private SwapperMapping(int id, PageSwapper swapper) {
            this.id = id;
            this.swapper = swapper;
        }
    }
}

