/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.memory.MemoryTracker;

public final class ByteBuffers {
    private ByteBuffers() {
    }

    public static ByteBuffer allocate(int capacity, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap((long)capacity);
        return ByteBuffer.allocate(capacity);
    }

    public static ByteBuffer allocate(int capacity, ByteOrder order, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap((long)capacity);
        return ByteBuffer.allocate(capacity).order(order);
    }

    public static ByteBuffer allocate(int capacity, ByteUnit capacityUnit, MemoryTracker memoryTracker) {
        int bufferCapacity = Math.toIntExact(capacityUnit.toBytes(capacity));
        memoryTracker.allocateHeap((long)bufferCapacity);
        return ByteBuffer.allocate(bufferCapacity);
    }

    public static ByteBuffer allocateDirect(int capacity, MemoryTracker memoryTracker) {
        return UnsafeUtil.allocateByteBuffer((int)capacity, (MemoryTracker)memoryTracker);
    }

    public static void releaseBuffer(ByteBuffer byteBuffer, MemoryTracker memoryTracker) {
        if (!byteBuffer.isDirect()) {
            memoryTracker.releaseHeap((long)byteBuffer.capacity());
            return;
        }
        UnsafeUtil.freeByteBuffer((ByteBuffer)byteBuffer, (MemoryTracker)memoryTracker);
    }
}

