/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;

public final class StandalonePageCacheFactory {
    private StandalonePageCacheFactory() {
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler, PageCacheTracer cacheTracer) {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory(fileSystem);
        int pageSize = 8192;
        return StandalonePageCacheFactory.createPageCache(factory, jobScheduler, cacheTracer, pageSize);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler) {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory(fileSystem);
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        int pageSize = 8192;
        return StandalonePageCacheFactory.createPageCache(factory, jobScheduler, cacheTracer, pageSize);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler, int pageSize) {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory(fileSystem);
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        return StandalonePageCacheFactory.createPageCache(factory, jobScheduler, cacheTracer, pageSize);
    }

    private static PageCache createPageCache(PageSwapperFactory factory, JobScheduler jobScheduler, PageCacheTracer cacheTracer, int pageSize) {
        VersionContextSupplier versionContextSupplier = EmptyVersionContextSupplier.EMPTY;
        long expectedMemory = Math.max(ByteUnit.MebiByte.toBytes(8L), (long)(10 * pageSize));
        MemoryAllocator memoryAllocator = MemoryAllocator.createAllocator(expectedMemory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        return new MuninnPageCache(factory, memoryAllocator, pageSize, cacheTracer, versionContextSupplier, jobScheduler, Clocks.nanoClock(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, IOBufferFactory.DISABLED_BUFFER_FACTORY);
    }
}

