/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.WrappingFileHandle;

public final class StreamFilesRecursive {
    private StreamFilesRecursive() {
    }

    public static Stream<FileHandle> streamFilesRecursive(Path directory, FileSystemAbstraction fs) {
        Path canonicalizedDirectory = directory.toAbsolutePath().normalize();
        List snapshot = StreamFilesRecursive.streamFilesRecursiveInner(canonicalizedDirectory, fs).collect(Collectors.toList());
        return snapshot.stream().map(f -> new WrappingFileHandle((Path)f, canonicalizedDirectory, fs));
    }

    private static Stream<Path> streamFilesRecursiveInner(Path directory, FileSystemAbstraction fs) {
        Path[] files = fs.listFiles(directory);
        if (files == null) {
            if (!fs.fileExists(directory)) {
                return Stream.empty();
            }
            return Stream.of(directory);
        }
        return Stream.of(files).flatMap(f -> fs.isDirectory((Path)f) ? StreamFilesRecursive.streamFilesRecursiveInner(f, fs) : Stream.of(f));
    }
}

