/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapper;

public class SingleFilePageSwapperFactory
implements PageSwapperFactory {
    private final FileSystemAbstraction fs;

    public SingleFilePageSwapperFactory(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    @Override
    public PageSwapper createPageSwapper(Path file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist, boolean useDirectIO) throws IOException {
        if (!createIfNotExist && !this.fs.fileExists(file)) {
            throw new NoSuchFileException(file.toString(), null, "Cannot map non-existing file");
        }
        return new SingleFilePageSwapper(file, this.fs, filePageSize, onEviction, useDirectIO);
    }

    @Override
    public void close() {
    }
}

