/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;

public interface PageCache
extends AutoCloseable {
    public static final int PAGE_SIZE = 8192;

    default public PagedFile map(Path path, int pageSize, String databaseName) throws IOException {
        return this.map(path, pageSize, databaseName, (ImmutableSet<OpenOption>)Sets.immutable.empty());
    }

    default public PagedFile map(Path path, int pageSize, String databaseName, ImmutableSet<OpenOption> openOptions) throws IOException {
        return this.map(path, pageSize, databaseName, openOptions, IOController.DISABLED);
    }

    public PagedFile map(Path var1, int var2, String var3, ImmutableSet<OpenOption> var4, IOController var5) throws IOException;

    public Optional<PagedFile> getExistingMapping(Path var1) throws IOException;

    public List<PagedFile> listExistingMappings() throws IOException;

    public void flushAndForce() throws IOException;

    @Override
    public void close();

    public int pageSize();

    public long maxCachedPages();

    public IOBufferFactory getBufferFactory();
}

