/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.Preconditions;
import org.neo4j.util.concurrent.BinaryLatch;

final class LatchMap {
    static final int DEFAULT_FAULT_LOCK_STRIPING = 128;
    static final int faultLockStriping = FeatureToggles.getInteger(LatchMap.class, (String)"faultLockStriping", (int)128);
    private final Latch[] latches;
    private static final VarHandle LATCHES_ARRAY = MethodHandles.arrayElementVarHandle(Latch[].class);
    private final long faultLockMask;

    LatchMap(int size) {
        Preconditions.requirePowerOfTwo((long)size);
        this.latches = new Latch[size];
        this.faultLockMask = size - 1;
    }

    private void releaseLatch(int index) {
        LATCHES_ARRAY.setVolatile(this.latches, index, null);
    }

    private boolean tryInsertLatch(int index, Latch latch) {
        return LATCHES_ARRAY.compareAndSet(this.latches, index, null, latch);
    }

    private Latch getLatch(int index) {
        return LATCHES_ARRAY.getVolatile(this.latches, index);
    }

    Latch takeOrAwaitLatch(long identifier) {
        int index = this.index(identifier);
        Latch latch = this.getLatch(index);
        while (latch == null) {
            latch = new Latch(this, index);
            if (this.tryInsertLatch(index, latch)) {
                return latch;
            }
            latch = this.getLatch(index);
        }
        latch.await();
        return null;
    }

    private int index(long identifier) {
        return (int)(identifier & this.faultLockMask);
    }

    static final class Latch
    extends BinaryLatch {
        private final LatchMap latchMap;
        private final int index;

        Latch(LatchMap latchMap, int index) {
            this.latchMap = latchMap;
            this.index = index;
        }

        public void release() {
            this.latchMap.releaseLatch(this.index);
            super.release();
        }
    }
}

