/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public enum ByteUnit {
    Byte(0L, "B"),
    KibiByte(1L, "KiB", "KB", "K", "kB", "kb", "k"),
    MebiByte(2L, "MiB", "MB", "M", "mB", "mb", "m"),
    GibiByte(3L, "GiB", "GB", "G", "gB", "gb", "g"),
    TebiByte(4L, "TiB", "TB"),
    PebiByte(5L, "PiB", "PB"),
    ExbiByte(6L, "EiB", "EB");

    public static final long ONE_KIBI_BYTE;
    public static final long ONE_MEBI_BYTE;
    public static final long ONE_GIBI_BYTE;
    public static final long ONE_TEBI_BYTE;
    public static final String VALID_MULTIPLIERS;
    private static final long EIC_MULTIPLIER = 1024L;
    private final long factor;
    private final String shortName;
    private final String[] names;

    private ByteUnit(long power, String ... names) {
        this.factor = ByteUnit.factorFromPower(power);
        this.shortName = names[0];
        this.names = names;
    }

    private static long factorFromPower(long power) {
        if (power == 0L) {
            return 1L;
        }
        long product = 1024L;
        int i = 0;
        while ((long)i < power - 1L) {
            product *= 1024L;
            ++i;
        }
        return product;
    }

    public String abbreviation() {
        return this.shortName;
    }

    public long convert(long value, ByteUnit toUnit) {
        return this.toBytes(value) / toUnit.factor;
    }

    public long toBytes(long value) {
        return this.factor * value;
    }

    private double toBytesFromDecimal(double value) {
        return (double)this.factor * value;
    }

    public long toKibiBytes(long value) {
        return this.convert(value, KibiByte);
    }

    public long toMebiBytes(long value) {
        return this.convert(value, MebiByte);
    }

    public long toGibiBytes(long value) {
        return this.convert(value, GibiByte);
    }

    public long toTebiBytes(long value) {
        return this.convert(value, TebiByte);
    }

    public long toPebiBytes(long value) {
        return this.convert(value, PebiByte);
    }

    public long toExbiBytes(long value) {
        return this.convert(value, ExbiByte);
    }

    public static long bytes(long bytes) {
        return bytes;
    }

    public static long kibiBytes(long kibibytes) {
        return KibiByte.toBytes(kibibytes);
    }

    public static long mebiBytes(long mebibytes) {
        return MebiByte.toBytes(mebibytes);
    }

    public static long gibiBytes(long gibibytes) {
        return GibiByte.toBytes(gibibytes);
    }

    public static long tebiBytes(long tebibytes) {
        return TebiByte.toBytes(tebibytes);
    }

    public static long pebiBytes(long pebibytes) {
        return PebiByte.toBytes(pebibytes);
    }

    public static long exbiBytes(long exbibytes) {
        return ExbiByte.toBytes(exbibytes);
    }

    private static String bytesToString(long bytes, Locale locale, boolean allowScientificNotation) {
        String format;
        String string = format = allowScientificNotation ? "%.4g%s" : "%.2f%s";
        if (bytes >= ONE_TEBI_BYTE) {
            return String.format(locale, format, (double)bytes / (double)ONE_TEBI_BYTE, ByteUnit.TebiByte.shortName);
        }
        if (bytes >= ONE_GIBI_BYTE) {
            return String.format(locale, format, (double)bytes / (double)ONE_GIBI_BYTE, ByteUnit.GibiByte.shortName);
        }
        if (bytes >= ONE_MEBI_BYTE) {
            return String.format(locale, format, (double)bytes / (double)ONE_MEBI_BYTE, ByteUnit.MebiByte.shortName);
        }
        if (bytes >= ONE_KIBI_BYTE) {
            return String.format(locale, format, (double)bytes / (double)ONE_KIBI_BYTE, ByteUnit.KibiByte.shortName);
        }
        return bytes + ByteUnit.Byte.shortName;
    }

    public static String bytesToString(long bytes) {
        return ByteUnit.bytesToString(bytes, Locale.ROOT, true);
    }

    public static String bytesToStringWithoutScientificNotation(long bytes) {
        return ByteUnit.bytesToString(bytes, Locale.ENGLISH, false);
    }

    public static long parse(String text) {
        String trimmedText = text.trim();
        int len = trimmedText.length();
        int unitCharacters = 0;
        int i = 0;
        NumberFormat numberInstance = NumberFormat.getNumberInstance(Locale.ENGLISH);
        ParsePosition pos = new ParsePosition(i);
        Number number = numberInstance.parse(trimmedText, pos);
        int indexAfterDigits = pos.getIndex();
        if (indexAfterDigits == i) {
            throw ByteUnit.invalidFormat(text);
        }
        ByteUnit.checkValueInRange(number.doubleValue(), text);
        for (i = indexAfterDigits; i < len && Character.isWhitespace(trimmedText.charAt(i)); ++i) {
        }
        int unitStart = i;
        while (i < len && !Character.isWhitespace(trimmedText.charAt(i))) {
            ++i;
            ++unitCharacters;
        }
        if (unitCharacters == 0) {
            return number.longValue();
        }
        ByteUnit unit = ByteUnit.listUnits().get(trimmedText.substring(unitStart, unitStart + unitCharacters));
        if (unit == null) {
            throw ByteUnit.invalidFormat(text);
        }
        double inBytes = unit.toBytesFromDecimal(number.doubleValue());
        ByteUnit.checkValueInRange(inBytes, text);
        return (long)inBytes;
    }

    private static IllegalArgumentException invalidFormat(String text) {
        return new IllegalArgumentException(String.format("'%s' is not a valid size, must be e.g. 10, 5K, 1M, 11G (valid multipliers are %s)", text, VALID_MULTIPLIERS));
    }

    private static void checkValueInRange(double value, String originalValue) {
        if (value < 0.0 || value > 9.223372036854776E18) {
            throw new IllegalArgumentException("'" + originalValue + "' is not a valid size. Value should be between 0 and " + ByteUnit.bytesToStringWithoutScientificNotation(Long.MAX_VALUE));
        }
    }

    private static Map<String, ByteUnit> listUnits() {
        HashMap<String, ByteUnit> units = new HashMap<String, ByteUnit>();
        for (ByteUnit unit : ByteUnit.values()) {
            for (String name : unit.names) {
                units.put(name, unit);
            }
        }
        return units;
    }

    static {
        ONE_KIBI_BYTE = KibiByte.toBytes(1L);
        ONE_MEBI_BYTE = MebiByte.toBytes(1L);
        ONE_GIBI_BYTE = GibiByte.toBytes(1L);
        ONE_TEBI_BYTE = TebiByte.toBytes(1L);
        VALID_MULTIPLIERS = Arrays.stream(ByteUnit.values()).flatMap(unit -> Arrays.stream(unit.names)).collect(Collectors.joining("`, `", "`", "`"));
    }
}

