/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.bufferpool.impl;

import java.util.concurrent.atomic.LongAdder;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;

class MemoryMonitor
extends GlobalMemoryGroupTracker {
    private final LongAdder usedNativeMemory = new LongAdder();
    private final LongAdder usedHeapMemory = new LongAdder();
    private final MemoryTracker memoryTracker = new MemoryTrackerImpl();

    MemoryMonitor(MemoryPools memoryPools) {
        super(memoryPools, MemoryGroup.CENTRAL_BYTE_BUFFER_MANAGER, 0L, false, true, null);
        memoryPools.registerPool((GlobalMemoryGroupTracker)this);
    }

    MemoryTracker getMemoryTracker() {
        return this.memoryTracker;
    }

    public void reserveHeap(long bytes) {
        throw new UnsupportedOperationException();
    }

    public void reserveNative(long bytes) {
        throw new UnsupportedOperationException();
    }

    public void releaseHeap(long bytes) {
        throw new UnsupportedOperationException();
    }

    public void releaseNative(long bytes) {
        throw new UnsupportedOperationException();
    }

    public long totalSize() {
        return this.usedHeap() + this.usedNative();
    }

    public long usedHeap() {
        return this.usedHeapMemory.longValue();
    }

    public long usedNative() {
        return this.usedNativeMemory.longValue();
    }

    public long free() {
        return Long.MAX_VALUE;
    }

    public void setSize(long size) {
        throw new UnsupportedOperationException();
    }

    private class MemoryTrackerImpl
    implements MemoryTracker {
        private MemoryTrackerImpl() {
        }

        public long usedNativeMemory() {
            return MemoryMonitor.this.usedNativeMemory.longValue();
        }

        public long estimatedHeapMemory() {
            return MemoryMonitor.this.usedHeapMemory.longValue();
        }

        public void allocateNative(long bytes) {
            MemoryMonitor.this.usedNativeMemory.add(bytes);
        }

        public void releaseNative(long bytes) {
            MemoryMonitor.this.usedNativeMemory.add(-bytes);
        }

        public void allocateHeap(long bytes) {
            MemoryMonitor.this.usedHeapMemory.add(bytes);
        }

        public void releaseHeap(long bytes) {
            MemoryMonitor.this.usedHeapMemory.add(-bytes);
        }

        public long heapHighWaterMark() {
            throw new UnsupportedOperationException();
        }

        public void reset() {
            throw new UnsupportedOperationException();
        }

        public MemoryTracker getScopedMemoryTracker() {
            throw new UnsupportedOperationException();
        }
    }
}

